/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.lame4j;

import com.sun.jna.Pointer;
import de.maxhenkel.voicechat.lame4j.Lame;
import de.maxhenkel.voicechat.lame4j.ShortArrayBuffer;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;

public class LameDecoder {
    private static final byte[][] MAGIC_BYTES = new byte[][]{{-1, -5}, {-1, -13}, {-1, -14}, {73, 68, 51}};
    private final InputStream inputStream;
    private final Lame.Mp3Data mp3Data;

    public LameDecoder(InputStream inputStream) {
        this.inputStream = inputStream;
        this.mp3Data = new Lame.Mp3Data();
    }

    public short[] decode() throws IOException {
        ShortArrayBuffer sampleBuffer = new ShortArrayBuffer(2048);
        this.decode(sampleBuffer::write);
        return sampleBuffer.toShortArray();
    }

    public void decode(ShortConsumer shortConsumer) throws IOException {
        byte[] buffer = new byte[1024];
        int read = this.inputStream.read(buffer);
        if (read <= 0) {
            return;
        }
        if (!this.hasMagicBytes(buffer)) {
            throw new IOException("Invalid file format");
        }
        Pointer gfp = Lame.INSTANCE.lame_init();
        Lame.INSTANCE.lame_set_decode_only(gfp, 1);
        Pointer hip = Lame.INSTANCE.hip_decode_init();
        short[] bufferLeft = new short[8192];
        short[] bufferRight = new short[8192];
        short[] bufferInterleaved = null;
        while (true) {
            int samplesRead = Lame.INSTANCE.hip_decode1_headers(hip, buffer, read, bufferLeft, bufferRight, this.mp3Data);
            read = 0;
            if (samplesRead > 0) {
                if (this.mp3Data.header_parsed == 0) {
                    throw new IOException("Failed to parse MP3 header");
                }
                if (this.mp3Data.stereo == 1) {
                    shortConsumer.accept(bufferLeft, 0, samplesRead);
                    continue;
                }
                if (bufferInterleaved == null) {
                    bufferInterleaved = new short[bufferLeft.length + bufferRight.length];
                }
                for (int i = 0; i < samplesRead; ++i) {
                    bufferInterleaved[i * 2] = bufferLeft[i];
                    bufferInterleaved[i * 2 + 1] = bufferRight[i];
                }
                shortConsumer.accept(bufferInterleaved, 0, samplesRead * 2);
                continue;
            }
            read = this.inputStream.read(buffer);
            if (read < 0) break;
        }
        Lame.INSTANCE.hip_decode_exit(hip);
        Lame.INSTANCE.lame_close(gfp);
        this.inputStream.close();
    }

    private boolean hasMagicBytes(byte[] data) {
        for (byte[] magicBytes : MAGIC_BYTES) {
            if (data.length < magicBytes.length) {
                return false;
            }
            boolean valid = true;
            for (int i = 0; i < magicBytes.length; ++i) {
                if (data[i] == magicBytes[i]) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            return true;
        }
        return false;
    }

    public boolean headerParsed() {
        return this.mp3Data.header_parsed == 1;
    }

    public int getSampleRate() {
        return this.mp3Data.samplerate;
    }

    public int getChannelCount() {
        return this.mp3Data.stereo;
    }

    public int getBitrate() {
        return this.mp3Data.bitrate;
    }

    public int getFrameSize() {
        return this.mp3Data.framesize;
    }

    public int getSampleSizeInBits() {
        return this.getSampleSizeInBytes() * 8;
    }

    public int getSampleSizeInBytes() {
        return 2;
    }

    public AudioFormat format() {
        if (!this.headerParsed()) {
            return null;
        }
        return new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.getSampleRate(), this.getSampleSizeInBits(), this.getChannelCount(), this.getSampleSizeInBytes() * this.getChannelCount(), this.getSampleRate(), false);
    }

    public static interface ShortConsumer {
        public void accept(short[] var1, int var2, int var3);
    }
}

