/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.macos.VersionCheck;
import de.maxhenkel.voicechat.rnnoise4j.RNNoise;
import de.maxhenkel.voicechat.voice.common.Utils;
import javax.annotation.Nullable;

public class Denoiser {
    private static final int FRAME_SIZE = 480;
    private final Pointer state = RNNoise.INSTANCE.rnnoise_create(null);
    private boolean closed;

    private Denoiser() {
    }

    public short[] denoise(short[] audio) {
        if (this.closed) {
            throw new IllegalStateException("Tried to denoise with a closed denoiser");
        }
        float[] data = Utils.shortsToFloats(audio);
        if (data.length % 480 != 0) {
            throw new IllegalArgumentException("Denoising data frame size is not divisible by 480");
        }
        float[] chunk = new float[480];
        float[] denoisedChunk = new float[480];
        float[] denoised = new float[data.length];
        for (int i = 0; i < data.length / 480; ++i) {
            System.arraycopy(data, 480 * i, chunk, 0, 480);
            RNNoise.INSTANCE.rnnoise_process_frame(this.state, denoisedChunk, chunk);
            System.arraycopy(denoisedChunk, 0, denoised, 480 * i, 480);
        }
        return Utils.floatsToShorts(denoised);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        RNNoise.INSTANCE.rnnoise_destroy(this.state);
    }

    public static boolean supportsRNNoise() {
        if (Platform.isMac()) {
            return VersionCheck.isMinimumVersion(10, 14, 0);
        }
        return true;
    }

    @Nullable
    public static Denoiser createDenoiser() {
        if (!VoicechatClient.CLIENT_CONFIG.useNatives.get().booleanValue()) {
            return null;
        }
        if (!Denoiser.supportsRNNoise()) {
            return null;
        }
        return Utils.createSafe(Denoiser::new, e -> Voicechat.LOGGER.warn("Failed to load RNNoise: {}", (Object)e.getMessage()));
    }
}

