/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.GroupChatManager;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class RenderEvents {
    private static final ResourceLocation MICROPHONE_ICON = new ResourceLocation("voicechat", "textures/icons/microphone.png");
    private static final ResourceLocation WHISPER_MICROPHONE_ICON = new ResourceLocation("voicechat", "textures/icons/microphone_whisper.png");
    private static final ResourceLocation MICROPHONE_OFF_ICON = new ResourceLocation("voicechat", "textures/icons/microphone_off.png");
    private static final ResourceLocation SPEAKER_ICON = new ResourceLocation("voicechat", "textures/icons/speaker.png");
    private static final ResourceLocation WHISPER_SPEAKER_ICON = new ResourceLocation("voicechat", "textures/icons/speaker_whisper.png");
    private static final ResourceLocation SPEAKER_OFF_ICON = new ResourceLocation("voicechat", "textures/icons/speaker_off.png");
    private static final ResourceLocation DISCONNECT_ICON = new ResourceLocation("voicechat", "textures/icons/disconnected.png");
    private static final ResourceLocation GROUP_ICON = new ResourceLocation("voicechat", "textures/icons/group.png");
    private final Minecraft minecraft = Minecraft.func_71410_x();

    public RenderEvents() {
        ClientCompatibilityManager.INSTANCE.onRenderNamePlate(this::onRenderName);
        ClientCompatibilityManager.INSTANCE.onRenderHUD(this::onRenderHUD);
    }

    private void onRenderHUD(float tickDelta) {
        if (!this.shouldShowIcons()) {
            return;
        }
        if (VoicechatClient.CLIENT_CONFIG.hideIcons.get().booleanValue()) {
            return;
        }
        ClientPlayerStateManager manager = ClientManager.getPlayerStateManager();
        ClientVoicechat client = ClientManager.getClient();
        if (manager.isDisconnected()) {
            this.renderIcon(DISCONNECT_ICON);
        } else if (manager.isDisabled()) {
            this.renderIcon(SPEAKER_OFF_ICON);
        } else if (manager.isMuted() && VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get().equals((Object)MicrophoneActivationType.VOICE)) {
            this.renderIcon(MICROPHONE_OFF_ICON);
        } else if (client != null && client.getMicThread() != null) {
            if (client.getMicThread().isWhispering()) {
                this.renderIcon(WHISPER_MICROPHONE_ICON);
            } else if (client.getMicThread().isTalking()) {
                this.renderIcon(MICROPHONE_ICON);
            }
        }
        if (manager.isInGroup() && VoicechatClient.CLIENT_CONFIG.showGroupHUD.get().booleanValue()) {
            GroupChatManager.renderIcons();
        }
    }

    private void renderIcon(ResourceLocation texture) {
        GlStateManager.func_179094_E();
        ScaledResolution scaledResolution = new ScaledResolution(this.minecraft);
        this.minecraft.func_110434_K().func_110577_a(texture);
        int posX = VoicechatClient.CLIENT_CONFIG.hudIconPosX.get();
        int posY = VoicechatClient.CLIENT_CONFIG.hudIconPosY.get();
        if (posX < 0) {
            GlStateManager.func_179137_b((double)scaledResolution.func_78326_a(), (double)0.0, (double)0.0);
        }
        if (posY < 0) {
            GlStateManager.func_179137_b((double)0.0, (double)scaledResolution.func_78328_b(), (double)0.0);
        }
        GlStateManager.func_179137_b((double)posX, (double)posY, (double)0.0);
        float scale = VoicechatClient.CLIENT_CONFIG.hudIconScale.get().floatValue();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        GuiScreen.func_146110_a((int)(posX < 0 ? -16 : 0), (int)(posY < 0 ? -16 : 0), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        GlStateManager.func_179121_F();
    }

    private void onRenderName(Entity entity, String str, double x, double y, double z, int maxDistance) {
        if (!this.shouldShowIcons()) {
            return;
        }
        if (VoicechatClient.CLIENT_CONFIG.hideIcons.get().booleanValue()) {
            return;
        }
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (entity == this.minecraft.field_71439_g) {
            return;
        }
        if (!this.minecraft.field_71474_y.field_74319_N) {
            ClientPlayerStateManager manager = ClientManager.getPlayerStateManager();
            ClientVoicechat client = ClientManager.getClient();
            ClientGroup group = manager.getGroup(player);
            if (client != null && client.getTalkCache().isWhispering((Entity)player)) {
                this.renderPlayerIcon(player, str, x, y, z, maxDistance, WHISPER_SPEAKER_ICON);
            } else if (client != null && client.getTalkCache().isTalking((Entity)player)) {
                this.renderPlayerIcon(player, str, x, y, z, maxDistance, SPEAKER_ICON);
            } else if (manager.isPlayerDisconnected(player)) {
                this.renderPlayerIcon(player, str, x, y, z, maxDistance, DISCONNECT_ICON);
            } else if (group != null && !group.equals(manager.getGroup())) {
                this.renderPlayerIcon(player, str, x, y, z, maxDistance, GROUP_ICON);
            } else if (manager.isPlayerDisabled(player)) {
                this.renderPlayerIcon(player, str, x, y, z, maxDistance, SPEAKER_OFF_ICON);
            }
        }
    }

    private void renderPlayerIcon(EntityPlayer entity, String str, double x, double y, double z, int maxDistance, ResourceLocation texture) {
        RenderManager renderManager = this.minecraft.func_175598_ae();
        boolean isThirdPersonFrontal = renderManager.field_78733_k.field_74320_O == 2;
        int verticalShift = "deadmau5".equals(str) ? -10 : 0;
        float height = entity.field_70131_O + 0.5f - (entity.func_70093_af() ? 0.25f : 0.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)(y + (double)height), (double)z);
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(isThirdPersonFrontal ? -1 : 1) * renderManager.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-0.025f, (float)-0.025f, (float)0.025f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        if (!entity.func_70093_af()) {
            GlStateManager.func_179097_i();
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int halfNameWidth = this.minecraft.field_71466_p.func_78256_a(str) / 2;
        GlStateManager.func_179109_b((float)halfNameWidth, (float)((float)verticalShift - 1.0f), (float)0.0f);
        if (!entity.func_70093_af()) {
            this.drawIcon(texture, true);
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179132_a((boolean)true);
        this.drawIcon(texture, false);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private void drawIcon(ResourceLocation texture, boolean transparent) {
        this.minecraft.func_110434_K().func_110577_a(texture);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(2.0, 10.0, 0.0).func_187315_a(0.0, 1.0).func_181669_b(255, 255, 255, transparent ? 32 : 255).func_181675_d();
        bufferbuilder.func_181662_b(12.0, 10.0, 0.0).func_187315_a(1.0, 1.0).func_181669_b(255, 255, 255, transparent ? 32 : 255).func_181675_d();
        bufferbuilder.func_181662_b(12.0, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181669_b(255, 255, 255, transparent ? 32 : 255).func_181675_d();
        bufferbuilder.func_181662_b(2.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181669_b(255, 255, 255, transparent ? 32 : 255).func_181675_d();
        tessellator.func_78381_a();
    }

    private boolean shouldShowIcons() {
        if (ClientManager.getClient() != null && ClientManager.getClient().getConnection() != null && ClientManager.getClient().getConnection().isAuthenticated()) {
            return true;
        }
        return this.minecraft.func_71401_C() != null && !this.minecraft.func_71401_C().func_71344_c();
    }
}

