/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.sounds;

import com.minecolonies.api.sounds.AbstractWorkerSounds;
import com.minecolonies.api.sounds.ModSoundEvents;
import com.minecolonies.api.util.SoundUtils;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class CitizenSounds
extends AbstractWorkerSounds {
    private static final int PHRASE_CHANCE = 50;

    @Override
    public void playSound(World worldIn, BlockPos position, boolean isFemale, double saturation) {
        if (isFemale) {
            SoundUtils.playSoundAtCitizenWithChance(worldIn, position, Female.say, this.getPhraseChance());
        } else {
            SoundUtils.playSoundAtCitizenWithChance(worldIn, position, Male.say, this.getPhraseChance());
        }
    }

    @Override
    public String getWorkerString() {
        return "";
    }

    @Override
    public int getPhraseChance() {
        return 50;
    }

    @Override
    public void playInteractionSound(World world, BlockPos position, boolean female) {
    }

    public static final class Male {
        public static final SoundEvent say = ModSoundEvents.getSoundID("mob.citizen.male.say");

        private Male() {
        }
    }

    public static final class Female {
        public static final SoundEvent say = ModSoundEvents.getSoundID("mob.citizen.female.say");

        private Female() {
        }
    }
}

