/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ISchematicProvider;
import com.minecolonies.api.colony.buildings.registry.IBuildingDataManager;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHall;
import com.minecolonies.api.colony.buildings.workerbuildings.IWareHouse;
import com.minecolonies.api.colony.managers.interfaces.IBuildingManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.tileentities.AbstractScarescrowTileEntity;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCook;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingFarmer;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingWareHouse;
import com.minecolonies.coremod.colony.buildings.workerbuildings.PostBox;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildBuilding;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import com.minecolonies.coremod.network.messages.ColonyViewBuildingViewMessage;
import com.minecolonies.coremod.network.messages.ColonyViewRemoveBuildingMessage;
import com.minecolonies.coremod.tileentities.TileEntityScarecrow;
import com.minecolonies.coremod.util.ColonyUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingManager
implements IBuildingManager {
    @NotNull
    private final Map<BlockPos, IBuilding> buildings = new HashMap<BlockPos, IBuilding>();
    private final List<BlockPos> fields = new ArrayList<BlockPos>();
    private final List<IWareHouse> wareHouses = new ArrayList<IWareHouse>();
    @Nullable
    private ITownHall townHall;
    private boolean isBuildingsDirty = false;
    private boolean isFieldsDirty = false;
    private final Colony colony;

    public BuildingManager(Colony colony) {
        this.colony = colony;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        this.buildings.clear();
        NBTTagList buildingTagList = compound.func_150295_c("buildings", 10);
        for (int i = 0; i < buildingTagList.func_74745_c(); ++i) {
            NBTTagCompound buildingCompound = buildingTagList.func_150305_b(i);
            IBuilding b = IBuildingDataManager.getInstance().createFrom((IColony)this.colony, buildingCompound);
            if (b == null) continue;
            this.addBuilding(b);
        }
        if (compound.func_74764_b("newFields")) {
            NBTTagList fieldTagList = compound.func_150295_c("newFields", 10);
            for (int i = 0; i < fieldTagList.func_74745_c(); ++i) {
                this.addField(BlockPosUtil.readFromNBT(fieldTagList.func_150305_b(i), "pos"));
            }
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        NBTTagList buildingTagList = new NBTTagList();
        for (IBuilding b : this.buildings.values()) {
            NBTTagCompound buildingCompound = b.serializeNBT();
            buildingTagList.func_74742_a((NBTBase)buildingCompound);
        }
        compound.func_74782_a("buildings", (NBTBase)buildingTagList);
        NBTTagList fieldTagList = new NBTTagList();
        for (BlockPos pos : this.fields) {
            NBTTagCompound fieldCompound = new NBTTagCompound();
            BlockPosUtil.writeToNBT(fieldCompound, "pos", pos);
            fieldTagList.func_74742_a((NBTBase)fieldCompound);
        }
        compound.func_74782_a("newFields", (NBTBase)fieldTagList);
    }

    @Override
    public void tick(TickEvent.ServerTickEvent event) {
        for (IBuilding b : this.buildings.values()) {
            b.onServerTick(event);
        }
    }

    @Override
    public void clearDirty() {
        this.isBuildingsDirty = false;
        this.buildings.values().forEach(ISchematicProvider::clearDirty);
    }

    @Override
    public void sendPackets(Set<EntityPlayerMP> closeSubscribers, Set<EntityPlayerMP> newSubscribers) {
        this.sendBuildingPackets(closeSubscribers, newSubscribers);
        this.sendFieldPackets(closeSubscribers, newSubscribers);
        this.isBuildingsDirty = false;
        this.isFieldsDirty = false;
    }

    @Override
    public void onColonyTick(IColony colony) {
        for (IBuilding building : this.buildings.values()) {
            if (!colony.getWorld().func_175667_e(building.getPosition())) continue;
            building.onColonyTick(colony);
        }
    }

    @Override
    public void markBuildingsDirty() {
        this.isBuildingsDirty = true;
    }

    @Override
    public void cleanUpBuildings(@NotNull IColony colony) {
        ArrayList<IBuilding> removedBuildings = new ArrayList<IBuilding>();
        ArrayList<IBuilding> tempBuildings = new ArrayList<IBuilding>(this.buildings.values());
        for (IBuilding building : tempBuildings) {
            BlockPos loc = building.getPosition();
            if (!colony.getWorld().func_175667_e(loc) || building.isMatchingBlock(colony.getWorld().func_180495_p(loc).func_177230_c())) continue;
            removedBuildings.add(building);
        }
        ArrayList<BlockPos> tempFields = new ArrayList<BlockPos>(this.fields);
        for (BlockPos pos : tempFields) {
            TileEntityScarecrow scarecrow;
            if (!colony.getWorld().func_175667_e(pos) || (scarecrow = (TileEntityScarecrow)colony.getWorld().func_175625_s(pos)) != null) continue;
            this.removeField(pos);
        }
        if (!removedBuildings.isEmpty() && removedBuildings.size() >= this.buildings.values().size()) {
            Log.getLogger().warn("Colony:" + colony.getID() + " is removing all buildings at once. Did you just load a backup? If not there is a chance that colony data got corrupted and you want to restore a backup.");
        }
        removedBuildings.forEach(IBuilding::destroy);
    }

    @Override
    public IBuilding getBuilding(BlockPos buildingId) {
        if (buildingId != null) {
            return this.buildings.get(buildingId);
        }
        return null;
    }

    @Override
    public Map<BlockPos, IBuilding> getBuildings() {
        return Collections.unmodifiableMap(this.buildings);
    }

    @Override
    public ITownHall getTownHall() {
        return this.townHall;
    }

    @Override
    public boolean hasWarehouse() {
        return !this.wareHouses.isEmpty();
    }

    @Override
    public boolean hasTownHall() {
        return this.townHall != null;
    }

    @Override
    public List<BlockPos> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    @Override
    public void addNewField(AbstractScarescrowTileEntity tileEntity, BlockPos pos, World world) {
        this.addField(pos);
        tileEntity.calculateSize(world, pos.func_177977_b());
        this.markFieldsDirty();
    }

    @Override
    public <B extends IBuilding> B getBuilding(BlockPos buildingId, @NotNull Class<B> type) {
        try {
            return (B)((IBuilding)type.cast(this.buildings.get(buildingId)));
        }
        catch (ClassCastException e) {
            Log.getLogger().warn("getBuilding called with wrong type: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public TileEntityScarecrow getFreeField(int owner, World world) {
        for (BlockPos pos : this.fields) {
            TileEntity field = world.func_175625_s(pos);
            if (!(field instanceof TileEntityScarecrow) || ((TileEntityScarecrow)field).isTaken()) continue;
            return (TileEntityScarecrow)field;
        }
        return null;
    }

    @Override
    public IBuilding addNewBuilding(@NotNull AbstractTileEntityColonyBuilding tileEntity, World world) {
        tileEntity.setColony(this.colony);
        if (!this.buildings.containsKey(tileEntity.getPosition())) {
            IBuilding building = IBuildingDataManager.getInstance().createFrom((IColony)this.colony, tileEntity);
            if (building != null) {
                this.addBuilding(building);
                tileEntity.setBuilding(building);
                Log.getLogger().info(String.format("Colony %d - new AbstractBuilding for %s at %s", this.colony.getID(), tileEntity.func_145838_q().getClass(), tileEntity.getPosition()));
                if (tileEntity.isMirrored()) {
                    building.invertMirror();
                }
                if (!tileEntity.getStyle().isEmpty()) {
                    building.setStyle(tileEntity.getStyle());
                } else {
                    building.setStyle(this.colony.getStyle());
                }
                if (world != null && !(building instanceof PostBox)) {
                    building.onPlacement();
                    building.setRotation(BlockUtils.getRotationFromFacing((EnumFacing)world.func_180495_p(building.getPosition()).func_177229_b((IProperty)AbstractBlockHut.FACING)));
                    WorkOrderBuildBuilding workOrder = new WorkOrderBuildBuilding(building, 1);
                    Structure wrapper = new Structure(world, workOrder.getStructureName(), new PlacementSettings());
                    Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> corners = ColonyUtils.calculateCorners(building.getPosition(), world, wrapper, workOrder.getRotation(world), workOrder.isMirrored());
                    building.setCorners((Integer)((Tuple)corners.func_76341_a()).func_76341_a(), (Integer)((Tuple)corners.func_76341_a()).func_76340_b(), (Integer)((Tuple)corners.func_76340_b()).func_76341_a(), (Integer)((Tuple)corners.func_76340_b()).func_76340_b());
                    building.setHeight(wrapper.getHeight());
                    ConstructionTapeHelper.placeConstructionTape(building.getPosition(), corners, world);
                }
                ConstructionTapeHelper.placeConstructionTape(building.getPosition(), building.getCorners(), world);
                this.colony.getRequestManager().onProviderAddedToColony(building);
            } else {
                Log.getLogger().error(String.format("Colony %d unable to create AbstractBuilding for %s at %s", this.colony.getID(), tileEntity.func_145838_q().getClass(), tileEntity.getPosition()));
            }
            this.colony.getCitizenManager().calculateMaxCitizens();
            return building;
        }
        return null;
    }

    @Override
    public void removeBuilding(@NotNull IBuilding building, Set<EntityPlayerMP> subscribers) {
        if (this.buildings.remove(building.getID()) != null) {
            for (EntityPlayerMP player : subscribers) {
                MineColonies.getNetwork().sendTo((IMessage)new ColonyViewRemoveBuildingMessage(this.colony, building.getID()), player);
            }
            Log.getLogger().info(String.format("Colony %d - removed AbstractBuilding %s of type %s", this.colony.getID(), building.getID(), building.getSchematicName()));
        }
        if (building instanceof BuildingTownHall) {
            this.townHall = null;
        } else if (building instanceof BuildingWareHouse) {
            this.wareHouses.remove(building);
        }
        this.colony.getRequestManager().onProviderRemovedFromColony(building);
        for (ICitizenData citizen : this.colony.getCitizenManager().getCitizens()) {
            citizen.onRemoveBuilding(building);
        }
        this.colony.getCitizenManager().calculateMaxCitizens();
    }

    @Override
    public void removeField(BlockPos pos) {
        this.markFieldsDirty();
        this.fields.remove(pos);
        this.colony.markDirty();
    }

    @Override
    public BlockPos getBestRestaurant(AbstractEntityCitizen citizen) {
        double distance = Double.MAX_VALUE;
        BlockPos goodCook = null;
        for (IBuilding building : citizen.getCitizenColonyHandler().getColony().getBuildingManager().getBuildings().values()) {
            double localDistance;
            if (!(building instanceof BuildingCook) || building.getBuildingLevel() <= 0 || !((localDistance = building.getPosition().func_177951_i((Vec3i)citizen.func_180425_c())) < distance)) continue;
            distance = localDistance;
            goodCook = building.getPosition();
        }
        return goodCook;
    }

    @Override
    public void setTownHall(@Nullable ITownHall building) {
        this.townHall = building;
    }

    @Override
    public List<IWareHouse> getWareHouses() {
        return this.wareHouses;
    }

    @Override
    public void removeWareHouse(IWareHouse wareHouse) {
        this.wareHouses.remove(wareHouse);
    }

    private void markFieldsDirty() {
        this.isFieldsDirty = true;
    }

    private void addBuilding(@NotNull IBuilding building) {
        this.buildings.put(building.getID(), building);
        building.markDirty();
        if (building instanceof BuildingTownHall && this.townHall == null) {
            this.townHall = (ITownHall)building;
        }
        if (building instanceof IWareHouse) {
            this.wareHouses.add((IWareHouse)building);
        }
    }

    private void sendBuildingPackets(Set<EntityPlayerMP> closeSubscribers, Set<EntityPlayerMP> newSubscribers) {
        if (this.isBuildingsDirty || !newSubscribers.isEmpty()) {
            Set<EntityPlayerMP> players = this.isBuildingsDirty ? closeSubscribers : newSubscribers;
            for (IBuilding building : this.buildings.values()) {
                if (!building.isDirty() && newSubscribers.isEmpty()) continue;
                players.forEach(player -> MineColonies.getNetwork().sendTo((IMessage)new ColonyViewBuildingViewMessage(building), player));
            }
        }
    }

    private void sendFieldPackets(Set<EntityPlayerMP> closeSubscribers, Set<EntityPlayerMP> newSubscribers) {
        if (this.isFieldsDirty || !newSubscribers.isEmpty()) {
            Set<EntityPlayerMP> players = this.isFieldsDirty ? closeSubscribers : newSubscribers;
            for (IBuilding building : this.buildings.values()) {
                if (!(building instanceof BuildingFarmer)) continue;
                players.forEach(player -> MineColonies.getNetwork().sendTo((IMessage)new ColonyViewBuildingViewMessage(building), player));
            }
        }
    }

    private void addField(@NotNull BlockPos pos) {
        if (!this.fields.contains(pos)) {
            this.fields.add(pos);
        }
        this.colony.markDirty();
    }
}

