/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.management.manager;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeManager;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.util.NBTUtils;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.jetbrains.annotations.NotNull;

public class StandardRecipeManager
implements IRecipeManager {
    private static final String TAG_RECIPES = "recipes";
    private final BiMap<IToken, IRecipeStorage> recipes = HashBiMap.create();

    @Override
    public ImmutableMap<IToken, IRecipeStorage> getRecipes() {
        return ImmutableMap.copyOf(this.recipes);
    }

    @Override
    public IToken addRecipe(IRecipeStorage storage) {
        this.recipes.put((Object)storage.getToken(), (Object)storage);
        return storage.getToken();
    }

    @Override
    public IToken checkOrAddRecipe(IRecipeStorage storage) {
        IToken token = this.getRecipeId(storage);
        if (token == null) {
            return this.addRecipe(storage);
        }
        return token;
    }

    @Override
    public IToken getRecipeId(IRecipeStorage storage) {
        for (Map.Entry tempStorage : this.recipes.entrySet()) {
            if (!((IRecipeStorage)tempStorage.getValue()).equals(storage)) continue;
            return (IToken)tempStorage.getKey();
        }
        return null;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        NBTTagList recipesTagList = this.recipes.entrySet().stream().map(entry -> StandardFactoryController.getInstance().serialize(entry.getValue())).collect(NBTUtils.toNBTTagList());
        compound.func_74782_a(TAG_RECIPES, (NBTBase)recipesTagList);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        this.recipes.putAll(NBTUtils.streamCompound(compound.func_150295_c(TAG_RECIPES, 10)).map(recipeCompound -> (IRecipeStorage)StandardFactoryController.getInstance().deserialize((NBTTagCompound)recipeCompound)).filter(Objects::nonNull).collect(Collectors.toMap(IRecipeStorage::getToken, recipe -> recipe)));
    }
}

