/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.killcommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.coremod.commands.ActionMenuState;
import com.minecolonies.coremod.commands.killcommands.AbstractKillCommand;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;

public class RaiderKillCommand
extends AbstractKillCommand<AbstractEntityMinecoloniesMob> {
    public static final String DESC = "raiders";

    public RaiderKillCommand() {
        super(DESC);
    }

    @Override
    public String getDesc() {
        return DESC;
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull ActionMenuState actionMenuState) throws CommandException {
        this.executeShared(server, sender);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        this.executeShared(server, sender);
    }

    private void executeShared(@NotNull MinecraftServer server, @NotNull ICommandSender sender) throws CommandException {
        if (sender instanceof EntityPlayer && !RaiderKillCommand.isPlayerOpped(sender)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Must be OP to use command"));
            return;
        }
        int entitiesKilled = 0;
        for (AbstractEntityMinecoloniesMob entity2 : server.func_130014_f_().func_175644_a(this.getEntityClass(), entity -> true)) {
            IColony colony = entity2.getColony();
            if (colony != null && entity2.getEventID() > 0) {
                IColonyEvent event = colony.getEventManager().getEventByID(entity2.getEventID());
                if (event == null) continue;
                colony.getEventManager().onEntityDeath((EntityLiving)entity2, entity2.getEventID());
                event.setStatus(EventStatus.DONE);
            }
            entity2.func_70106_y();
            ++entitiesKilled;
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(entitiesKilled + " entities killed"));
    }

    @Override
    public Class<AbstractEntityMinecoloniesMob> getEntityClass() {
        return AbstractEntityMinecoloniesMob.class;
    }
}

