/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.client.util;

import com.blakebr0.ironjetpacks.config.ModConfig;
import com.blakebr0.ironjetpacks.item.ItemJetpack;
import com.blakebr0.ironjetpacks.lib.Tooltips;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;

public class HudHelper {
    private static Minecraft mc = Minecraft.func_71410_x();

    public static HudPos getHudPos() {
        ScaledResolution res = new ScaledResolution(mc);
        int xOffset = ModConfig.confHudOffsetX;
        int yOffset = ModConfig.confHudOffsetY;
        switch (ModConfig.confHudPosMode) {
            case 0: {
                return new HudPos(10 + xOffset, 30 + yOffset, 0);
            }
            case 1: {
                return new HudPos(10 + xOffset, res.func_78328_b() / 2 + yOffset, 0);
            }
            case 2: {
                return new HudPos(10 + xOffset, res.func_78328_b() - 30 + yOffset, 0);
            }
            case 3: {
                return new HudPos(res.func_78326_a() - 8 - xOffset, 30 + yOffset, 1);
            }
            case 4: {
                return new HudPos(res.func_78326_a() - 8 - xOffset, res.func_78328_b() / 2 + yOffset, 1);
            }
            case 5: {
                return new HudPos(res.func_78326_a() - 8 - xOffset, res.func_78328_b() - 30 + yOffset, 1);
            }
        }
        return null;
    }

    public static int getEnergyBarScaled(ItemJetpack jetpack, ItemStack stack) {
        if (jetpack.getJetpack().creative) {
            return 156;
        }
        IEnergyStorage energy = jetpack.getEnergyStorage(stack);
        int i = energy.getEnergyStored();
        int j = energy.getMaxEnergyStored();
        return (int)(j != 0 && i != 0 ? (long)i * 156L / (long)j : 0L);
    }

    public static String getFuel(ItemJetpack jetpack, ItemStack stack) {
        if (jetpack.getJetpack().creative) {
            return Tooltips.INFINITE.get(new Object[0]) + " FE";
        }
        int number = jetpack.getEnergyStorage(stack).getEnergyStored();
        if (number >= 1000000000) {
            return number / 1000000000 + "G FE";
        }
        if (number >= 1000000) {
            return number / 1000000 + "M FE";
        }
        if (number >= 1000) {
            return number / 1000 + "k FE";
        }
        return String.valueOf(number) + " FE";
    }

    public static String getOn(boolean on) {
        return on ? Tooltips.ON.get(10) : Tooltips.OFF.get(12);
    }

    public static class HudPos {
        public int x;
        public int y;
        public int side;

        public HudPos(int x, int y, int side) {
            this.x = x;
            this.y = y;
            this.side = side;
        }
    }
}

