/*
 * Decompiled with CFR 0.152.
 */
package motnt.entity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityBlackholeTNT
extends Entity {
    private static final DataParameter<Integer> FUSE = EntityDataManager.func_187226_a(EntityBlackholeTNT.class, (DataSerializer)DataSerializers.field_187192_b);
    @Nullable
    private EntityLivingBase tntPlacedBy;
    private int fuse = 1200;

    public EntityBlackholeTNT(World worldIn) {
        super(worldIn);
        this.field_70156_m = true;
        this.field_70178_ae = true;
        this.func_70105_a(0.98f, 0.98f);
    }

    public EntityBlackholeTNT(World worldIn, double x, double y, double z, EntityLivingBase igniter) {
        this(worldIn);
        this.func_70107_b(x, y, z);
        float f = (float)(Math.random() * (Math.PI * 2));
        this.field_70159_w = -((float)Math.sin(f)) * 0.02f;
        this.field_70181_x = 0.2f;
        this.field_70179_y = -((float)Math.cos(f)) * 0.02f;
        this.setFuse(1200);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.tntPlacedBy = igniter;
        this.func_189654_d(true);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(FUSE, (Object)1200);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void trapExplosion(int radius, Block block, int meta) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -radius; y <= radius; ++y) {
                    BlockPos pos = new BlockPos((int)this.field_70165_t + x, (int)this.field_70163_u + y, (int)this.field_70161_v + z);
                    this.field_70170_p.func_175655_b(pos, false);
                }
            }
        }
    }

    public void trapExplosion(int radius, Block block) {
        this.trapExplosion(radius, block, 0);
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.04f;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)this.field_70170_p.field_73012_v.nextInt(1);
        this.field_70181_x *= (double)this.field_70170_p.field_73012_v.nextInt(1);
        this.field_70179_y *= (double)this.field_70170_p.field_73012_v.nextInt(1);
        if (this.field_70122_E) {
            this.field_70159_w *= (double)0.7f;
            this.field_70179_y *= (double)0.7f;
        }
        --this.fuse;
        if (this.fuse > 0) {
            this.PullTowards();
            this.GravityLaunch();
            if (this.field_70170_p.field_73012_v.nextInt(15) == 0) {
                this.trapExplosion(5, Blocks.field_150348_b);
            }
        }
        if (this.fuse <= 0) {
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                this.explode();
            }
        } else {
            this.func_70072_I();
            this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private void explode() {
        float f = 4.0f;
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 16.0f), this.field_70161_v, 100.0f, false);
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74777_a("Fuse", (short)this.getFuse());
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.setFuse(compound.func_74765_d("Fuse"));
    }

    public void GravityLaunch() {
        AxisAlignedBB boundingBox = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72314_b(5.0, 5.0, 5.0);
        List entities = this.field_70170_p.func_72872_a(EntityLiving.class, boundingBox);
        for (EntityLiving entity : entities) {
            entity.func_70097_a(DamageSource.field_76380_i, entity.func_110138_aP() / 2.0f);
        }
    }

    public void PullTowards() {
        double z2;
        double y2;
        double x2;
        AxisAlignedBB boundingBox = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72314_b(120.0, 40.0, 120.0);
        List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, boundingBox);
        List entities2 = this.field_70170_p.func_72872_a(Entity.class, boundingBox);
        float speed = 0.08f;
        double x1 = this.field_70165_t + 0.5;
        double y1 = this.field_70163_u + 0.5;
        double z1 = this.field_70161_v + 0.5;
        for (EntityLivingBase entity : entities) {
            if (entity == this.getTntPlacedBy()) continue;
            x2 = entity.field_70165_t;
            y2 = entity.field_70163_u;
            z2 = entity.field_70161_v;
            entity.field_70159_w = (x1 - x2) * (double)speed;
            entity.field_70181_x = (y1 - y2) * (double)speed;
            entity.field_70179_y = (z1 - z2) * (double)speed;
            entity.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, entity.field_70165_t + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)entity.field_70130_N, entity.field_70163_u + this.field_70170_p.field_73012_v.nextDouble() * (double)entity.field_70131_O, entity.field_70161_v + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)entity.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
        }
        for (EntityLivingBase entity : entities2) {
            if (entity == this.getTntPlacedBy()) continue;
            x2 = entity.field_70165_t;
            y2 = entity.field_70163_u;
            z2 = entity.field_70161_v;
            entity.field_70159_w = (x1 - x2) * (double)speed;
            entity.field_70181_x = (y1 - y2) * (double)speed;
            entity.field_70179_y = (z1 - z2) * (double)speed;
            entity.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, entity.field_70165_t + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)entity.field_70130_N, entity.field_70163_u + this.field_70170_p.field_73012_v.nextDouble() * (double)entity.field_70131_O, entity.field_70161_v + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)entity.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Nullable
    public EntityLivingBase getTntPlacedBy() {
        return this.tntPlacedBy;
    }

    public float func_70047_e() {
        return 0.0f;
    }

    public void setFuse(int fuseIn) {
        this.field_70180_af.func_187227_b(FUSE, (Object)fuseIn);
        this.fuse = fuseIn;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (FUSE.equals(key)) {
            this.fuse = this.getFuseDataManager();
        }
    }

    public int getFuseDataManager() {
        return (Integer)this.field_70180_af.func_187225_a(FUSE);
    }

    public int getFuse() {
        return this.fuse;
    }
}

