/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Config(modid="securitycraft", category="options")
@Mod.EventBusSubscriber(modid="securitycraft")
public class ConfigHandler {
    @Config.Ignore
    private static final Logger LOGGER = LogManager.getLogger();
    @Config.Name(value="codebreaker_chance")
    @Config.RangeDouble(min=-1.0, max=1.0)
    @Config.Comment(value={"The chance for the codebreaker to successfully hack a block. 0.33 is 33%. Set to a negative value to disable the codebreaker.", "Using the codebreaker when this is set to 0.0 will still damage the item, while negative values do not damage it."})
    public static double codebreakerChance = 0.33;
    @Config.Name(value="Is admin tool allowed?")
    @Config.LangKey(value="config.securitycraft:allowAdminTool")
    public static boolean allowAdminTool = true;
    @Config.Name(value="Mine(s) spawn fire when detonated?")
    @Config.LangKey(value="config.securitycraft:shouldSpawnFire")
    public static boolean shouldSpawnFire = true;
    @Config.Name(value="Are mines breakable?")
    @Config.LangKey(value="config.securitycraft:ableToBreakMines")
    @Config.RequiresMcRestart
    public static boolean ableToBreakMines = true;
    @Config.Name(value="Craftable level 1 keycard?")
    @Config.LangKey(value="config.securitycraft:ableToCraftKeycard1")
    @Config.RequiresMcRestart
    public static boolean ableToCraftKeycard1 = true;
    @Config.Name(value="Craftable level 2 keycard?")
    @Config.LangKey(value="config.securitycraft:ableToCraftKeycard2")
    @Config.RequiresMcRestart
    public static boolean ableToCraftKeycard2 = true;
    @Config.Name(value="Craftable level 3 keycard?")
    @Config.LangKey(value="config.securitycraft:ableToCraftKeycard3")
    @Config.RequiresMcRestart
    public static boolean ableToCraftKeycard3 = true;
    @Config.Name(value="Craftable level 4 keycard?")
    @Config.LangKey(value="config.securitycraft:ableToCraftKeycard4")
    @Config.RequiresMcRestart
    public static boolean ableToCraftKeycard4 = true;
    @Config.Name(value="Craftable level 5 keycard?")
    @Config.LangKey(value="config.securitycraft:ableToCraftKeycard5")
    @Config.RequiresMcRestart
    public static boolean ableToCraftKeycard5 = true;
    @Config.Name(value="Craftable Limited Use keycard?")
    @Config.LangKey(value="config.securitycraft:ableToCraftLUKeycard")
    @Config.RequiresMcRestart
    public static boolean ableToCraftLUKeycard = true;
    @Config.Name(value="Mines use a smaller explosion?")
    @Config.LangKey(value="config.securitycraft:smallerMineExplosion")
    public static boolean smallerMineExplosion = false;
    @Config.Name(value="Mines explode when broken in Creative?")
    @Config.LangKey(value="config.securitycraft:mineExplodesWhenInCreative")
    public static boolean mineExplodesWhenInCreative = true;
    @Config.Name(value="Do mines' explosions break blocks?")
    @Config.LangKey(value="config.securitycraft:mineExplosionsBreakBlocks")
    public static boolean mineExplosionsBreakBlocks = true;
    @Config.Name(value="Display a 'tip' message at spawn?")
    @Config.LangKey(value="config.securitycraft:sayThanksMessage")
    public static boolean sayThanksMessage = true;
    @Config.Name(value="Should check for updates on Github?")
    @Config.LangKey(value="config.securitycraft:checkForUpdates")
    public static boolean checkForUpdates = true;
    @Config.Name(value="Laser range:")
    @Config.LangKey(value="config.securitycraft:laserBlockRange")
    public static int laserBlockRange = 5;
    @Config.Name(value="Camera Speed when not using LookingGlass:")
    @Config.LangKey(value="config.securitycraft:cameraSpeed")
    @Config.RequiresMcRestart
    public static float cameraSpeed = 2.0f;
    @Config.Name(value="Inventory Scanner range:")
    @Config.LangKey(value="config.securitycraft:inventoryScannerRange")
    public static int inventoryScannerRange = 2;
    @Config.Name(value="Maximum Alarm range:")
    @Config.LangKey(value="config.securitycraft:maxAlarmRange")
    @Config.RangeInt(min=1)
    public static int maxAlarmRange = 100;
    @Config.Name(value="Allow claiming unowned blocks?")
    @Config.LangKey(value="config.securitycraft:allowBlockClaim")
    public static boolean allowBlockClaim = false;
    @Config.Name(value="Respect invisibility?")
    @Config.LangKey(value="config.securitycraft:respectInvisibility")
    public static boolean respectInvisibility = false;
    @Config.Name(value="Darker reinforced block textures?")
    @Config.LangKey(value="config.securitycraft:reinforcedBlockTint")
    public static boolean reinforcedBlockTint = true;
    @Config.Name(value="Craftable mines?")
    @Config.LangKey(value="config.securitycraft:ableToCraftMines")
    public static boolean ableToCraftMines = true;
    @Config.Name(value="Display owner face on retinal scanner?")
    @Config.LangKey(value="config.securitycraft:retinalScannerFace")
    public static boolean retinalScannerFace = true;
    @Config.Name(value="Enable team ownership?")
    @Config.LangKey(value="config.securitycraft:enableTeamOwnership")
    public static boolean enableTeamOwnership = false;
    @Config.Name(value="Trick scanners with player heads?")
    @Config.LangKey(value="config.securitycraft:trickScannersWithPlayerHeads")
    public static boolean trickScannersWithPlayerHeads = false;
    @Config.Name(value="Taser damage")
    @Config.LangKey(value="config.securitycraft:taser_damage")
    @Config.RangeDouble(min=0.0)
    public static double taserDamage = 1.0;
    @Config.Name(value="Powered taser damage")
    @Config.LangKey(value="config.securitycraft:powered_taser_damage")
    @Config.RangeDouble(min=0.0)
    public static double poweredTaserDamage = 2.0;
    @Deprecated
    @Config.Name(value="Taser effects")
    @Config.Comment(value={"Add effects to this list that you want the taser to inflict onto the mobs it hits. One entry corresponds to one effect, and is formatted like this:", "effect_namespace:effect_path|duration|amplifier", "Example: The entry \"minecraft:slowness|20|1\" defines slowness 1 for 1 second (20 ticks = 1 second)."})
    public static String[] taserEffectsValue = new String[]{"minecraft:weakness|200|2", "minecraft:nausea|200|2", "minecraft:slowness|200|2"};
    @Deprecated
    @Config.Name(value="Powered taser effects")
    @Config.Comment(value={"Add effects to this list that you want the powered taser to inflict onto the mobs it hits. One entry corresponds to one effect, and is formatted like this:", "effect_namespace:effect_path|duration|amplifier", "Example: The entry \"minecraft:slowness|20|1\" defines slowness 1 for 1 second (20 ticks = 1 second)."})
    public static String[] poweredTaserEffectsValue = new String[]{"minecraft:weakness|400|5", "minecraft:nausea|400|5", "minecraft:slowness|400|5"};
    @Config.Ignore
    public static final List<Supplier<PotionEffect>> TASER_EFFECTS = new ArrayList<Supplier<PotionEffect>>();
    @Config.Ignore
    public static final List<Supplier<PotionEffect>> POWERED_TASER_EFFECTS = new ArrayList<Supplier<PotionEffect>>();

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID() == "securitycraft") {
            ConfigHandler.loadEffects();
        }
    }

    public static void loadEffects() {
        ConfigHandler.loadEffects(taserEffectsValue, TASER_EFFECTS);
        ConfigHandler.loadEffects(poweredTaserEffectsValue, POWERED_TASER_EFFECTS);
    }

    private static void loadEffects(String[] effectsValue, List<Supplier<PotionEffect>> effects) {
        effects.clear();
        for (String entry : effectsValue) {
            String[] split = entry.split("\\|");
            System.out.println(entry);
            if (split.length != 3) {
                LOGGER.warn("Not enough information provided for effect \"{}\", skipping", (Object)entry);
                continue;
            }
            int duration = Integer.parseInt(split[1]);
            int amplifier = Integer.parseInt(split[2]);
            if (!ConfigHandler.validateValue(duration, entry) || !ConfigHandler.validateValue(amplifier, entry)) continue;
            ResourceLocation effectLocation = new ResourceLocation(split[0]);
            if (!ForgeRegistries.POTIONS.containsKey(effectLocation)) {
                LOGGER.warn("Effect \"{}\" does not exist, skipping", (Object)effectLocation);
                continue;
            }
            effects.add(() -> new PotionEffect((Potion)ForgeRegistries.POTIONS.getValue(effectLocation), duration, amplifier - 1));
        }
    }

    private static boolean validateValue(int value, String entry) {
        if (value <= 0) {
            LOGGER.warn("Value \"{}\" cannot be less than or equal to zero for entry \"{}\", skipping", (Object)value, (Object)entry);
            return false;
        }
        return true;
    }
}

