/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.api.TileEntityNamed;
import net.geforcemods.securitycraft.api.TileEntityOwnable;
import net.geforcemods.securitycraft.entity.EntityBouncingBetty;
import net.geforcemods.securitycraft.entity.EntityBullet;
import net.geforcemods.securitycraft.entity.EntityIMSBomb;
import net.geforcemods.securitycraft.entity.EntitySentry;
import net.geforcemods.securitycraft.entity.camera.EntitySecurityCamera;
import net.geforcemods.securitycraft.itemblocks.ItemBlockCrystalQuartzSlab;
import net.geforcemods.securitycraft.itemblocks.ItemBlockCustomQuartz;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedCompressedBlocks;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedCrystalQuartzSlab;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedDirt;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedLog;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedMetals;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedPlanks;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedPrismarine;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedPurpur;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedSand;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedSandstone;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedSlabs;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedSlabs2;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedStainedBlock;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedStone;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedStoneBrick;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedWalls;
import net.geforcemods.securitycraft.itemblocks.ItemBlockReinforcedWoodSlabs;
import net.geforcemods.securitycraft.items.ItemSCManual;
import net.geforcemods.securitycraft.misc.DyeBriefcaseRecipe;
import net.geforcemods.securitycraft.misc.LimitedUseKeycardRecipe;
import net.geforcemods.securitycraft.misc.PageType;
import net.geforcemods.securitycraft.misc.SCManualPage;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.client.InitSentryAnimation;
import net.geforcemods.securitycraft.network.client.RefreshDiguisedModel;
import net.geforcemods.securitycraft.network.client.SetCameraView;
import net.geforcemods.securitycraft.network.client.SetTrophySystemTarget;
import net.geforcemods.securitycraft.network.client.UpdateLogger;
import net.geforcemods.securitycraft.network.client.UpdateNBTTagOnClient;
import net.geforcemods.securitycraft.network.server.AssembleBlockPocket;
import net.geforcemods.securitycraft.network.server.CheckPassword;
import net.geforcemods.securitycraft.network.server.ClearChangeDetectorServer;
import net.geforcemods.securitycraft.network.server.ClearLoggerServer;
import net.geforcemods.securitycraft.network.server.DismountCamera;
import net.geforcemods.securitycraft.network.server.GiveNightVision;
import net.geforcemods.securitycraft.network.server.MountCamera;
import net.geforcemods.securitycraft.network.server.OpenBriefcaseGui;
import net.geforcemods.securitycraft.network.server.RemoteControlMine;
import net.geforcemods.securitycraft.network.server.RemoveCameraTag;
import net.geforcemods.securitycraft.network.server.RemoveMineFromMRAT;
import net.geforcemods.securitycraft.network.server.RemovePositionFromSSS;
import net.geforcemods.securitycraft.network.server.RemoveSentryFromSRAT;
import net.geforcemods.securitycraft.network.server.SetBriefcaseOwner;
import net.geforcemods.securitycraft.network.server.SetCameraPowered;
import net.geforcemods.securitycraft.network.server.SetGhostSlot;
import net.geforcemods.securitycraft.network.server.SetKeycardUses;
import net.geforcemods.securitycraft.network.server.SetListModuleData;
import net.geforcemods.securitycraft.network.server.SetPassword;
import net.geforcemods.securitycraft.network.server.SetSentryMode;
import net.geforcemods.securitycraft.network.server.SetStateOnDisguiseModule;
import net.geforcemods.securitycraft.network.server.SyncBlockChangeDetector;
import net.geforcemods.securitycraft.network.server.SyncBlockPocketManager;
import net.geforcemods.securitycraft.network.server.SyncKeycardSettings;
import net.geforcemods.securitycraft.network.server.SyncProjector;
import net.geforcemods.securitycraft.network.server.SyncRiftStabilizer;
import net.geforcemods.securitycraft.network.server.SyncSSSSettingsOnServer;
import net.geforcemods.securitycraft.network.server.SyncTENBTTag;
import net.geforcemods.securitycraft.network.server.SyncTrophySystem;
import net.geforcemods.securitycraft.network.server.ToggleBlockPocketManager;
import net.geforcemods.securitycraft.network.server.ToggleModule;
import net.geforcemods.securitycraft.network.server.ToggleOption;
import net.geforcemods.securitycraft.network.server.UpdateSliderValue;
import net.geforcemods.securitycraft.tileentity.TileEntityAlarm;
import net.geforcemods.securitycraft.tileentity.TileEntityAllowlistOnly;
import net.geforcemods.securitycraft.tileentity.TileEntityBlockChangeDetector;
import net.geforcemods.securitycraft.tileentity.TileEntityBlockPocket;
import net.geforcemods.securitycraft.tileentity.TileEntityBlockPocketManager;
import net.geforcemods.securitycraft.tileentity.TileEntityCageTrap;
import net.geforcemods.securitycraft.tileentity.TileEntityClaymore;
import net.geforcemods.securitycraft.tileentity.TileEntityDisguisable;
import net.geforcemods.securitycraft.tileentity.TileEntityDisplayCase;
import net.geforcemods.securitycraft.tileentity.TileEntityIMS;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.geforcemods.securitycraft.tileentity.TileEntityIronFence;
import net.geforcemods.securitycraft.tileentity.TileEntityKeyPanel;
import net.geforcemods.securitycraft.tileentity.TileEntityKeycardReader;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypad;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypadChest;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypadDoor;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypadFurnace;
import net.geforcemods.securitycraft.tileentity.TileEntityLaserBlock;
import net.geforcemods.securitycraft.tileentity.TileEntityLogger;
import net.geforcemods.securitycraft.tileentity.TileEntityMotionLight;
import net.geforcemods.securitycraft.tileentity.TileEntityPortableRadar;
import net.geforcemods.securitycraft.tileentity.TileEntityProjector;
import net.geforcemods.securitycraft.tileentity.TileEntityProtecto;
import net.geforcemods.securitycraft.tileentity.TileEntityReinforcedCauldron;
import net.geforcemods.securitycraft.tileentity.TileEntityReinforcedDoor;
import net.geforcemods.securitycraft.tileentity.TileEntityReinforcedHopper;
import net.geforcemods.securitycraft.tileentity.TileEntityReinforcedIronBars;
import net.geforcemods.securitycraft.tileentity.TileEntityReinforcedPiston;
import net.geforcemods.securitycraft.tileentity.TileEntityRetinalScanner;
import net.geforcemods.securitycraft.tileentity.TileEntityRiftStabilizer;
import net.geforcemods.securitycraft.tileentity.TileEntityScannerDoor;
import net.geforcemods.securitycraft.tileentity.TileEntitySecretSign;
import net.geforcemods.securitycraft.tileentity.TileEntitySecurityCamera;
import net.geforcemods.securitycraft.tileentity.TileEntitySonicSecuritySystem;
import net.geforcemods.securitycraft.tileentity.TileEntityTrackMine;
import net.geforcemods.securitycraft.tileentity.TileEntityTrophySystem;
import net.geforcemods.securitycraft.tileentity.TileEntityValidationOwnable;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.potion.PotionType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.DataSerializerEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class RegistrationHandler {
    private static List<Item> itemBlocks = new ArrayList<Item>();
    private static List<Block> blockPages = new ArrayList<Block>();
    private static Map<PageType, List<Block>> pageTypeBlocks = new EnumMap<PageType, List<Block>>(PageType.class);
    private static Map<PageType, List<ItemStack>> pageTypeStacks = new EnumMap<PageType, List<ItemStack>>(PageType.class);
    private static Map<Block, String> blocksDesignedBy = new HashMap<Block, String>();
    private static Map<Block, Boolean> blockConfigValues = new HashMap<Block, Boolean>();

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        RegistrationHandler.registerBlock(event, SCContent.laserBlock);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.laserField);
        RegistrationHandler.registerBlock(event, SCContent.keypad);
        RegistrationHandler.registerBlock(event, (Block)SCContent.mine, ConfigHandler.ableToCraftMines);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.mineCut);
        RegistrationHandler.registerBlock(event, SCContent.retinalScanner);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.reinforcedDoor);
        RegistrationHandler.registerBlock(event, (Block)SCContent.fakeLava, PageType.NO_PAGE);
        RegistrationHandler.registerBlock(event, SCContent.bogusLavaFlowing, PageType.NO_PAGE);
        RegistrationHandler.registerBlock(event, (Block)SCContent.fakeWater, PageType.NO_PAGE);
        RegistrationHandler.registerBlock(event, SCContent.bogusWaterFlowing, PageType.NO_PAGE);
        RegistrationHandler.registerBlock(event, SCContent.keycardReader);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedIronTrapdoor);
        RegistrationHandler.registerBlock(event, SCContent.bouncingBetty, ConfigHandler.ableToCraftMines);
        RegistrationHandler.registerBlock(event, SCContent.inventoryScanner);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.inventoryScannerField);
        RegistrationHandler.registerBlock(event, SCContent.trackMine, ConfigHandler.ableToCraftMines);
        RegistrationHandler.registerBlock(event, SCContent.cageTrap);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.horizontalReinforcedIronBars);
        RegistrationHandler.registerBlock(event, SCContent.portableRadar);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedIronBars, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.keypadChest);
        RegistrationHandler.registerBlock(event, SCContent.usernameLogger);
        RegistrationHandler.registerBlock(event, SCContent.alarm);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.alarmLit);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStone, (ItemBlock)new ItemBlockReinforcedStone(SCContent.reinforcedStone), PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedSandstone, (ItemBlock)new ItemBlockReinforcedSandstone(SCContent.reinforcedSandstone), PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedDirt, (ItemBlock)new ItemBlockReinforcedDirt(SCContent.reinforcedDirt), PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedCobblestone, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedFencegate);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedWoodPlanks, (ItemBlock)new ItemBlockReinforcedPlanks(SCContent.reinforcedWoodPlanks), PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.panicButton);
        RegistrationHandler.registerBlock(event, SCContent.frame);
        RegistrationHandler.registerBlock(event, SCContent.claymore, ConfigHandler.ableToCraftMines);
        RegistrationHandler.registerBlock(event, SCContent.keypadFurnace);
        RegistrationHandler.registerBlock(event, SCContent.securityCamera);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsOak, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsSpruce, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsCobblestone, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsSandstone, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsBirch, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsJungle, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsAcacia, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsDarkoak, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsStone, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.ironFence);
        RegistrationHandler.registerBlock(event, SCContent.ims, ConfigHandler.ableToCraftMines);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedGlass, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStainedGlass, (ItemBlock)new ItemBlockReinforcedStainedBlock(SCContent.reinforcedStainedGlass), PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedWoodSlabs, (ItemBlock)new ItemBlockReinforcedWoodSlabs(SCContent.reinforcedWoodSlabs), PageType.REINFORCED);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.reinforcedDoubleWoodSlabs);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStoneSlabs, (ItemBlock)new ItemBlockReinforcedSlabs(SCContent.reinforcedStoneSlabs), PageType.REINFORCED);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.reinforcedDoubleStoneSlabs);
        RegistrationHandler.registerBlock(event, SCContent.protecto);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.scannerDoor);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStoneBrick, (ItemBlock)new ItemBlockReinforcedStoneBrick(SCContent.reinforcedStoneBrick), PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsStoneBrick, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedMossyCobblestone, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedBrick, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsBrick, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedNetherBrick, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsNetherBrick, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedHardenedClay, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStainedHardenedClay, (ItemBlock)new ItemBlockReinforcedStainedBlock(SCContent.reinforcedStainedHardenedClay), PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedOldLogs, (ItemBlock)new ItemBlockReinforcedLog(SCContent.reinforcedOldLogs), PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedNewLogs, (ItemBlock)new ItemBlockReinforcedLog(SCContent.reinforcedNewLogs), PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedMetals, (ItemBlock)new ItemBlockReinforcedMetals(SCContent.reinforcedMetals), PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedCompressedBlocks, (ItemBlock)new ItemBlockReinforcedCompressedBlocks(SCContent.reinforcedCompressedBlocks), PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedWool, (ItemBlock)new ItemBlockReinforcedStainedBlock(SCContent.reinforcedWool), PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedQuartz, (ItemBlock)new ItemBlockCustomQuartz(SCContent.reinforcedQuartz), PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsQuartz, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedPrismarine, (ItemBlock)new ItemBlockReinforcedPrismarine(SCContent.reinforcedPrismarine), PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedRedSandstone, (ItemBlock)new ItemBlockReinforcedSandstone(SCContent.reinforcedRedSandstone), PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsRedSandstone, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStoneSlabs2, (ItemBlock)new ItemBlockReinforcedSlabs2(SCContent.reinforcedStoneSlabs2), PageType.REINFORCED);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.reinforcedDoubleStoneSlabs2);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedEndStoneBricks, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedRedNetherBrick, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedPurpur, (ItemBlock)new ItemBlockReinforcedPurpur(SCContent.reinforcedPurpur), PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsPurpur, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedConcrete, (ItemBlock)new ItemBlockReinforcedStainedBlock(SCContent.reinforcedConcrete), PageType.REINFORCED);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.secretSignWall);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.secretSignStanding);
        RegistrationHandler.registerBlock(event, SCContent.motionActivatedLight);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedObsidian, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedNetherrack, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedEndStone, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedSeaLantern, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedBoneBlock, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedGlassPane, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStainedGlassPanes, (ItemBlock)new ItemBlockReinforcedStainedBlock(SCContent.reinforcedStainedGlassPanes), PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedCarpet, (ItemBlock)new ItemBlockReinforcedStainedBlock(SCContent.reinforcedCarpet), PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedGlowstone, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedSand, (ItemBlock)new ItemBlockReinforcedSand(SCContent.reinforcedSand), PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedGravel, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.trophySystem);
        RegistrationHandler.registerBlock(event, SCContent.crystalQuartz, (ItemBlock)new ItemBlockCustomQuartz(SCContent.crystalQuartz), PageType.SINGLE_ITEM);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedCrystalQuartz, (ItemBlock)new ItemBlockCustomQuartz(SCContent.reinforcedCrystalQuartz), PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.crystalQuartzSlab, (ItemBlock)new ItemBlockCrystalQuartzSlab(SCContent.crystalQuartzSlab), PageType.NO_PAGE);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.doubleCrystalQuartzSlab);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedCrystalQuartzSlab, (ItemBlock)new ItemBlockReinforcedCrystalQuartzSlab(SCContent.reinforcedCrystalQuartzSlab), PageType.REINFORCED);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.reinforcedDoubleCrystalQuartzSlab);
        RegistrationHandler.registerBlock(event, SCContent.stairsCrystalQuartz, PageType.NO_PAGE);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStairsCrystalQuartz, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.blockPocketWall);
        RegistrationHandler.registerBlock(event, SCContent.blockPocketManager, "Henzoid");
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStonePressurePlate, PageType.PRESSURE_PLATES);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedWoodenPressurePlate, PageType.PRESSURE_PLATES);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedBookshelf, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedWalls, (ItemBlock)new ItemBlockReinforcedWalls(SCContent.reinforcedWalls), PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStickyPiston, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedPiston, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedPistonHead, null, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedPistonExtension, null, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedObserver, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedRedstoneLamp, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedCobweb, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedGrass, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedSnowBlock, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedIce, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedPackedIce, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedMycelium, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedClay, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedNetherWartBlock, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedGrassPath, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedStoneButton, PageType.BUTTONS);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedWoodenButton, PageType.BUTTONS);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedLever);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedHopper);
        RegistrationHandler.registerBlock(event, SCContent.projector);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.keypadDoor);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedCauldron, PageType.REINFORCED);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.keyPanelFloorCeilingBlock);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.keyPanelWallBlock);
        RegistrationHandler.registerBlock(event, SCContent.sonicSecuritySystem, (ItemBlock)SCContent.sonicSecuritySystemItem, PageType.SINGLE_ITEM);
        RegistrationHandler.registerBlock(event, SCContent.blockChangeDetector);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.sentryDisguise);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedEndRod, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedWhiteGlazedTerracotta, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedOrangeGlazedTerracotta, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedMagentaGlazedTerracotta, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedLightBlueGlazedTerracotta, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedYellowGlazedTerracotta, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedLimeGlazedTerracotta, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedPinkGlazedTerracotta, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedGrayGlazedTerracotta, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedSilverGlazedTerracotta, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedCyanGlazedTerracotta, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedPurpleGlazedTerracotta, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedBlueGlazedTerracotta, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedBrownGlazedTerracotta, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedGreenGlazedTerracotta, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedRedGlazedTerracotta, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedBlackGlazedTerracotta, PageType.REINFORCED);
        RegistrationHandler.registerBlock(event, SCContent.riftStabilizer);
        RegistrationHandler.registerBlock(event, SCContent.displayCase);
        RegistrationHandler.registerBlockMine(event, SCContent.stoneMine);
        RegistrationHandler.registerBlockMine(event, SCContent.dirtMine);
        RegistrationHandler.registerBlockMine(event, SCContent.cobblestoneMine);
        RegistrationHandler.registerBlockMine(event, SCContent.sandMine);
        RegistrationHandler.registerBlockMine(event, SCContent.gravelMine);
        RegistrationHandler.registerBlockMine(event, SCContent.goldOreMine);
        RegistrationHandler.registerBlockMine(event, SCContent.ironOreMine);
        RegistrationHandler.registerBlockMine(event, SCContent.coalOreMine);
        RegistrationHandler.registerBlockMine(event, SCContent.lapisOreMine);
        RegistrationHandler.registerBlockMine(event, SCContent.diamondOreMine);
        RegistrationHandler.registerBlockMine(event, SCContent.redstoneOreMine);
        RegistrationHandler.registerBlockMine(event, SCContent.emeraldOreMine);
        RegistrationHandler.registerBlockMine(event, SCContent.quartzOreMine);
        RegistrationHandler.registerBlock(event, SCContent.furnaceMine, ConfigHandler.ableToCraftMines);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Item item : itemBlocks) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Block block : blockPages) {
            ItemSCManual.PAGES.add(new SCManualPage(Item.func_150898_a((Block)block), PageType.SINGLE_ITEM, Utils.localize(block, new Object[0]), Utils.localize("help." + block.func_149739_a().substring(5) + ".info", new Object[0]), blocksDesignedBy.getOrDefault(block, ""), false, blockConfigValues.getOrDefault(block, true)));
        }
        RegistrationHandler.registerItem(event, SCContent.codebreaker);
        RegistrationHandler.registerItem(event, SCContent.reinforcedDoorItem);
        RegistrationHandler.registerItem(event, SCContent.scannerDoorItem);
        RegistrationHandler.registerItem(event, SCContent.universalBlockRemover);
        RegistrationHandler.registerItem(event, SCContent.keycardLvl1, PageType.KEYCARDS, ConfigHandler.ableToCraftKeycard1);
        RegistrationHandler.registerItem(event, SCContent.keycardLvl2, PageType.KEYCARDS, ConfigHandler.ableToCraftKeycard2);
        RegistrationHandler.registerItem(event, SCContent.keycardLvl3, PageType.KEYCARDS, ConfigHandler.ableToCraftKeycard3);
        RegistrationHandler.registerItem(event, SCContent.keycardLvl4, PageType.KEYCARDS, ConfigHandler.ableToCraftKeycard4);
        RegistrationHandler.registerItem(event, SCContent.keycardLvl5, PageType.KEYCARDS, ConfigHandler.ableToCraftKeycard5);
        RegistrationHandler.registerItem(event, SCContent.limitedUseKeycard, PageType.SINGLE_ITEM, ConfigHandler.ableToCraftLUKeycard);
        RegistrationHandler.registerItem(event, SCContent.remoteAccessMine);
        RegistrationHandler.registerItem(event, SCContent.remoteAccessSentry);
        RegistrationHandler.registerItem(event, SCContent.fWaterBucket);
        RegistrationHandler.registerItem(event, SCContent.fLavaBucket);
        RegistrationHandler.registerItem(event, SCContent.universalBlockModifier);
        RegistrationHandler.registerItem(event, SCContent.redstoneModule);
        RegistrationHandler.registerItem(event, SCContent.allowlistModule);
        RegistrationHandler.registerItem(event, SCContent.denylistModule);
        RegistrationHandler.registerItem(event, SCContent.harmingModule);
        RegistrationHandler.registerItem(event, SCContent.smartModule);
        RegistrationHandler.registerItem(event, SCContent.storageModule);
        RegistrationHandler.registerItem(event, SCContent.disguiseModule);
        RegistrationHandler.registerItem(event, SCContent.speedModule);
        RegistrationHandler.registerItem(event, SCContent.wireCutters);
        RegistrationHandler.registerItem(event, SCContent.adminTool);
        RegistrationHandler.registerItem(event, SCContent.keyPanel);
        RegistrationHandler.registerItem(event, SCContent.cameraMonitor);
        RegistrationHandler.registerItem(event, SCContent.taser);
        RegistrationHandler.registerItem(event, SCContent.scManual);
        RegistrationHandler.registerItem(event, SCContent.universalOwnerChanger);
        RegistrationHandler.registerItem(event, SCContent.universalBlockReinforcerLvL1, PageType.BLOCK_REINFORCERS);
        RegistrationHandler.registerItem(event, SCContent.universalBlockReinforcerLvL2, PageType.BLOCK_REINFORCERS);
        RegistrationHandler.registerItem(event, SCContent.universalBlockReinforcerLvL3, PageType.BLOCK_REINFORCERS);
        RegistrationHandler.registerItem(event, SCContent.briefcase);
        RegistrationHandler.registerItem(event, SCContent.universalKeyChanger);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.taserPowered);
        RegistrationHandler.registerItem(event, SCContent.secretSignItem);
        RegistrationHandler.registerItem(event, SCContent.sentry, PageType.SINGLE_ITEM, true, "Henzoid");
        RegistrationHandler.registerItem(event, SCContent.crystalQuartzItem);
        RegistrationHandler.registerItem(event, SCContent.keypadDoorItem);
        RegistrationHandler.registerItem(event, SCContent.portableTunePlayer);
        SecurityCraft.proxy.registerVariants();
        pageTypeBlocks.forEach((pageType, list) -> {
            if (!pageTypeStacks.containsKey(pageType)) {
                pageTypeStacks.put((PageType)((Object)pageType), new ArrayList());
            }
            list.stream().map(Item::func_150898_a).forEach(item -> {
                if (item != null && item.func_77614_k()) {
                    NonNullList subStacks = NonNullList.func_191196_a();
                    item.func_150895_a(item.func_77640_w(), subStacks);
                    pageTypeStacks.get(pageType).addAll((Collection<ItemStack>)subStacks);
                } else {
                    pageTypeStacks.get(pageType).add(new ItemStack(item));
                }
            });
        });
        pageTypeStacks.remove((Object)PageType.SINGLE_ITEM);
        pageTypeStacks.forEach((pageType, list) -> {
            pageType.setItems(Ingredient.func_193369_a((ItemStack[])list.toArray(new ItemStack[list.size()])));
            ItemSCManual.PAGES.add(new SCManualPage(((ItemStack)list.get(0)).func_77973_b(), (PageType)((Object)pageType), Utils.localize(pageType.getTitle(), new Object[0]), Utils.localize(pageType.getSpecialInfoKey(), new Object[0]), "", !pageType.hasRecipeGrid()));
        });
        itemBlocks = null;
        blockPages = null;
        pageTypeBlocks = null;
        pageTypeStacks = null;
        blocksDesignedBy = null;
        blockConfigValues = null;
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<Block> event) {
        GameRegistry.registerTileEntity(TileEntityOwnable.class, (ResourceLocation)new ResourceLocation("securitycraft:ownable"));
        GameRegistry.registerTileEntity(TileEntityNamed.class, (ResourceLocation)new ResourceLocation("securitycraft:abstract"));
        GameRegistry.registerTileEntity(TileEntityKeypad.class, (ResourceLocation)new ResourceLocation("securitycraft:keypad"));
        GameRegistry.registerTileEntity(TileEntityLaserBlock.class, (ResourceLocation)new ResourceLocation("securitycraft:laser_block"));
        GameRegistry.registerTileEntity(TileEntityCageTrap.class, (ResourceLocation)new ResourceLocation("securitycraft:cage_trap"));
        GameRegistry.registerTileEntity(TileEntityKeycardReader.class, (ResourceLocation)new ResourceLocation("securitycraft:keycard_reader"));
        GameRegistry.registerTileEntity(TileEntityInventoryScanner.class, (ResourceLocation)new ResourceLocation("securitycraft:inventory_scanner"));
        GameRegistry.registerTileEntity(TileEntityPortableRadar.class, (ResourceLocation)new ResourceLocation("securitycraft:portable_radar"));
        GameRegistry.registerTileEntity(TileEntitySecurityCamera.class, (ResourceLocation)new ResourceLocation("securitycraft:security_camera"));
        GameRegistry.registerTileEntity(TileEntityLogger.class, (ResourceLocation)new ResourceLocation("securitycraft:username_logger"));
        GameRegistry.registerTileEntity(TileEntityRetinalScanner.class, (ResourceLocation)new ResourceLocation("securitycraft:retinal_scanner"));
        GameRegistry.registerTileEntity(TileEntityKeypadChest.class, (ResourceLocation)new ResourceLocation("securitycraft:keypad_chest"));
        GameRegistry.registerTileEntity(TileEntityAlarm.class, (ResourceLocation)new ResourceLocation("securitycraft:alarm"));
        GameRegistry.registerTileEntity(TileEntityClaymore.class, (ResourceLocation)new ResourceLocation("securitycraft:claymore"));
        GameRegistry.registerTileEntity(TileEntityKeypadFurnace.class, (ResourceLocation)new ResourceLocation("securitycraft:keypad_furnace"));
        GameRegistry.registerTileEntity(TileEntityIMS.class, (ResourceLocation)new ResourceLocation("securitycraft:ims"));
        GameRegistry.registerTileEntity(TileEntityProtecto.class, (ResourceLocation)new ResourceLocation("securitycraft:protecto"));
        GameRegistry.registerTileEntity(CustomizableSCTE.class, (ResourceLocation)new ResourceLocation("securitycraft:customizable"));
        GameRegistry.registerTileEntity(TileEntityScannerDoor.class, (ResourceLocation)new ResourceLocation("securitycraft:scanner_door"));
        GameRegistry.registerTileEntity(TileEntitySecretSign.class, (ResourceLocation)new ResourceLocation("securitycraft:secret_sign"));
        GameRegistry.registerTileEntity(TileEntityMotionLight.class, (ResourceLocation)new ResourceLocation("securitycraft:motion_light"));
        GameRegistry.registerTileEntity(TileEntityTrackMine.class, (ResourceLocation)new ResourceLocation("securitycraft:track_mine"));
        GameRegistry.registerTileEntity(TileEntityTrophySystem.class, (ResourceLocation)new ResourceLocation("securitycraft:trophy_system"));
        GameRegistry.registerTileEntity(TileEntityBlockPocketManager.class, (ResourceLocation)new ResourceLocation("securitycraft:block_pocket_manager"));
        GameRegistry.registerTileEntity(TileEntityBlockPocket.class, (ResourceLocation)new ResourceLocation("securitycraft:block_pocket"));
        GameRegistry.registerTileEntity(TileEntityAllowlistOnly.class, (ResourceLocation)new ResourceLocation("securitycraft:reinforced_pressure_plate"));
        GameRegistry.registerTileEntity(TileEntityReinforcedHopper.class, (ResourceLocation)new ResourceLocation("securitycraft:reinforced_hopper"));
        GameRegistry.registerTileEntity(TileEntityProjector.class, (ResourceLocation)new ResourceLocation("securitycraft:projector"));
        GameRegistry.registerTileEntity(TileEntityIronFence.class, (ResourceLocation)new ResourceLocation("securitycraft:iron_fence"));
        GameRegistry.registerTileEntity(TileEntityKeypadDoor.class, (ResourceLocation)new ResourceLocation("securitycraft:keypad_door"));
        GameRegistry.registerTileEntity(TileEntityReinforcedIronBars.class, (ResourceLocation)new ResourceLocation("securitycraft:reinforced_iron_bars"));
        GameRegistry.registerTileEntity(TileEntityReinforcedCauldron.class, (ResourceLocation)new ResourceLocation("securitycraft:reinforced_cauldron"));
        GameRegistry.registerTileEntity(TileEntityReinforcedPiston.class, (ResourceLocation)new ResourceLocation("securitycraft:reinforced_piston"));
        GameRegistry.registerTileEntity(TileEntityValidationOwnable.class, (ResourceLocation)new ResourceLocation("securitycraft:validation_ownable"));
        GameRegistry.registerTileEntity(TileEntityKeyPanel.class, (ResourceLocation)new ResourceLocation("securitycraft:key_panel"));
        GameRegistry.registerTileEntity(TileEntitySonicSecuritySystem.class, (ResourceLocation)new ResourceLocation("securitycraft:sonic_security_system"));
        GameRegistry.registerTileEntity(TileEntityReinforcedDoor.class, (ResourceLocation)new ResourceLocation("securitycraft:reinforced_door"));
        GameRegistry.registerTileEntity(TileEntityBlockChangeDetector.class, (ResourceLocation)new ResourceLocation("securitycraft:block_change_detector"));
        GameRegistry.registerTileEntity(TileEntityRiftStabilizer.class, (ResourceLocation)new ResourceLocation("securitycraft:rift_stabilizer"));
        GameRegistry.registerTileEntity(TileEntityDisguisable.class, (ResourceLocation)new ResourceLocation("securitycraft:disguisable"));
        GameRegistry.registerTileEntity(TileEntityDisplayCase.class, (ResourceLocation)new ResourceLocation("securitycraft:display_case"));
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().id(new ResourceLocation("securitycraft", "bouncingbetty"), 0).entity(EntityBouncingBetty.class).name("BBetty").tracker(128, 1, true).build());
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().id(new ResourceLocation("securitycraft", "imsbomb"), 3).entity(EntityIMSBomb.class).name("IMSBomb").tracker(256, 1, true).build());
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().id(new ResourceLocation("securitycraft", "securitycamera"), 4).entity(EntitySecurityCamera.class).name("SecurityCamera").tracker(256, 20, true).build());
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().id(new ResourceLocation("securitycraft", "sentry"), 5).entity(EntitySentry.class).name("Sentry").tracker(256, 1, true).build());
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().id(new ResourceLocation("securitycraft", "bullet"), 6).entity(EntityBullet.class).name("SentryBullet").tracker(256, 1, true).build());
    }

    public static void registerPackets(SimpleNetworkWrapper network) {
        network.registerMessage(SetCameraPowered.Handler.class, SetCameraPowered.class, 1, Side.SERVER);
        network.registerMessage(SyncKeycardSettings.Handler.class, SyncKeycardSettings.class, 3, Side.SERVER);
        network.registerMessage(UpdateLogger.Handler.class, UpdateLogger.class, 4, Side.CLIENT);
        network.registerMessage(UpdateNBTTagOnClient.Handler.class, UpdateNBTTagOnClient.class, 5, Side.CLIENT);
        network.registerMessage(RemoteControlMine.Handler.class, RemoteControlMine.class, 8, Side.SERVER);
        network.registerMessage(GiveNightVision.Handler.class, GiveNightVision.class, 9, Side.SERVER);
        network.registerMessage(SetPassword.Handler.class, SetPassword.class, 12, Side.SERVER);
        network.registerMessage(CheckPassword.Handler.class, CheckPassword.class, 13, Side.SERVER);
        network.registerMessage(SyncTENBTTag.Handler.class, SyncTENBTTag.class, 14, Side.SERVER);
        network.registerMessage(MountCamera.Handler.class, MountCamera.class, 15, Side.SERVER);
        network.registerMessage(OpenBriefcaseGui.Handler.class, OpenBriefcaseGui.class, 18, Side.SERVER);
        network.registerMessage(ToggleOption.Handler.class, ToggleOption.class, 19, Side.SERVER);
        network.registerMessage(UpdateSliderValue.Handler.class, UpdateSliderValue.class, 22, Side.SERVER);
        network.registerMessage(RemoveCameraTag.Handler.class, RemoveCameraTag.class, 23, Side.SERVER);
        network.registerMessage(InitSentryAnimation.Handler.class, InitSentryAnimation.class, 24, Side.CLIENT);
        network.registerMessage(ToggleBlockPocketManager.Handler.class, ToggleBlockPocketManager.class, 25, Side.SERVER);
        network.registerMessage(ClearLoggerServer.Handler.class, ClearLoggerServer.class, 27, Side.SERVER);
        network.registerMessage(RefreshDiguisedModel.Handler.class, RefreshDiguisedModel.class, 28, Side.CLIENT);
        network.registerMessage(SetSentryMode.Handler.class, SetSentryMode.class, 29, Side.SERVER);
        network.registerMessage(AssembleBlockPocket.Handler.class, AssembleBlockPocket.class, 30, Side.SERVER);
        network.registerMessage(SyncProjector.Handler.class, SyncProjector.class, 31, Side.SERVER);
        network.registerMessage(SyncBlockPocketManager.Handler.class, SyncBlockPocketManager.class, 32, Side.SERVER);
        network.registerMessage(SyncTrophySystem.Handler.class, SyncTrophySystem.class, 33, Side.SERVER);
        network.registerMessage(SetTrophySystemTarget.Handler.class, SetTrophySystemTarget.class, 34, Side.CLIENT);
        network.registerMessage(SetKeycardUses.Handler.class, SetKeycardUses.class, 35, Side.SERVER);
        network.registerMessage(SetCameraView.Handler.class, SetCameraView.class, 36, Side.CLIENT);
        network.registerMessage(DismountCamera.Handler.class, DismountCamera.class, 37, Side.SERVER);
        network.registerMessage(SyncSSSSettingsOnServer.Handler.class, SyncSSSSettingsOnServer.class, 38, Side.SERVER);
        network.registerMessage(ClearChangeDetectorServer.Handler.class, ClearChangeDetectorServer.class, 39, Side.SERVER);
        network.registerMessage(SyncBlockChangeDetector.Handler.class, SyncBlockChangeDetector.class, 40, Side.SERVER);
        network.registerMessage(ToggleModule.Handler.class, ToggleModule.class, 41, Side.SERVER);
        network.registerMessage(SetGhostSlot.Handler.class, SetGhostSlot.class, 42, Side.SERVER);
        network.registerMessage(RemoveMineFromMRAT.Handler.class, RemoveMineFromMRAT.class, 43, Side.SERVER);
        network.registerMessage(RemovePositionFromSSS.Handler.class, RemovePositionFromSSS.class, 44, Side.SERVER);
        network.registerMessage(RemoveSentryFromSRAT.Handler.class, RemoveSentryFromSRAT.class, 45, Side.SERVER);
        network.registerMessage(SetBriefcaseOwner.Handler.class, SetBriefcaseOwner.class, 46, Side.SERVER);
        network.registerMessage(SetListModuleData.Handler.class, SetListModuleData.class, 47, Side.SERVER);
        network.registerMessage(SetStateOnDisguiseModule.Handler.class, SetStateOnDisguiseModule.class, 48, Side.SERVER);
        network.registerMessage(SyncRiftStabilizer.Handler.class, SyncRiftStabilizer.class, 49, Side.SERVER);
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (int i = 0; i < SCSounds.values().length; ++i) {
            event.getRegistry().register((IForgeRegistryEntry)SCSounds.values()[i].event);
        }
    }

    @SubscribeEvent
    public static void registerDataSerializerEntries(RegistryEvent.Register<DataSerializerEntry> event) {
        event.getRegistry().register(new DataSerializerEntry((DataSerializer)new DataSerializer<Owner>(){

            public void write(PacketBuffer buf, Owner value) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)value.getName());
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)value.getUUID());
            }

            public Owner read(PacketBuffer buf) throws IOException {
                String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
                String uuid = ByteBufUtils.readUTF8String((ByteBuf)buf);
                return new Owner(name, uuid);
            }

            public DataParameter<Owner> func_187161_a(int id) {
                return new DataParameter(id, (DataSerializer)this);
            }

            public Owner copyValue(Owner value) {
                return new Owner(value.getName(), value.getUUID());
            }
        }).setRegistryName(new ResourceLocation("securitycraft", "owner")));
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        event.getRegistry().register(new DyeBriefcaseRecipe().setRegistryName(new ResourceLocation("securitycraft", "dye_briefcase")));
        event.getRegistry().register(new LimitedUseKeycardRecipe().setRegistryName(new ResourceLocation("securitycraft", "limited_use_keycard_conversion")));
        RegistrationHandler.registerFakeLiquidRecipes(new ItemStack(Items.field_151131_as), PotionTypes.field_185252_x, PotionTypes.field_185253_y, new ItemStack(SCContent.fWaterBucket));
        RegistrationHandler.registerFakeLiquidRecipes(new ItemStack(Items.field_151129_at), PotionTypes.field_185250_v, PotionTypes.field_185251_w, new ItemStack(SCContent.fLavaBucket));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerResourceLocations(ModelRegistryEvent event) {
        RegistrationHandler.registerInventoryModel(SCContent.keypad, 0, "keypad");
        RegistrationHandler.registerInventoryModel(SCContent.frame, 0, "keypad_frame");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStone, 0, "reinforced_stone_default");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStone, 1, "reinforced_stone_granite");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStone, 2, "reinforced_stone_smooth_granite");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStone, 3, "reinforced_stone_diorite");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStone, 4, "reinforced_stone_smooth_diorite");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStone, 5, "reinforced_stone_andesite");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStone, 6, "reinforced_stone_smooth_andesite");
        RegistrationHandler.registerInventoryModel(SCContent.laserBlock, 0, "laser_block");
        RegistrationHandler.registerInventoryModel(SCContent.laserField, 0, "laser");
        RegistrationHandler.registerInventoryModel(SCContent.keypadChest, 0, "keypad_chest");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedDoor, 0, "reinforced_iron_door");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedIronTrapdoor, 0, "reinforced_iron_trapdoor");
        RegistrationHandler.registerInventoryModel(SCContent.keycardReader, 0, "keycard_reader");
        RegistrationHandler.registerInventoryModel(SCContent.inventoryScanner, 0, "inventory_scanner");
        RegistrationHandler.registerInventoryModel(SCContent.cageTrap, 0, "cage_trap");
        RegistrationHandler.registerInventoryModel(SCContent.inventoryScannerField, 0, "inventory_scanner_field");
        RegistrationHandler.registerInventoryModel(SCContent.retinalScanner, 0, "retinal_scanner");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedIronBars, 0, "reinforced_iron_bars");
        RegistrationHandler.registerInventoryModel(SCContent.portableRadar, 0, "portable_radar");
        RegistrationHandler.registerInventoryModel(SCContent.alarm, 0, "alarm");
        RegistrationHandler.registerInventoryModel(SCContent.alarmLit, 0, "alarm_lit");
        RegistrationHandler.registerInventoryModel(SCContent.usernameLogger, 0, "username_logger");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedFencegate, 0, "reinforced_fence_gate");
        RegistrationHandler.registerInventoryModel(SCContent.ironFence, 0, "electrified_iron_fence");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodPlanks, 0, "reinforced_planks_oak");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodPlanks, 1, "reinforced_planks_spruce");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodPlanks, 2, "reinforced_planks_birch");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodPlanks, 3, "reinforced_planks_jungle");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodPlanks, 4, "reinforced_planks_acacia");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodPlanks, 5, "reinforced_planks_dark_oak");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsStone, 0, "reinforced_stairs_stone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsCobblestone, 0, "reinforced_stairs_cobblestone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsOak, 0, "reinforced_stairs_oak");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsSpruce, 0, "reinforced_stairs_spruce");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsBirch, 0, "reinforced_stairs_birch");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsJungle, 0, "reinforced_stairs_jungle");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsAcacia, 0, "reinforced_stairs_acacia");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsDarkoak, 0, "reinforced_stairs_darkoak");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedGlass, 0, "reinforced_glass_block");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 0, "reinforced_stained_glass_white");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 1, "reinforced_stained_glass_orange");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 2, "reinforced_stained_glass_magenta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 3, "reinforced_stained_glass_light_blue");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 4, "reinforced_stained_glass_yellow");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 5, "reinforced_stained_glass_lime");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 6, "reinforced_stained_glass_pink");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 7, "reinforced_stained_glass_gray");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 8, "reinforced_stained_glass_silver");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 9, "reinforced_stained_glass_cyan");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 10, "reinforced_stained_glass_purple");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 11, "reinforced_stained_glass_blue");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 12, "reinforced_stained_glass_brown");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 13, "reinforced_stained_glass_green");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 14, "reinforced_stained_glass_red");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlass, 15, "reinforced_stained_glass_black");
        RegistrationHandler.registerInventoryModel(SCContent.keypadChest, 0, "keypad_chest");
        RegistrationHandler.registerInventoryModel(SCContent.keypadFurnace, 0, "keypad_furnace");
        RegistrationHandler.registerInventoryModel(SCContent.panicButton, 0, "panic_button");
        RegistrationHandler.registerInventoryModel(SCContent.securityCamera, 0, "security_camera");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedDirt, 0, "reinforced_dirt");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedDirt, 1, "reinforced_coarse_dirt");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedDirt, 2, "reinforced_podzol");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCobblestone, 0, "reinforced_cobblestone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedSandstone, 0, "reinforced_sandstone_normal");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedSandstone, 1, "reinforced_sandstone_chiseled");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedSandstone, 2, "reinforced_sandstone_smooth");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodSlabs, 0, "reinforced_wood_slabs_oak");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodSlabs, 1, "reinforced_wood_slabs_spruce");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodSlabs, 2, "reinforced_wood_slabs_birch");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodSlabs, 3, "reinforced_wood_slabs_jungle");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodSlabs, 4, "reinforced_wood_slabs_acacia");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodSlabs, 5, "reinforced_wood_slabs_dark_oak");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsCobblestone, 0, "reinforced_stairs_cobblestone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsSandstone, 0, "reinforced_stairs_sandstone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneSlabs, 0, "reinforced_stone_slabs_stone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneSlabs, 1, "reinforced_stone_slabs_cobblestone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneSlabs, 2, "reinforced_stone_slabs_sandstone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneSlabs, 3, "reinforced_stone_slabs_stonebrick");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneSlabs, 4, "reinforced_stone_slabs_brick");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneSlabs, 5, "reinforced_stone_slabs_netherbrick");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneSlabs, 6, "reinforced_stone_slabs_quartz");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneSlabs2, 0, "reinforced_stone_slabs2_red_sandstone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneSlabs2, 1, "reinforced_stone_slabs2_purpur");
        RegistrationHandler.registerInventoryModel(SCContent.protecto, 0, "protecto");
        RegistrationHandler.registerInventoryModel(SCContent.scannerDoor, 0, "scanner_door");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneBrick, 0, "reinforced_stone_brick_default");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneBrick, 1, "reinforced_stone_brick_mossy");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneBrick, 2, "reinforced_stone_brick_cracked");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneBrick, 3, "reinforced_stone_brick_chiseled");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsStoneBrick, 0, "reinforced_stairs_stone_brick");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedMossyCobblestone, 0, "reinforced_mossy_cobblestone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedBrick, 0, "reinforced_brick");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsBrick, 0, "reinforced_stairs_brick");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedNetherBrick, 0, "reinforced_nether_brick");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsNetherBrick, 0, "reinforced_stairs_nether_brick");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedHardenedClay, 0, "reinforced_hardened_clay");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 0, "reinforced_stained_hardened_clay_white");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 1, "reinforced_stained_hardened_clay_orange");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 2, "reinforced_stained_hardened_clay_magenta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 3, "reinforced_stained_hardened_clay_light_blue");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 4, "reinforced_stained_hardened_clay_yellow");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 5, "reinforced_stained_hardened_clay_lime");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 6, "reinforced_stained_hardened_clay_pink");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 7, "reinforced_stained_hardened_clay_gray");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 8, "reinforced_stained_hardened_clay_silver");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 9, "reinforced_stained_hardened_clay_cyan");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 10, "reinforced_stained_hardened_clay_purple");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 11, "reinforced_stained_hardened_clay_blue");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 12, "reinforced_stained_hardened_clay_brown");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 13, "reinforced_stained_hardened_clay_green");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 14, "reinforced_stained_hardened_clay_red");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedHardenedClay, 15, "reinforced_stained_hardened_clay_black");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedOldLogs, 0, "reinforced_logs_oak");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedOldLogs, 1, "reinforced_logs_spruce");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedOldLogs, 2, "reinforced_logs_birch");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedOldLogs, 3, "reinforced_logs_jungle");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedNewLogs, 0, "reinforced_logs2_acacia");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedNewLogs, 1, "reinforced_logs2_big_oak");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedMetals, 0, "reinforced_metals_gold");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedMetals, 1, "reinforced_metals_iron");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedMetals, 2, "reinforced_metals_diamond");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedMetals, 3, "reinforced_metals_emerald");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedMetals, 4, "reinforced_metals_redstone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCompressedBlocks, 0, "reinforced_compressed_blocks_lapis");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCompressedBlocks, 1, "reinforced_compressed_blocks_coal");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 0, "reinforced_wool_white");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 1, "reinforced_wool_orange");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 2, "reinforced_wool_magenta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 3, "reinforced_wool_light_blue");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 4, "reinforced_wool_yellow");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 5, "reinforced_wool_lime");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 6, "reinforced_wool_pink");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 7, "reinforced_wool_gray");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 8, "reinforced_wool_silver");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 9, "reinforced_wool_cyan");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 10, "reinforced_wool_purple");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 11, "reinforced_wool_blue");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 12, "reinforced_wool_brown");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 13, "reinforced_wool_green");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 14, "reinforced_wool_red");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWool, 15, "reinforced_wool_black");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedQuartz, 0, "reinforced_quartz_default");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedQuartz, 1, "reinforced_quartz_chiseled");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedQuartz, 2, "reinforced_quartz_pillar");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsQuartz, 0, "reinforced_stairs_quartz");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedPrismarine, 0, "reinforced_prismarine_default");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedPrismarine, 1, "reinforced_prismarine_bricks");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedPrismarine, 2, "reinforced_prismarine_dark");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedRedSandstone, 0, "reinforced_red_sandstone_default");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedRedSandstone, 1, "reinforced_red_sandstone_chiseled");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedRedSandstone, 2, "reinforced_red_sandstone_smooth");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsRedSandstone, 0, "reinforced_stairs_red_sandstone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedEndStoneBricks, 0, "reinforced_end_stone_bricks");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedRedNetherBrick, 0, "reinforced_red_nether_brick");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedPurpur, 0, "reinforced_purpur_default");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedPurpur, 1, "reinforced_purpur_pillar");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsPurpur, 0, "reinforced_stairs_purpur");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 0, "reinforced_concrete_white");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 1, "reinforced_concrete_orange");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 2, "reinforced_concrete_magenta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 3, "reinforced_concrete_light_blue");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 4, "reinforced_concrete_yellow");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 5, "reinforced_concrete_lime");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 6, "reinforced_concrete_pink");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 7, "reinforced_concrete_gray");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 8, "reinforced_concrete_silver");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 9, "reinforced_concrete_cyan");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 10, "reinforced_concrete_purple");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 11, "reinforced_concrete_blue");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 12, "reinforced_concrete_brown");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 13, "reinforced_concrete_green");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 14, "reinforced_concrete_red");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedConcrete, 15, "reinforced_concrete_black");
        RegistrationHandler.registerInventoryModel(SCContent.motionActivatedLight, 0, "motion_activated_light");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedObsidian, 0, "reinforced_obsidian");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedNetherrack, 0, "reinforced_netherrack");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedEndStone, 0, "reinforced_end_stone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedSeaLantern, 0, "reinforced_sea_lantern");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedBoneBlock, 0, "reinforced_bone_block");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedGlassPane, 0, "reinforced_glass_pane");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 0, "reinforced_stained_glass_panes_white");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 1, "reinforced_stained_glass_panes_orange");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 2, "reinforced_stained_glass_panes_magenta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 3, "reinforced_stained_glass_panes_light_blue");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 4, "reinforced_stained_glass_panes_yellow");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 5, "reinforced_stained_glass_panes_lime");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 6, "reinforced_stained_glass_panes_pink");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 7, "reinforced_stained_glass_panes_gray");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 8, "reinforced_stained_glass_panes_silver");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 9, "reinforced_stained_glass_panes_cyan");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 10, "reinforced_stained_glass_panes_purple");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 11, "reinforced_stained_glass_panes_blue");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 12, "reinforced_stained_glass_panes_brown");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 13, "reinforced_stained_glass_panes_green");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 14, "reinforced_stained_glass_panes_red");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStainedGlassPanes, 15, "reinforced_stained_glass_panes_black");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 0, "reinforced_carpet_white");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 1, "reinforced_carpet_orange");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 2, "reinforced_carpet_magenta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 3, "reinforced_carpet_light_blue");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 4, "reinforced_carpet_yellow");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 5, "reinforced_carpet_lime");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 6, "reinforced_carpet_pink");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 7, "reinforced_carpet_gray");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 8, "reinforced_carpet_silver");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 9, "reinforced_carpet_cyan");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 10, "reinforced_carpet_purple");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 11, "reinforced_carpet_blue");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 12, "reinforced_carpet_brown");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 13, "reinforced_carpet_green");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 14, "reinforced_carpet_red");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCarpet, 15, "reinforced_carpet_black");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedGlowstone, 0, "reinforced_glowstone");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedSand, 0, "reinforced_sand");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedSand, 1, "reinforced_red_sand");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedGravel, 0, "reinforced_gravel");
        RegistrationHandler.registerInventoryModel(SCContent.trophySystem, 0, "trophy_system");
        RegistrationHandler.registerInventoryModel(SCContent.crystalQuartz, 0, "crystal_quartz_default");
        RegistrationHandler.registerInventoryModel(SCContent.crystalQuartz, 1, "crystal_quartz_chiseled");
        RegistrationHandler.registerInventoryModel(SCContent.crystalQuartz, 2, "crystal_quartz_pillar");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCrystalQuartz, 0, "reinforced_crystal_quartz_default");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCrystalQuartz, 1, "reinforced_crystal_quartz_chiseled");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCrystalQuartz, 2, "reinforced_crystal_quartz_pillar");
        RegistrationHandler.registerInventoryModel(SCContent.crystalQuartzSlab, 0, "crystal_quartz_slab");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCrystalQuartzSlab, 0, "reinforced_crystal_quartz_slab");
        RegistrationHandler.registerInventoryModel(SCContent.stairsCrystalQuartz, 0, "stairs_crystal_quartz");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStairsCrystalQuartz, 0, "reinforced_stairs_crystal_quartz");
        RegistrationHandler.registerInventoryModel(SCContent.blockPocketWall, 0, "block_pocket_wall");
        RegistrationHandler.registerInventoryModel(SCContent.blockPocketManager, 0, "block_pocket_manager");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStonePressurePlate, 0, "reinforced_stone_pressure_plate");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodenPressurePlate, 0, "reinforced_wooden_pressure_plate");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedBookshelf, 0, "reinforced_bookshelf");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWalls, 0, "reinforced_cobblestone_wall");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWalls, 1, "reinforced_mossy_cobblestone_wall");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStickyPiston, 0, "reinforced_sticky_piston");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedPiston, 0, "reinforced_piston");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedObserver, 0, "reinforced_observer");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedRedstoneLamp, 0, "reinforced_redstone_lamp");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCobweb, 0, "reinforced_cobweb");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedGrass, 0, "reinforced_grass_block");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedSnowBlock, 0, "reinforced_snow_block");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedIce, 0, "reinforced_ice");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedPackedIce, 0, "reinforced_packed_ice");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedMycelium, 0, "reinforced_mycelium");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedClay, 0, "reinforced_clay");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedNetherWartBlock, 0, "reinforced_nether_wart_block");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedGrassPath, 0, "reinforced_grass_path");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedStoneButton, 0, "reinforced_stone_button");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWoodenButton, 0, "reinforced_wooden_button");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedLever, 0, "reinforced_lever");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedHopper, 0, "reinforced_hopper");
        RegistrationHandler.registerInventoryModel(SCContent.projector, 0, "projector");
        RegistrationHandler.registerInventoryModel(SCContent.keypadDoor, 0, "keypad_door");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCauldron, 0, "reinforced_cauldron");
        RegistrationHandler.registerInventoryModel(SCContent.blockChangeDetector, 0, "block_change_detector");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedEndRod, 0, "reinforced_end_rod");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedWhiteGlazedTerracotta, 0, "reinforced_white_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedOrangeGlazedTerracotta, 0, "reinforced_orange_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedMagentaGlazedTerracotta, 0, "reinforced_magenta_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedLightBlueGlazedTerracotta, 0, "reinforced_light_blue_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedYellowGlazedTerracotta, 0, "reinforced_yellow_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedLimeGlazedTerracotta, 0, "reinforced_lime_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedPinkGlazedTerracotta, 0, "reinforced_pink_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedGrayGlazedTerracotta, 0, "reinforced_gray_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedSilverGlazedTerracotta, 0, "reinforced_silver_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedCyanGlazedTerracotta, 0, "reinforced_cyan_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedPurpleGlazedTerracotta, 0, "reinforced_purple_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedBlueGlazedTerracotta, 0, "reinforced_blue_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedBrownGlazedTerracotta, 0, "reinforced_brown_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedGreenGlazedTerracotta, 0, "reinforced_green_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedRedGlazedTerracotta, 0, "reinforced_red_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedBlackGlazedTerracotta, 0, "reinforced_black_glazed_terracotta");
        RegistrationHandler.registerInventoryModel(SCContent.riftStabilizer, 0, "rift_stabilizer");
        RegistrationHandler.registerInventoryModel(SCContent.displayCase, 0, "display_case");
        RegistrationHandler.registerInventoryModel(SCContent.codebreaker, 0, "codebreaker");
        RegistrationHandler.registerInventoryModel(SCContent.remoteAccessMine, 0, "remote_access_mine");
        RegistrationHandler.registerInventoryModel(SCContent.remoteAccessSentry, 0, "remote_access_sentry");
        RegistrationHandler.registerInventoryModel(SCContent.reinforcedDoorItem, 0, "door_indestructible_iron_item");
        RegistrationHandler.registerInventoryModel(SCContent.fWaterBucket, 0, "bucket_f_water");
        RegistrationHandler.registerInventoryModel(SCContent.fLavaBucket, 0, "bucket_f_lava");
        RegistrationHandler.registerInventoryModel(SCContent.keycardLvl1, 0, "keycard_lv1");
        RegistrationHandler.registerInventoryModel(SCContent.keycardLvl2, 0, "keycard_lv2");
        RegistrationHandler.registerInventoryModel(SCContent.keycardLvl3, 0, "keycard_lv3");
        RegistrationHandler.registerInventoryModel(SCContent.keycardLvl4, 0, "keycard_lv4");
        RegistrationHandler.registerInventoryModel(SCContent.keycardLvl5, 0, "keycard_lv5");
        RegistrationHandler.registerInventoryModel(SCContent.limitedUseKeycard, 0, "limited_use_keycard");
        RegistrationHandler.registerInventoryModel(SCContent.universalBlockRemover, 0, "universal_block_remover");
        RegistrationHandler.registerInventoryModel(SCContent.universalBlockModifier, 0, "universal_block_modifier");
        RegistrationHandler.registerInventoryModel(SCContent.allowlistModule, 0, "whitelist_module");
        RegistrationHandler.registerInventoryModel(SCContent.denylistModule, 0, "blacklist_module");
        RegistrationHandler.registerInventoryModel(SCContent.redstoneModule, 0, "redstone_module");
        RegistrationHandler.registerInventoryModel(SCContent.harmingModule, 0, "harming_module");
        RegistrationHandler.registerInventoryModel(SCContent.storageModule, 0, "storage_module");
        RegistrationHandler.registerInventoryModel(SCContent.smartModule, 0, "smart_module");
        RegistrationHandler.registerInventoryModel(SCContent.disguiseModule, 0, "disguise_module");
        RegistrationHandler.registerInventoryModel(SCContent.speedModule, 0, "speed_module");
        RegistrationHandler.registerInventoryModel(SCContent.wireCutters, 0, "wire_cutters");
        RegistrationHandler.registerInventoryModel(SCContent.keyPanel, 0, "keypad_item");
        RegistrationHandler.registerInventoryModel(SCContent.adminTool, 0, "admin_tool");
        RegistrationHandler.registerInventoryModel(SCContent.cameraMonitor, 0, "camera_monitor");
        RegistrationHandler.registerInventoryModel(SCContent.scManual, 0, "sc_manual");
        RegistrationHandler.registerInventoryModel(SCContent.taser, 0, "taser");
        RegistrationHandler.registerInventoryModel(SCContent.taserPowered, 0, "taser_powered");
        RegistrationHandler.registerInventoryModel(SCContent.universalOwnerChanger, 0, "universal_owner_changer");
        RegistrationHandler.registerInventoryModel(SCContent.universalBlockReinforcerLvL1, 0, "universal_block_reinforcer_lvl1");
        RegistrationHandler.registerInventoryModel(SCContent.universalBlockReinforcerLvL2, 0, "universal_block_reinforcer_lvl2");
        RegistrationHandler.registerInventoryModel(SCContent.universalBlockReinforcerLvL3, 0, "universal_block_reinforcer_lvl3");
        RegistrationHandler.registerInventoryModel(SCContent.briefcase, 0, "briefcase");
        RegistrationHandler.registerInventoryModel(SCContent.universalKeyChanger, 0, "universal_key_changer");
        RegistrationHandler.registerInventoryModel(SCContent.scannerDoorItem, 0, "scanner_door_item");
        RegistrationHandler.registerInventoryModel(SCContent.secretSignItem, 0, "secret_sign_item");
        RegistrationHandler.registerInventoryModel(SCContent.sentry, 0, "sentry");
        RegistrationHandler.registerInventoryModel(SCContent.crystalQuartzItem, 0, "crystal_quartz_item");
        RegistrationHandler.registerInventoryModel(SCContent.keypadDoorItem, 0, "keypad_door_item");
        RegistrationHandler.registerInventoryModel(SCContent.sonicSecuritySystemItem, 0, "sonic_security_system");
        RegistrationHandler.registerInventoryModel(SCContent.portableTunePlayer, 0, "portable_tune_player");
        RegistrationHandler.registerInventoryModel((Block)SCContent.mine, 0, "mine");
        RegistrationHandler.registerInventoryModel(SCContent.dirtMine, 0, "dirt_mine");
        RegistrationHandler.registerInventoryModel(SCContent.stoneMine, 0, "stone_mine");
        RegistrationHandler.registerInventoryModel(SCContent.cobblestoneMine, 0, "cobblestone_mine");
        RegistrationHandler.registerInventoryModel(SCContent.sandMine, 0, "sand_mine");
        RegistrationHandler.registerInventoryModel(SCContent.diamondOreMine, 0, "diamond_mine");
        RegistrationHandler.registerInventoryModel(SCContent.furnaceMine, 0, "furnace_mine");
        RegistrationHandler.registerInventoryModel(SCContent.trackMine, 0, "track_mine");
        RegistrationHandler.registerInventoryModel(SCContent.bouncingBetty, 0, "bouncing_betty");
        RegistrationHandler.registerInventoryModel(SCContent.claymore, 0, "claymore");
        RegistrationHandler.registerInventoryModel(SCContent.ims, 0, "ims");
        RegistrationHandler.registerInventoryModel(SCContent.gravelMine, 0, "gravel_mine");
        RegistrationHandler.registerInventoryModel(SCContent.coalOreMine, 0, "coal_ore_mine");
        RegistrationHandler.registerInventoryModel(SCContent.emeraldOreMine, 0, "emerald_ore_mine");
        RegistrationHandler.registerInventoryModel(SCContent.goldOreMine, 0, "gold_ore_mine");
        RegistrationHandler.registerInventoryModel(SCContent.ironOreMine, 0, "iron_ore_mine");
        RegistrationHandler.registerInventoryModel(SCContent.lapisOreMine, 0, "lapis_ore_mine");
        RegistrationHandler.registerInventoryModel(SCContent.quartzOreMine, 0, "quartz_ore_mine");
        RegistrationHandler.registerInventoryModel(SCContent.redstoneOreMine, 0, "redstone_ore_mine");
    }

    private static void registerInventoryModel(Block block, int metadata, String name) {
        RegistrationHandler.registerInventoryModel(Item.func_150898_a((Block)block), metadata, name);
    }

    private static void registerInventoryModel(Item item, int metadata, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)new ModelResourceLocation("securitycraft:" + name, "inventory"));
    }

    private static void registerBlock(RegistryEvent.Register<Block> event, Block block, String designedBy) {
        RegistrationHandler.registerBlock(event, block, new ItemBlock(block), designedBy);
    }

    private static void registerBlock(RegistryEvent.Register<Block> event, Block block) {
        RegistrationHandler.registerBlock(event, block, new ItemBlock(block), PageType.SINGLE_ITEM);
    }

    private static void registerBlockMine(RegistryEvent.Register<Block> event, Block block) {
        RegistrationHandler.registerBlock(event, block, new ItemBlock(block), PageType.BLOCK_MINES);
        blockConfigValues.put(block, ConfigHandler.ableToBreakMines);
    }

    private static void registerBlock(RegistryEvent.Register<Block> event, Block block, boolean configValue) {
        RegistrationHandler.registerBlock(event, block, new ItemBlock(block), PageType.SINGLE_ITEM);
        blockConfigValues.put(block, configValue);
    }

    private static void registerBlock(RegistryEvent.Register<Block> event, Block block, PageType pageGroup) {
        RegistrationHandler.registerBlock(event, block, new ItemBlock(block), pageGroup);
    }

    private static void registerBlock(RegistryEvent.Register<Block> event, Block block, ItemBlock itemBlock, PageType pageType) {
        event.getRegistry().register((IForgeRegistryEntry)block);
        if (itemBlock != null) {
            itemBlocks.add((Item)itemBlock.setRegistryName(block.getRegistryName().toString()));
        }
        if (pageType == PageType.SINGLE_ITEM) {
            blockPages.add(block);
        } else if (pageType != PageType.NO_PAGE) {
            if (!pageTypeBlocks.containsKey((Object)pageType)) {
                pageTypeBlocks.put(pageType, new ArrayList());
            }
            pageTypeBlocks.get((Object)pageType).add(block);
        }
    }

    private static void registerBlock(RegistryEvent.Register<Block> event, Block block, ItemBlock itemBlock, String designedBy) {
        event.getRegistry().register((IForgeRegistryEntry)block);
        if (itemBlock != null) {
            itemBlocks.add((Item)itemBlock.setRegistryName(block.getRegistryName().toString()));
        }
        blockPages.add(block);
        if (designedBy != null) {
            blocksDesignedBy.put(block, designedBy);
        }
    }

    private static void registerItem(RegistryEvent.Register<Item> event, Item item) {
        RegistrationHandler.registerItem(event, item, PageType.SINGLE_ITEM, true, "");
    }

    private static void registerItem(RegistryEvent.Register<Item> event, Item item, PageType pageType, boolean configValue) {
        RegistrationHandler.registerItem(event, item, pageType, configValue, "");
    }

    private static void registerItem(RegistryEvent.Register<Item> event, Item item, PageType pageType) {
        RegistrationHandler.registerItem(event, item, pageType, true, "");
    }

    private static void registerItem(RegistryEvent.Register<Item> event, Item item, PageType pageType, boolean configValue, String designedBy) {
        event.getRegistry().register((IForgeRegistryEntry)item);
        if (pageType == PageType.NO_PAGE) {
            return;
        }
        if (pageType != PageType.SINGLE_ITEM) {
            if (!pageTypeStacks.containsKey((Object)pageType)) {
                pageTypeStacks.put(pageType, new ArrayList());
            }
            if (item != null && item.func_77614_k()) {
                NonNullList subStacks = NonNullList.func_191196_a();
                item.func_150895_a(item.func_77640_w(), subStacks);
                pageTypeStacks.get((Object)pageType).addAll((Collection<ItemStack>)subStacks);
            } else {
                pageTypeStacks.get((Object)pageType).add(new ItemStack(item));
            }
        } else {
            TextComponentTranslation title = Utils.localize(item, new Object[0]);
            TextComponentTranslation helpInfo = Utils.localize("help." + item.func_77658_a().substring(5) + ".info", new Object[0]);
            ItemSCManual.PAGES.add(new SCManualPage(item, pageType, title, helpInfo, designedBy, false, configValue));
        }
    }

    private static void registerFakeLiquidRecipes(ItemStack input, PotionType normalPotion, PotionType strongPotion, ItemStack output) {
        ItemStack normalPotionStack = new ItemStack((Item)Items.field_151068_bn);
        ItemStack strongPotionStack = new ItemStack((Item)Items.field_151068_bn);
        ItemStack normalSplashPotionStack = new ItemStack((Item)Items.field_185155_bH);
        ItemStack strongSplashPotionStack = new ItemStack((Item)Items.field_185155_bH);
        ItemStack normalLingeringPotionStack = new ItemStack((Item)Items.field_185156_bI);
        ItemStack strongLingeringPotionStack = new ItemStack((Item)Items.field_185156_bI);
        NBTTagCompound normalNBT = new NBTTagCompound();
        NBTTagCompound strongNBT = new NBTTagCompound();
        normalNBT.func_74778_a("Potion", normalPotion.getRegistryName().toString());
        strongNBT.func_74778_a("Potion", strongPotion.getRegistryName().toString());
        normalPotionStack.func_77982_d(normalNBT.func_74737_b());
        strongPotionStack.func_77982_d(strongNBT.func_74737_b());
        normalSplashPotionStack.func_77982_d(normalNBT.func_74737_b());
        strongSplashPotionStack.func_77982_d(strongNBT.func_74737_b());
        normalLingeringPotionStack.func_77982_d(normalNBT.func_74737_b());
        strongLingeringPotionStack.func_77982_d(strongNBT.func_74737_b());
        BrewingRecipeRegistry.addRecipe((ItemStack)input, (ItemStack)normalPotionStack, (ItemStack)output);
        BrewingRecipeRegistry.addRecipe((ItemStack)input, (ItemStack)strongPotionStack, (ItemStack)output);
        BrewingRecipeRegistry.addRecipe((ItemStack)input, (ItemStack)normalSplashPotionStack, (ItemStack)output);
        BrewingRecipeRegistry.addRecipe((ItemStack)input, (ItemStack)strongSplashPotionStack, (ItemStack)output);
        BrewingRecipeRegistry.addRecipe((ItemStack)input, (ItemStack)normalLingeringPotionStack, (ItemStack)output);
        BrewingRecipeRegistry.addRecipe((ItemStack)input, (ItemStack)strongLingeringPotionStack, (ItemStack)output);
    }
}

