/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.api.TileEntityLinkable;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public interface IOwnable {
    public Owner getOwner();

    public void setOwner(String var1, String var2);

    default public boolean needsValidation() {
        return false;
    }

    default public void onOwnerChanged(IBlockState state, World world, BlockPos pos, EntityPlayer player) {
        TileEntity te;
        if (this.needsValidation()) {
            this.getOwner().setValidated(false);
            PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.universalOwnerChanger.func_77658_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.ownerInvalidated", new Object[0]), TextFormatting.GREEN);
        }
        if ((te = (TileEntity)this) instanceof TileEntityLinkable) {
            TileEntityLinkable linkable = (TileEntityLinkable)te;
            linkable.createLinkedBlockAction((ILinkedAction)new ILinkedAction.OwnerChanged(this.getOwner()), linkable);
        }
        te.func_70296_d();
    }
}

