/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import com.google.common.base.Predicate;
import java.util.function.Function;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordConvertible;
import net.geforcemods.securitycraft.blocks.BlockDisguisable;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypadFurnace;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockKeypadFurnace
extends BlockDisguisable {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool OPEN = PropertyBool.func_177716_a((String)"open");
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");
    private static final AxisAlignedBB NORTH = new AxisAlignedBB(0.0, 0.0, 0.125, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB EAST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.875, 1.0, 1.0);
    private static final AxisAlignedBB SOUTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.875);
    private static final AxisAlignedBB WEST = new AxisAlignedBB(0.125, 0.0, 0.0, 1.0, 1.0, 1.0);

    public BlockKeypadFurnace(Material material) {
        super(material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
        this.func_149672_a(SoundType.field_185852_e);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return NORTH;
            }
            case EAST: {
                return EAST;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
        }
        return field_185505_j;
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IInventory) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)te));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileEntityKeypadFurnace te = (TileEntityKeypadFurnace)world.func_175625_s(pos);
            if (te.isDisabled()) {
                player.func_146105_b((ITextComponent)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            } else {
                if (ModuleUtils.isDenied(te, (Entity)player)) {
                    if (te.sendsMessages()) {
                        PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(this.func_149739_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), TextFormatting.RED);
                    }
                    return true;
                }
                if (ModuleUtils.isAllowed((IModuleInventory)te, (Entity)player)) {
                    if (te.sendsMessages()) {
                        PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(this.func_149739_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), TextFormatting.GREEN);
                    }
                    this.activate(state, world, pos, player);
                } else if (!PlayerUtils.isHoldingItem(player, SCContent.codebreaker, hand)) {
                    te.openPasswordGUI(world, pos, te.getOwner(), player);
                }
            }
        }
        return true;
    }

    public void activate(IBlockState state, World world, BlockPos pos, EntityPlayer player) {
        if (!((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(true)));
        }
        world.func_180498_a(null, 1005, pos, 0);
        player.openGui((Object)SecurityCraft.instance, 8, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 13 : 0;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState func_176203_a(int meta) {
        boolean open = meta >= 8;
        boolean lit = false;
        if (meta >= 12) {
            meta -= 4;
            lit = true;
        } else if (meta <= 1) {
            meta += 2;
            lit = true;
        } else if (meta == 6 || meta == 7) {
            meta -= 2;
            lit = true;
        }
        if (open) {
            meta -= 6;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.values()[meta]).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(open)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(lit));
    }

    public int func_176201_c(IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
            return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() + 6 + ((Boolean)state.func_177229_b((IProperty)LIT) != false ? 4 : 0);
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                return facing.func_176745_a() - 2;
            }
            return facing.func_176745_a() + 2;
        }
        return facing.func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, OPEN, LIT});
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityKeypadFurnace();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public static class Convertible
    implements Function<Object, IPasswordConvertible>,
    IPasswordConvertible {
        @Override
        public IPasswordConvertible apply(Object o) {
            return this;
        }

        @Override
        public Block getOriginalBlock() {
            return Blocks.field_150460_al;
        }

        @Override
        public boolean convert(EntityPlayer player, World world, BlockPos pos) {
            EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
            TileEntityFurnace furnace = (TileEntityFurnace)world.func_175625_s(pos);
            NBTTagCompound tag = furnace.func_189515_b(new NBTTagCompound());
            furnace.func_174888_l();
            world.func_175656_a(pos, SCContent.keypadFurnace.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false)));
            TileEntity newTe = world.func_175625_s(pos);
            ((TileEntityKeypadFurnace)newTe).func_145839_a(tag);
            ((IOwnable)newTe).setOwner(player.func_110124_au().toString(), player.func_70005_c_());
            return true;
        }
    }
}

