/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDeadBush;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class BlockReinforcedBase
extends BlockOwnable
implements IReinforcedBlock {
    private List<Block> vanillaBlocks;
    private int amount;

    public BlockReinforcedBase(Material mat, int a, Block ... vB) {
        super(mat);
        this.vanillaBlocks = Arrays.asList(vB);
        this.amount = a;
    }

    public BlockReinforcedBase(Material mat, int a, SoundType sound, Block ... vB) {
        super(mat);
        this.func_149672_a(sound);
        this.vanillaBlocks = Arrays.asList(vB);
        this.amount = a;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState plant = plantable.getPlant(world, pos.func_177972_a(direction));
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177972_a(direction));
        if (super.canSustainPlant(state, world, pos, direction, plantable)) {
            return true;
        }
        if (plant.func_177230_c() == Blocks.field_150434_aF) {
            return this == SCContent.reinforcedSand;
        }
        if (plantable instanceof BlockBush) {
            boolean condition = false;
            if (plantable instanceof BlockLilyPad) {
                condition = world.func_180495_p(pos).func_177230_c() == SCContent.fakeWater;
            } else if (plantable instanceof BlockDeadBush) {
                boolean bl = condition = state.func_177230_c() == SCContent.reinforcedSand || state.func_177230_c() == SCContent.reinforcedHardenedClay || state.func_177230_c() == SCContent.reinforcedStainedHardenedClay || state.func_177230_c() == SCContent.reinforcedDirt;
            }
            if (condition) {
                return true;
            }
        }
        switch (plantType) {
            case Desert: {
                return state.func_177230_c() == SCContent.reinforcedSand || state.func_177230_c() == SCContent.reinforcedHardenedClay || state.func_177230_c() == SCContent.reinforcedStainedHardenedClay;
            }
            case Plains: {
                return state.func_177230_c() == SCContent.reinforcedGrass || state.func_177230_c() == SCContent.reinforcedDirt;
            }
            case Beach: {
                boolean isBeach = state.func_177230_c() == SCContent.reinforcedGrass || state.func_177230_c() == SCContent.reinforcedDirt || state.func_177230_c() == SCContent.reinforcedSand;
                boolean hasWater = world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
                return isBeach && hasWater;
            }
        }
        return false;
    }

    @Override
    public List<Block> getVanillaBlocks() {
        return this.vanillaBlocks;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }
}

