/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IExtractionBlock;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.TileEntityReinforcedHopper;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockReinforcedHopper
extends BlockHopper
implements IReinforcedBlock {
    public BlockReinforcedHopper() {
        this.func_149672_a(SoundType.field_185852_e);
    }

    public float func_149638_a(Entity exploder) {
        return Float.MAX_VALUE;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return Float.MAX_VALUE;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityReinforcedHopper te;
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityReinforcedHopper && ((te = (TileEntityReinforcedHopper)tileEntity).getOwner().isOwner(player) || ModuleUtils.isAllowed((IModuleInventory)te, (Entity)player))) {
            player.func_71007_a((IInventory)te);
            player.func_71029_a(StatList.field_188084_R);
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityReinforcedHopper();
    }

    @Override
    public List<Block> getVanillaBlocks() {
        return Arrays.asList(Blocks.field_150438_bZ);
    }

    @Override
    public int getAmount() {
        return 1;
    }

    public static class ExtractionBlock
    implements IExtractionBlock,
    Function<Object, IExtractionBlock> {
        @Override
        public IExtractionBlock apply(Object o) {
            return this;
        }

        @Override
        public boolean canExtract(IOwnable te, World world, BlockPos pos, IBlockState state) {
            TileEntityReinforcedHopper hopperTe = (TileEntityReinforcedHopper)world.func_175625_s(pos);
            if (!te.getOwner().owns(hopperTe)) {
                if (te instanceof IModuleInventory) {
                    IModuleInventory inv = (IModuleInventory)((Object)te);
                    if (ModuleUtils.isAllowed(inv, hopperTe.getOwner().getName())) {
                        return true;
                    }
                    if (ModuleUtils.isAllowed((IModuleInventory)hopperTe, te.getOwner().getName())) {
                        return true;
                    }
                }
                return false;
            }
            return true;
        }

        @Override
        public Block getBlock() {
            return SCContent.reinforcedHopper;
        }
    }
}

