/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.gui;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.containers.ContainerInventoryScanner;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.geforcemods.securitycraft.util.GuiUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiInventoryScanner
extends GuiContainer {
    private static final ResourceLocation regularInventory = new ResourceLocation("securitycraft:textures/gui/container/inventory_scanner_gui.png");
    private static final ResourceLocation ENHANCED_INVENTORY = new ResourceLocation("securitycraft:textures/gui/container/inventory_scanner_enhanced_gui.png");
    public TileEntityInventoryScanner tileEntity;
    private EntityPlayer playerObj;
    private boolean owns = false;
    private boolean hasRedstoneModule = false;
    private boolean hasStorageModule = false;
    private String infoStringRedstone;
    private String infoStringStorage;
    private final String redstoneModuleNotInstalled = Utils.localize("gui.securitycraft:invScan.notInstalled", Utils.localize(SCContent.redstoneModule.func_77658_a() + ".name", new Object[0])).func_150254_d();
    private final String storageModuleNotInstalled = Utils.localize("gui.securitycraft:invScan.notInstalled", Utils.localize(SCContent.storageModule.func_77658_a() + ".name", new Object[0])).func_150254_d();

    public GuiInventoryScanner(InventoryPlayer inventory, TileEntityInventoryScanner te, EntityPlayer player) {
        super((Container)new ContainerInventoryScanner(inventory, te));
        this.tileEntity = te;
        this.playerObj = player;
        this.owns = this.tileEntity.getOwner().isOwner(this.playerObj);
        this.hasRedstoneModule = this.tileEntity.isModuleEnabled(EnumModuleType.REDSTONE);
        this.hasStorageModule = this.tileEntity.isModuleEnabled(EnumModuleType.STORAGE);
        this.infoStringRedstone = Utils.localize("gui.securitycraft:invScan.emit_redstone", Utils.localize("gui.securitycraft:invScan." + (this.hasRedstoneModule ? "yes" : "no"), new Object[0])).func_150254_d();
        this.infoStringStorage = Utils.localize("gui.securitycraft:invScan.check_inv", Utils.localize("gui.securitycraft:invScan." + (this.hasStorageModule ? "yes" : "no"), new Object[0])).func_150254_d();
        this.field_146999_f = this.hasStorageModule ? 246 : 190;
        this.field_147000_g = 196;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179140_f();
        this.field_146289_q.func_78279_b(this.infoStringRedstone, this.field_147003_i + 28, this.field_147009_r + 45, 150, 0x404040);
        this.field_146289_q.func_78279_b(this.infoStringStorage, this.field_147003_i + 28, this.field_147009_r + 75, 150, 0x404040);
        GuiUtils.renderModuleInfo(EnumModuleType.REDSTONE, null, this.redstoneModuleNotInstalled, this.hasRedstoneModule, this.field_147003_i + 8, this.field_147009_r + 45, this.field_146294_l, this.field_146295_m, mouseX, mouseY);
        GuiUtils.renderModuleInfo(EnumModuleType.STORAGE, null, this.storageModuleNotInstalled, this.hasStorageModule, this.field_147003_i + 8, this.field_147009_r + 75, this.field_146294_l, this.field_146295_m, mouseX, mouseY);
        if (this.getSlotUnderMouse() != null && !this.getSlotUnderMouse().func_75211_c().func_190926_b()) {
            this.func_146285_a(this.getSlotUnderMouse().func_75211_c(), mouseX, mouseY);
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(Utils.localize("gui.securitycraft:invScan.prohibitedItems", new Object[0]).func_150254_d(), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.tileEntity.getOwner().isOwner(this.playerObj) ? TextFormatting.UNDERLINE + Utils.localize("gui.securitycraft:invScan.mode.admin", new Object[0]).func_150254_d() : TextFormatting.UNDERLINE + Utils.localize("gui.securitycraft:invScan.mode.view", new Object[0]).func_150254_d(), 112, 6, 0x404040);
        if (this.hasStorageModule && this.owns) {
            this.field_146289_q.func_78276_b(Utils.localize("gui.securitycraft:invScan.storage", new Object[0]).func_150254_d(), 188, 18, 0x404040);
        }
        this.field_146289_q.func_78276_b(Utils.localize("container.inventory", new Object[0]).func_150254_d(), 15, this.field_147000_g - 93, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.hasStorageModule && this.owns ? ENHANCED_INVENTORY : regularInventory);
        this.func_73729_b((this.field_146294_l - this.field_146999_f) / 2, (this.field_146295_m - this.field_147000_g) / 2, 0, 0, this.field_146999_f, this.field_147000_g + 30);
    }
}

