/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.gui.components;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.gui.components.ClickButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.client.config.GuiUtils;

public class CollapsibleTextList
extends ClickButton {
    private static final TextComponentString PLUS = new TextComponentString("+ ");
    private static final TextComponentString MINUS = new TextComponentString("- ");
    private final int threeDotsWidth;
    private final int heightOpen;
    private final int textCutoff;
    private final String originalDisplayString;
    private final List<String> textLines;
    private final List<Long> splitTextLineCount;
    private final BiPredicate<Integer, Integer> extraHoverCheck;
    private boolean open;
    private boolean isMessageTooLong;
    private int initialY;

    public CollapsibleTextList(int id, int x, int y, int width, String buttonText, List<? extends ITextComponent> textLines, Consumer<CollapsibleTextList> onPress, BiPredicate<Integer, Integer> extraHoverCheck) {
        super(id, x, y, width, 12, buttonText, clickButton -> onPress.accept((CollapsibleTextList)((Object)((Object)clickButton))));
        this.threeDotsWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a("...");
        this.open = true;
        this.isMessageTooLong = false;
        this.initialY = -1;
        this.originalDisplayString = buttonText;
        this.switchOpenStatus();
        this.textCutoff = width - 5;
        ImmutableList.Builder splitTextLineCountBuilder = new ImmutableList.Builder();
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int amountOfLines = 0;
        for (ITextComponent iTextComponent : textLines) {
            long count = font.func_78271_c(iTextComponent.func_150254_d(), this.textCutoff).size();
            amountOfLines = (int)((long)amountOfLines + count);
            splitTextLineCountBuilder.add((Object)count);
        }
        this.textLines = textLines.stream().map(ITextComponent::func_150254_d).collect(Collectors.toList());
        this.splitTextLineCount = splitTextLineCountBuilder.build();
        this.heightOpen = this.field_146121_g + amountOfLines * font.field_78288_b + textLines.size() * 3;
        this.extraHoverCheck = extraHoverCheck;
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g && this.extraHoverCheck.test(mouseX, mouseY);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int v = this.func_146114_a(this.func_146115_a());
        int heightOffset = (this.field_146121_g - 8) / 2;
        GuiUtils.drawContinuousTexturedBox((ResourceLocation)field_146122_a, (int)this.field_146128_h, (int)this.field_146129_i, (int)0, (int)(46 + v * 20), (int)this.field_146120_f, (int)this.field_146121_g, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.field_73735_i);
        this.func_73732_a(font, this.field_146126_j, this.field_146128_h + font.func_78256_a(this.field_146126_j) / 2 + 3, this.field_146129_i + heightOffset, 0xE0E0E0);
        if (this.open) {
            int renderedLines = 0;
            GuiUtils.drawGradientRect((int)0, (int)this.field_146128_h, (int)(this.field_146129_i + this.field_146121_g), (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.heightOpen), (int)-1072689136, (int)-804253680);
            for (int i = 0; i < this.textLines.size(); ++i) {
                int textY = this.field_146129_i + 2 + this.field_146121_g + renderedLines * font.field_78288_b + i * 12;
                if (i > 0) {
                    GuiUtils.drawGradientRect((int)((int)this.field_73735_i), (int)(this.field_146128_h + 1), (int)(textY - 3), (int)(this.field_146128_h + this.field_146120_f - 2), (int)(textY - 2), (int)-1432313696, (int)-1432313696);
                }
                font.func_78279_b(this.textLines.get(i), this.field_146128_h + 2, textY, this.textCutoff, 0xE0E0E0);
                renderedLines = (int)((long)renderedLines + (this.splitTextLineCount.get(i) - 1L));
            }
        }
    }

    public void renderLongMessageTooltip() {
        GuiScreen currentScreen;
        if (this.isMessageTooLong && this.func_146115_a() && (currentScreen = Minecraft.func_71410_x().field_71462_r) != null) {
            currentScreen.func_146279_a(this.originalDisplayString, this.field_146128_h + 1, this.field_146129_i + this.field_146121_g + 2);
        }
    }

    public void setMessage(ITextComponent message) {
        int cutoff;
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        String newDisplayString = message.func_150254_d();
        int stringWidth = font.func_78256_a(newDisplayString);
        if (stringWidth > (cutoff = this.field_146120_f - 6) && stringWidth > this.threeDotsWidth) {
            this.isMessageTooLong = true;
            newDisplayString = font.func_78269_a(newDisplayString, cutoff - this.threeDotsWidth) + "...";
        }
        this.field_146126_j = newDisplayString;
    }

    public void setHeight(int height) {
        this.field_146121_g = height;
    }

    public int getHeight() {
        return this.open ? this.heightOpen : this.field_146121_g;
    }

    @Override
    public void onClick() {
        this.switchOpenStatus();
        super.onClick();
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        return this.extraHoverCheck.test(mouseX, mouseY) && super.func_146116_c(mc, mouseX, mouseY);
    }

    public void setY(int y) {
        if (this.initialY == -1) {
            this.initialY = y;
        }
        this.field_146129_i = y;
    }

    public void switchOpenStatus() {
        this.open = !this.open;
        this.setMessage((this.open ? MINUS : PLUS).func_150259_f().func_150257_a((ITextComponent)new TextComponentString(this.originalDisplayString)));
    }

    public boolean isOpen() {
        return this.open;
    }

    public int getInitialY() {
        return this.initialY;
    }
}

