/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.gui.components;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.gui.components.GuiSlider;
import net.geforcemods.securitycraft.gui.components.HoverChecker;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Mouse;

public class ColorChooser
extends GuiScreen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/color_chooser.png");
    public boolean disabled = true;
    private final int xStart;
    private final int yStart;
    private final List<Rectangle> extraAreas = new ArrayList<Rectangle>();
    private boolean clickedInDragRegion = false;
    private float h;
    private float s;
    private float b;
    private int colorFieldTop;
    private int colorFieldBottom;
    private int colorFieldLeft;
    private int colorFieldRight;
    private final int colorFieldSize = 75;
    private final HoverChecker colorFieldHoverChecker;
    private float selectionX;
    private float selectionY;
    private final int rgbColor;
    public FixedGuiTextField rBox;
    public FixedGuiTextField gBox;
    public FixedGuiTextField bBox;
    public FixedGuiTextField rgbHexBox;
    public HueSlider hueSlider;

    public ColorChooser(int xStart, int yStart, int rgbColor) {
        this.xStart = xStart;
        this.yStart = yStart;
        this.colorFieldLeft = xStart + 6;
        this.colorFieldTop = yStart + 6;
        this.colorFieldRight = this.colorFieldLeft + 75;
        this.colorFieldBottom = this.colorFieldTop + 75;
        this.rgbColor = rgbColor;
        this.colorFieldHoverChecker = new HoverChecker(this.colorFieldTop, this.colorFieldBottom, this.colorFieldLeft, this.colorFieldRight);
    }

    public void func_73866_w_() {
        Predicate boxFilter = string -> string.isEmpty() || StringUtils.isNumeric((CharSequence)string);
        Function boxResponder = box -> new GuiPageButtonList.GuiResponder((GuiTextField)box){
            final /* synthetic */ GuiTextField val$box;
            {
                this.val$box = guiTextField;
            }

            public void func_175321_a(int id, boolean value) {
            }

            public void func_175320_a(int id, float value) {
            }

            public void func_175319_a(int id, String string) {
                if (!string.isEmpty()) {
                    int number = Integer.parseInt(string);
                    Function parsingFunction = editBox -> {
                        if (editBox.func_146179_b().isEmpty()) {
                            return 0;
                        }
                        return Integer.parseInt(editBox.func_146179_b());
                    };
                    if (number < 0) {
                        this.val$box.func_146180_a("0");
                    } else if (number > 255) {
                        this.val$box.func_146180_a("255");
                    }
                    ColorChooser.this.updateHSBValues((Integer)parsingFunction.apply((Object)ColorChooser.this.rBox), (Integer)parsingFunction.apply((Object)ColorChooser.this.gBox), (Integer)parsingFunction.apply((Object)ColorChooser.this.bBox));
                    ColorChooser.this.updateTextFields(this.val$box);
                    ColorChooser.this.onColorChange();
                }
            }
        };
        int red = this.rgbColor >> 16 & 0xFF;
        int green = this.rgbColor >> 8 & 0xFF;
        int blue = this.rgbColor & 0xFF;
        this.updateHSBValues(red, green, blue);
        this.extraAreas.add(new Rectangle(this.xStart, this.yStart, 144, 108));
        this.hueSlider = new HueSlider(0, this.colorFieldLeft - 2, this.yStart + 85, 82, 20, (double)this.h * 360.0, new GuiSlider.ISlider(){

            @Override
            public void onChangeSliderValue(GuiSlider slider, String blockName, int id) {
                ColorChooser.this.h = (float)slider.getValueInt() / 360.0f;
                ColorChooser.this.updateTextFields(null);
                ColorChooser.this.onColorChange();
            }

            @Override
            public void onMouseRelease(int id) {
            }
        });
        this.func_189646_b((GuiButton)this.hueSlider);
        this.rBox = new FixedGuiTextField(1, this.field_146289_q, this.colorFieldRight + 13, this.colorFieldTop, 26, 10);
        this.gBox = new FixedGuiTextField(2, this.field_146289_q, this.colorFieldRight + 13, this.colorFieldTop + 15, 26, 10);
        this.bBox = new FixedGuiTextField(3, this.field_146289_q, this.colorFieldRight + 13, this.colorFieldTop + 30, 26, 10);
        this.rgbHexBox = new FixedGuiTextField(4, this.field_146289_q, this.colorFieldRight + 13, this.colorFieldTop + 45, 46, 10);
        this.rBox.func_146180_a("" + red);
        this.gBox.func_146180_a("" + green);
        this.bBox.func_146180_a("" + blue);
        this.rgbHexBox.func_146180_a(Integer.toHexString(this.rgbColor).substring(2));
        this.rBox.func_146203_f(3);
        this.gBox.func_146203_f(3);
        this.bBox.func_146203_f(3);
        this.rgbHexBox.func_146203_f(6);
        this.rBox.func_175205_a(boxFilter);
        this.gBox.func_175205_a(boxFilter);
        this.bBox.func_175205_a(boxFilter);
        this.rgbHexBox.func_175205_a(string -> string.matches("[0-9a-fA-F]*"));
        this.rBox.func_175207_a((GuiPageButtonList.GuiResponder)boxResponder.apply((Object)this.rBox));
        this.gBox.func_175207_a((GuiPageButtonList.GuiResponder)boxResponder.apply((Object)this.gBox));
        this.bBox.func_175207_a((GuiPageButtonList.GuiResponder)boxResponder.apply((Object)this.bBox));
        this.rgbHexBox.func_175207_a(new GuiPageButtonList.GuiResponder(){

            public void func_175321_a(int id, boolean value) {
            }

            public void func_175320_a(int id, float value) {
            }

            public void func_175319_a(int id, String string) {
                if (!string.isEmpty()) {
                    int hexColor = Integer.parseInt(string, 16);
                    ColorChooser.this.updateHSBValues(hexColor >> 16 & 0xFF, hexColor >> 8 & 0xFF, hexColor & 0xFF);
                    ColorChooser.this.updateTextFields(ColorChooser.this.rgbHexBox);
                    ColorChooser.this.onColorChange();
                }
            }
        });
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        if (!this.disabled) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
            this.func_73729_b(this.xStart, this.yStart, 0, 0, 145, 109);
            ClientUtils.fillHorizontalGradient(0, this.colorFieldLeft, this.colorFieldTop, this.colorFieldRight + 1, this.colorFieldBottom + 1, -1, ClientUtils.HSBtoRGB(this.h, 1.0f, 1.0f));
            this.func_73733_a(this.colorFieldLeft, this.colorFieldTop, this.colorFieldRight + 1, this.colorFieldBottom + 1, 0, -16777216);
            this.func_73729_b((int)this.selectionX - 1, (int)this.selectionY - 1, this.colorFieldHoverChecker.checkHover(mouseX, mouseY) ? 148 : 145, 20, 3, 3);
            super.func_73863_a(mouseX, mouseY, partialTick);
            this.rBox.func_146194_f();
            this.gBox.func_146194_f();
            this.bBox.func_146194_f();
            this.rgbHexBox.func_146194_f();
            this.field_146289_q.func_78276_b("R", this.colorFieldRight + 5, this.colorFieldTop + 1, 0x404040);
            this.field_146289_q.func_78276_b("G", this.colorFieldRight + 5, this.colorFieldTop + 16, 0x404040);
            this.field_146289_q.func_78276_b("B", this.colorFieldRight + 5, this.colorFieldTop + 31, 0x404040);
            this.field_146289_q.func_78276_b("#", this.colorFieldRight + 5, this.colorFieldTop + 46, 0x404040);
        }
    }

    public void func_73876_c() {
        if (!this.disabled) {
            this.validateNotEmpty(this.rBox);
            this.validateNotEmpty(this.gBox);
            this.validateNotEmpty(this.bBox);
            if (this.rgbHexBox != null && !this.rgbHexBox.func_146206_l() && this.rgbHexBox.func_146179_b().isEmpty()) {
                this.rgbHexBox.func_146180_a("000000");
            }
            if (Mouse.isButtonDown((int)0) && this.clickedInDragRegion) {
                int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
                int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
                this.setSelection(mouseX, mouseY);
            }
        }
    }

    public void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode != 1 && (this.tryTypeKey(this.rBox, typedChar, keyCode) || this.tryTypeKey(this.gBox, typedChar, keyCode) || this.tryTypeKey(this.bBox, typedChar, keyCode) || this.tryTypeKey(this.rgbHexBox, typedChar, keyCode))) {
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    private boolean tryTypeKey(GuiTextField editBox, char typedChar, int keyCode) {
        if (editBox.func_146206_l()) {
            editBox.func_146201_a(typedChar, keyCode);
            return true;
        }
        return false;
    }

    public void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        if (!this.disabled) {
            super.func_73864_a(mouseX, mouseY, button);
            this.rBox.func_146192_a(mouseX, mouseY, button);
            this.gBox.func_146192_a(mouseX, mouseY, button);
            this.bBox.func_146192_a(mouseX, mouseY, button);
            this.rgbHexBox.func_146192_a(mouseX, mouseY, button);
            this.clickedInDragRegion = this.colorFieldHoverChecker.checkHover(mouseX, mouseY);
            if (this.clickedInDragRegion) {
                this.setSelection(mouseX, mouseY);
            }
            if (button == 0 && this.hueSlider.func_146115_a()) {
                this.hueSlider.dragging = true;
            }
        }
    }

    public void func_146286_b(int mouseX, int mouseY, int button) {
        if (!this.disabled) {
            super.func_146286_b(mouseX, mouseY, button);
            this.clickedInDragRegion = false;
            if (button == 0 && this.hueSlider.dragging) {
                this.hueSlider.func_146118_a(Mouse.getX(), Mouse.getY());
            }
        }
    }

    public List<Rectangle> getGuiExtraAreas() {
        return this.disabled ? new ArrayList() : this.extraAreas;
    }

    public int getRGBColor() {
        return ClientUtils.HSBtoRGB(this.h, this.s, this.b);
    }

    private void setSelection(double mouseX, double mouseY) {
        this.selectionX = (int)MathHelper.func_151237_a((double)mouseX, (double)this.colorFieldLeft, (double)this.colorFieldRight);
        this.selectionY = (int)MathHelper.func_151237_a((double)mouseY, (double)this.colorFieldTop, (double)this.colorFieldBottom);
        this.s = (this.selectionX - (float)this.colorFieldLeft) / 75.0f;
        this.b = 1.0f - (this.selectionY - (float)this.colorFieldTop) / 75.0f;
        this.updateTextFields(null);
        this.onColorChange();
    }

    private void updateHSBValues(int red, int green, int blue) {
        float[] hsbColor = ClientUtils.RGBtoHSB(red, green, blue);
        this.h = hsbColor[0];
        this.s = hsbColor[1];
        this.b = hsbColor[2];
        this.updateSelection();
    }

    private void updateTextFields(GuiTextField excluded) {
        int rgbColor = this.getRGBColor();
        int red = rgbColor >> 16 & 0xFF;
        int green = rgbColor >> 8 & 0xFF;
        int blue = rgbColor & 0xFF;
        this.trySetText(excluded, this.rBox, "" + red);
        this.trySetText(excluded, this.gBox, "" + green);
        this.trySetText(excluded, this.bBox, "" + blue);
        this.trySetText(excluded, this.rgbHexBox, Integer.toHexString(rgbColor).substring(2));
    }

    private void trySetText(GuiTextField excluded, FixedGuiTextField editBox, String value) {
        if (excluded != editBox) {
            editBox.field_146216_j = value;
            editBox.updateCursor();
        }
    }

    private void updateSelection() {
        this.selectionX = this.s * 75.0f + (float)this.colorFieldLeft;
        this.selectionY = -this.b * 75.0f + 75.0f + (float)this.colorFieldTop;
        if (this.hueSlider != null) {
            this.hueSlider.setValue((double)this.h * 360.0);
        }
    }

    public void onColorChange() {
    }

    private void validateNotEmpty(GuiTextField box) {
        if (box != null && !box.func_146206_l() && box.func_146179_b().isEmpty()) {
            box.func_146180_a("0");
        }
    }

    public class FixedGuiTextField
    extends GuiTextField {
        public FixedGuiTextField(int id, FontRenderer font, int x, int y, int width, int height) {
            super(id, font, x, y, width, height);
        }

        public void func_146195_b(boolean focused) {
            if (focused) {
                ColorChooser.this.rBox.func_146195_b(false);
                ColorChooser.this.gBox.func_146195_b(false);
                ColorChooser.this.bBox.func_146195_b(false);
                ColorChooser.this.rgbHexBox.func_146195_b(false);
            }
            super.func_146195_b(focused);
        }

        public void updateCursor() {
            this.func_146190_e(this.field_146216_j.length());
            this.func_146199_i(this.func_146198_h());
        }
    }

    public class HueSlider
    extends GuiSlider {
        public HueSlider(int id, int x, int y, int width, int height, double d, GuiSlider.ISlider iSlider) {
            super("", "", id, x, y, width, height, "", 0.0, 360.0, d, false, false, iSlider);
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTick) {
            if (this.field_146125_m && this.dragging) {
                this.sliderValue = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                this.updateSlider();
            }
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            mc.func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (double)(this.field_146120_f - 8)), this.field_146129_i, this.field_146123_n ? 151 : 145, 0, 6, this.field_146121_g);
        }
    }
}

