/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.gui.components;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class ColorableScrollPanel {
    private final Minecraft client;
    protected final int listWidth;
    protected final int listHeight;
    protected final int top;
    protected final int bottom;
    protected final int right;
    protected final int left;
    protected final int slotHeight;
    protected final int scrollBarWidth = 6;
    protected final int scrollBarRight;
    protected final int scrollBarLeft;
    protected final int viewHeight;
    protected final int border = 4;
    protected int mouseX;
    protected int mouseY;
    private float initialMouseClickY = -2.0f;
    private float scrollFactor;
    public float scrollDistance;
    protected int selectedIndex = -1;
    private int headerHeight;
    protected boolean captureMouse = true;
    public boolean isHovering;
    private Color backgroundTo;
    private Color backgroundFrom;
    private Color scrollbarBackground;
    private Color scrollbarBorder;
    private Color scrollbar;

    public ColorableScrollPanel(Minecraft client, int width, int height, int top, int left) {
        this(client, width, height, top, top + height, left, 12, new Color(192, 16, 16, 16), new Color(208, 16, 16, 16), new Color(0, 0, 0, 255), new Color(128, 128, 128, 255), new Color(192, 192, 192, 255));
    }

    public ColorableScrollPanel(Minecraft client, int width, int height, int top, int bottom, int left, int entryHeight, Color backgroundFrom, Color backgroundTo) {
        this(client, width, height, top, bottom, left, entryHeight, backgroundFrom, backgroundTo, new Color(0, 0, 0, 255), new Color(128, 128, 128, 255), new Color(192, 192, 192, 255));
    }

    public ColorableScrollPanel(Minecraft client, int width, int height, int top, int bottom, int left, int entryHeight, Color backgroundFrom, Color backgroundTo, Color scrollbarBackground, Color scrollbarBorder, Color scrollbar) {
        this.client = client;
        this.listWidth = width;
        this.listHeight = height;
        this.top = top;
        this.bottom = bottom;
        this.slotHeight = entryHeight;
        this.left = left;
        this.right = width + left;
        this.backgroundFrom = backgroundFrom;
        this.backgroundTo = backgroundTo;
        this.scrollbarBackground = scrollbarBackground;
        this.scrollbarBorder = scrollbarBorder;
        this.scrollbar = scrollbar;
        this.scrollBarRight = left + this.listWidth;
        this.scrollBarLeft = this.scrollBarRight - 6;
        this.viewHeight = bottom - top;
    }

    public abstract int getSize();

    public abstract void drawPanel(int var1, int var2, Tessellator var3, int var4, int var5);

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.isHovering = mouseX >= this.left && mouseX <= this.left + this.listWidth && mouseY >= this.top && mouseY <= this.bottom;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder worldr = tess.func_178180_c();
        ScaledResolution res = new ScaledResolution(this.client);
        double scaleW = (double)this.client.field_71443_c / res.func_78327_c();
        double scaleH = (double)this.client.field_71440_d / res.func_78324_d();
        int extraHeight = this.getContentHeight() + 4 - this.viewHeight;
        this.applyScrollLimits();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)this.left * scaleW)), (int)((int)((double)this.client.field_71440_d - (double)this.bottom * scaleH)), (int)((int)((double)this.listWidth * scaleW)), (int)((int)((double)this.viewHeight * scaleH)));
        GuiUtils.drawGradientRect((int)0, (int)this.left, (int)this.top, (int)this.right, (int)this.bottom, (int)this.backgroundFrom.combinedRGBA(), (int)this.backgroundTo.combinedRGBA());
        this.drawPanel(this.right, this.top + 4 - (int)this.scrollDistance, tess, mouseX, mouseY);
        GlStateManager.func_179097_i();
        if (extraHeight > 0) {
            int height = this.getBarHeight(this.viewHeight, 4);
            int barTop = (int)this.scrollDistance * (this.viewHeight - height) / extraHeight + this.top;
            if (barTop < this.top) {
                barTop = this.top;
            }
            GlStateManager.func_179090_x();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_181662_b((double)this.scrollBarLeft, (double)this.bottom, 0.0).func_187315_a(0.0, 1.0).func_181669_b(this.scrollbarBackground.r, this.scrollbarBackground.g, this.scrollbarBackground.b, this.scrollbarBackground.a).func_181675_d();
            worldr.func_181662_b((double)this.scrollBarRight, (double)this.bottom, 0.0).func_187315_a(1.0, 1.0).func_181669_b(this.scrollbarBackground.r, this.scrollbarBackground.g, this.scrollbarBackground.b, this.scrollbarBackground.a).func_181675_d();
            worldr.func_181662_b((double)this.scrollBarRight, (double)this.top, 0.0).func_187315_a(1.0, 0.0).func_181669_b(this.scrollbarBackground.r, this.scrollbarBackground.g, this.scrollbarBackground.b, this.scrollbarBackground.a).func_181675_d();
            worldr.func_181662_b((double)this.scrollBarLeft, (double)this.top, 0.0).func_187315_a(0.0, 0.0).func_181669_b(this.scrollbarBackground.r, this.scrollbarBackground.g, this.scrollbarBackground.b, this.scrollbarBackground.a).func_181675_d();
            tess.func_78381_a();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_181662_b((double)this.scrollBarLeft, (double)(barTop + height), 0.0).func_187315_a(0.0, 1.0).func_181669_b(this.scrollbarBorder.r, this.scrollbarBorder.g, this.scrollbarBorder.b, this.scrollbarBorder.a).func_181675_d();
            worldr.func_181662_b((double)this.scrollBarRight, (double)(barTop + height), 0.0).func_187315_a(1.0, 1.0).func_181669_b(this.scrollbarBorder.r, this.scrollbarBorder.g, this.scrollbarBorder.b, this.scrollbarBorder.a).func_181675_d();
            worldr.func_181662_b((double)this.scrollBarRight, (double)barTop, 0.0).func_187315_a(1.0, 0.0).func_181669_b(this.scrollbarBorder.r, this.scrollbarBorder.g, this.scrollbarBorder.b, this.scrollbarBorder.a).func_181675_d();
            worldr.func_181662_b((double)this.scrollBarLeft, (double)barTop, 0.0).func_187315_a(0.0, 0.0).func_181669_b(this.scrollbarBorder.r, this.scrollbarBorder.g, this.scrollbarBorder.b, this.scrollbarBorder.a).func_181675_d();
            tess.func_78381_a();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_181662_b((double)this.scrollBarLeft, (double)(barTop + height - 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(this.scrollbar.r, this.scrollbar.g, this.scrollbar.b, this.scrollbar.a).func_181675_d();
            worldr.func_181662_b((double)(this.scrollBarRight - 1), (double)(barTop + height - 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(this.scrollbar.r, this.scrollbar.g, this.scrollbar.b, this.scrollbar.a).func_181675_d();
            worldr.func_181662_b((double)(this.scrollBarRight - 1), (double)barTop, 0.0).func_187315_a(1.0, 0.0).func_181669_b(this.scrollbar.r, this.scrollbar.g, this.scrollbar.b, this.scrollbar.a).func_181675_d();
            worldr.func_181662_b((double)this.scrollBarLeft, (double)barTop, 0.0).func_187315_a(0.0, 0.0).func_181669_b(this.scrollbar.r, this.scrollbar.g, this.scrollbar.b, this.scrollbar.a).func_181675_d();
            tess.func_78381_a();
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179141_d();
        GlStateManager.func_179084_k();
        GL11.glDisable((int)3089);
    }

    public int getContentHeight() {
        return this.getSize() * this.slotHeight + this.headerHeight;
    }

    public void applyScrollLimits() {
        int listHeight = this.getContentHeight() - (this.bottom - this.top - 7);
        if (listHeight < 0) {
            listHeight /= 2;
        }
        if (this.scrollDistance < 0.0f) {
            this.scrollDistance = 0.0f;
        } else if (this.scrollDistance > (float)listHeight) {
            this.scrollDistance = listHeight;
        }
    }

    public void handleMouseInput(int mouseX, int mouseY) throws IOException {
        int scroll;
        if (this.isHovering && (scroll = Mouse.getEventDWheel()) != 0) {
            this.scrollDistance += (float)(-scroll) / 120.0f * (float)this.slotHeight / 2.0f;
        }
        if (Mouse.isButtonDown((int)0)) {
            if (this.initialMouseClickY == -1.0f) {
                if (this.isHovering) {
                    int entryLeft = this.left;
                    int entryRight = this.left + this.listWidth - 7;
                    int mouseListY = mouseY - this.top - this.headerHeight + (int)this.scrollDistance - 4;
                    int slotIndex = mouseListY / this.slotHeight;
                    if (mouseX >= entryLeft && mouseX <= entryRight && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.getSize()) {
                        this.elementClicked(mouseX, mouseY, slotIndex);
                    }
                    if (mouseX >= this.scrollBarLeft && mouseX <= this.scrollBarRight) {
                        int scrollHeight = this.getContentHeight() - this.viewHeight - 4;
                        this.scrollFactor = -1.0f;
                        if (scrollHeight < 1) {
                            scrollHeight = 1;
                        }
                        this.scrollFactor /= (float)(this.viewHeight - this.getBarHeight(this.viewHeight, 4)) / (float)scrollHeight;
                    } else {
                        this.scrollFactor = 1.0f;
                    }
                    this.initialMouseClickY = mouseY;
                } else {
                    this.initialMouseClickY = -2.0f;
                }
            } else if (this.initialMouseClickY >= 0.0f) {
                this.scrollDistance -= ((float)mouseY - this.initialMouseClickY) * this.scrollFactor;
                this.initialMouseClickY = mouseY;
            }
        } else {
            this.initialMouseClickY = -1.0f;
        }
        this.applyScrollLimits();
    }

    public void elementClicked(int mouseX, int mouseY, int slotIndex) {
    }

    public int getBarHeight(int viewHeight, int border) {
        int barHeight = (int)((float)(viewHeight * viewHeight) / (float)this.getContentHeight());
        if (barHeight < 32) {
            barHeight = 32;
        }
        if (barHeight > viewHeight - border * 2) {
            barHeight = viewHeight - border * 2;
        }
        return barHeight;
    }

    public static class Color {
        public final int r;
        public final int g;
        public final int b;
        public final int a;

        public Color(int r, int g, int b, int a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }

        public int combinedRGBA() {
            return (this.r & 0xFF) << 24 | (this.g & 0xFF) << 16 | (this.b & 0xFF) << 8 | this.a & 0xFF;
        }
    }
}

