/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blocks.reinforced.BlockReinforcedGrass;
import net.geforcemods.securitycraft.blocks.reinforced.BlockReinforcedWall;
import net.geforcemods.securitycraft.entity.EntityBouncingBetty;
import net.geforcemods.securitycraft.entity.EntityBullet;
import net.geforcemods.securitycraft.entity.EntityIMSBomb;
import net.geforcemods.securitycraft.entity.EntitySentry;
import net.geforcemods.securitycraft.entity.camera.EntitySecurityCamera;
import net.geforcemods.securitycraft.items.ItemBriefcase;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.models.ModelBlockMine;
import net.geforcemods.securitycraft.network.IProxy;
import net.geforcemods.securitycraft.renderers.ItemTileEntityRenderer;
import net.geforcemods.securitycraft.renderers.RenderBouncingBetty;
import net.geforcemods.securitycraft.renderers.RenderBullet;
import net.geforcemods.securitycraft.renderers.RenderIMSBomb;
import net.geforcemods.securitycraft.renderers.RenderSentry;
import net.geforcemods.securitycraft.renderers.TileEntityBlockPocketManagerRenderer;
import net.geforcemods.securitycraft.renderers.TileEntityDisguisableRenderer;
import net.geforcemods.securitycraft.renderers.TileEntityDisplayCaseRenderer;
import net.geforcemods.securitycraft.renderers.TileEntityKeypadChestRenderer;
import net.geforcemods.securitycraft.renderers.TileEntityProjectorRenderer;
import net.geforcemods.securitycraft.renderers.TileEntityReinforcedPistonRenderer;
import net.geforcemods.securitycraft.renderers.TileEntityRetinalScannerRenderer;
import net.geforcemods.securitycraft.renderers.TileEntitySecretSignRenderer;
import net.geforcemods.securitycraft.renderers.TileEntitySecurityCameraRenderer;
import net.geforcemods.securitycraft.renderers.TileEntitySonicSecuritySystemRenderer;
import net.geforcemods.securitycraft.renderers.TileEntityTrophySystemRenderer;
import net.geforcemods.securitycraft.tileentity.TileEntityBlockChangeDetector;
import net.geforcemods.securitycraft.tileentity.TileEntityBlockPocketManager;
import net.geforcemods.securitycraft.tileentity.TileEntityCageTrap;
import net.geforcemods.securitycraft.tileentity.TileEntityDisguisable;
import net.geforcemods.securitycraft.tileentity.TileEntityDisplayCase;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.geforcemods.securitycraft.tileentity.TileEntityKeycardReader;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypad;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypadChest;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypadFurnace;
import net.geforcemods.securitycraft.tileentity.TileEntityLaserBlock;
import net.geforcemods.securitycraft.tileentity.TileEntityLogger;
import net.geforcemods.securitycraft.tileentity.TileEntityProjector;
import net.geforcemods.securitycraft.tileentity.TileEntityProtecto;
import net.geforcemods.securitycraft.tileentity.TileEntityReinforcedPiston;
import net.geforcemods.securitycraft.tileentity.TileEntityRetinalScanner;
import net.geforcemods.securitycraft.tileentity.TileEntitySecretSign;
import net.geforcemods.securitycraft.tileentity.TileEntitySecurityCamera;
import net.geforcemods.securitycraft.tileentity.TileEntitySonicSecuritySystem;
import net.geforcemods.securitycraft.tileentity.TileEntityTrophySystem;
import net.geforcemods.securitycraft.util.Tinted;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
implements IProxy {
    private static Map<Block, Pair<IBlockColor, IItemColor>> toTint = new HashMap<Block, Pair<IBlockColor, IItemColor>>();

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        String[] mines;
        for (String mine : mines = new String[]{"coal_ore", "cobblestone", "dirt", "emerald_ore", "gravel", "gold_ore", "furnace", "iron_ore", "lapis_ore", "redstone_ore", "sand", "stone"}) {
            ClientProxy.registerBlockMineModel(event, new ResourceLocation("securitycraft", mine + "_mine"), new ResourceLocation(mine));
        }
        ClientProxy.registerBlockMineModel(event, new ResourceLocation("securitycraft", "diamond_mine"), new ResourceLocation("diamond_ore"));
        ClientProxy.registerBlockMineModel(event, new ResourceLocation("securitycraft", "quartz_mine"), new ResourceLocation("nether_quartz_ore"));
    }

    private static void registerBlockMineModel(ModelBakeEvent event, ResourceLocation mineRl, ResourceLocation realBlockRl) {
        ModelResourceLocation mineMrl = new ModelResourceLocation(mineRl, "inventory");
        event.getModelRegistry().func_82595_a((Object)mineMrl, (Object)new ModelBlockMine((IBakedModel)event.getModelRegistry().func_82594_a((Object)new ModelResourceLocation(realBlockRl, "inventory")), (IBakedModel)event.getModelRegistry().func_82594_a((Object)mineMrl)));
    }

    @Override
    public void registerVariants() {
        Item fakeWater = this.findItem("securitycraft", "bogus_water");
        ModelBakery.registerItemVariants((Item)fakeWater, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)fakeWater, stack -> new ModelResourceLocation("securitycraft:fake_liquids", "water"));
        ModelLoader.setCustomStateMapper((Block)SCContent.fakeWater, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation("securitycraft:fake_liquids", "water");
            }
        });
        Item fakeWaterFlowing = this.findItem("securitycraft", "bogus_water_flowing");
        ModelBakery.registerItemVariants((Item)fakeWaterFlowing, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)fakeWaterFlowing, stack -> new ModelResourceLocation("securitycraft:fake_liquids", "water_flowing"));
        ModelLoader.setCustomStateMapper((Block)SCContent.bogusWaterFlowing, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation("securitycraft:fake_liquids", "water_flowing");
            }
        });
        Item fakeLava = this.findItem("securitycraft", "bogus_Lava");
        ModelBakery.registerItemVariants((Item)fakeLava, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)fakeLava, stack -> new ModelResourceLocation("securitycraft:fake_liquids", "lava"));
        ModelLoader.setCustomStateMapper((Block)SCContent.fakeLava, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation("securitycraft:fake_liquids", "lava");
            }
        });
        Item fakeLavaFlowing = this.findItem("securitycraft", "bogus_lava_flowing");
        ModelBakery.registerItemVariants((Item)fakeLavaFlowing, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)fakeLavaFlowing, stack -> new ModelResourceLocation("securitycraft:fake_liquids", "lava_flowing"));
        ModelLoader.setCustomStateMapper((Block)SCContent.bogusLavaFlowing, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation("securitycraft:fake_liquids", "lava_flowing");
            }
        });
        ModelLoader.setCustomStateMapper((Block)SCContent.reinforcedStainedGlassPanes, (IStateMapper)new StateMap.Builder().func_178440_a((IProperty)BlockColored.field_176581_a).func_178439_a("_reinforced_stained_glass_panes").func_178441_a());
        ModelLoader.setCustomStateMapper((Block)SCContent.reinforcedWalls, (IStateMapper)new StateMap.Builder().func_178440_a(BlockReinforcedWall.VARIANT).func_178439_a("_wall").func_178441_a());
        ModelLoader.setCustomStateMapper((Block)SCContent.reinforcedHopper, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockHopper.field_176429_b}).func_178441_a());
    }

    private Item findItem(String modid, String resourceName) {
        return (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(modid, resourceName));
    }

    @Override
    public void registerEntityRenderingHandlers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityBouncingBetty.class, RenderBouncingBetty::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityIMSBomb.class, RenderIMSBomb::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySentry.class, RenderSentry::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBullet.class, RenderBullet::new);
    }

    @Override
    public void registerRenderThings() {
        KeyBindings.init();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityKeypadChest.class, (TileEntitySpecialRenderer)new TileEntityKeypadChestRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySecurityCamera.class, (TileEntitySpecialRenderer)new TileEntitySecurityCameraRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityRetinalScanner.class, (TileEntitySpecialRenderer)new TileEntityRetinalScannerRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySecretSign.class, (TileEntitySpecialRenderer)new TileEntitySecretSignRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTrophySystem.class, (TileEntitySpecialRenderer)new TileEntityTrophySystemRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBlockPocketManager.class, (TileEntitySpecialRenderer)new TileEntityBlockPocketManagerRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityProjector.class, (TileEntitySpecialRenderer)new TileEntityProjectorRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityReinforcedPiston.class, (TileEntitySpecialRenderer)new TileEntityReinforcedPistonRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySonicSecuritySystem.class, (TileEntitySpecialRenderer)new TileEntitySonicSecuritySystemRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDisplayCase.class, (TileEntitySpecialRenderer)new TileEntityDisplayCaseRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBlockChangeDetector.class, new TileEntityDisguisableRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDisguisable.class, new TileEntityDisguisableRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCageTrap.class, new TileEntityDisguisableRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityInventoryScanner.class, new TileEntityDisguisableRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityKeycardReader.class, new TileEntityDisguisableRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityKeypad.class, new TileEntityDisguisableRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityKeypadFurnace.class, new TileEntityDisguisableRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLaserBlock.class, new TileEntityDisguisableRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityProtecto.class, new TileEntityDisguisableRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLogger.class, new TileEntityDisguisableRenderer());
        Item.func_150898_a((Block)SCContent.keypadChest).setTileEntityItemStackRenderer((TileEntityItemStackRenderer)new ItemTileEntityRenderer((TileEntity)new TileEntityKeypadChest()));
        Item.func_150898_a((Block)SCContent.displayCase).setTileEntityItemStackRenderer((TileEntityItemStackRenderer)new ItemTileEntityRenderer(new TileEntityDisplayCase()));
    }

    private static void initTint() {
        for (Field field : SCContent.class.getFields()) {
            if (!field.isAnnotationPresent(Tinted.class)) continue;
            int tint = field.getAnnotation(Tinted.class).customTint();
            boolean hasReinforcedTint = field.getAnnotation(Tinted.class).hasReinforcedTint();
            try {
                Block block = (Block)field.get(null);
                toTint.put(block, (Pair<IBlockColor, IItemColor>)Pair.of((state, world, pos, tintIndex) -> {
                    if (tintIndex == 0) {
                        return hasReinforcedTint ? ClientProxy.mixWithReinforcedTintIfEnabled(tint) : tint;
                    }
                    return 0xFFFFFF;
                }, (stack, tintIndex) -> {
                    if (tintIndex == 0) {
                        return hasReinforcedTint ? ClientProxy.mixWithReinforcedTintIfEnabled(tint) : tint;
                    }
                    return 0xFFFFFF;
                }));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onColorHandlerBlock(ColorHandlerEvent.Block event) {
        ClientProxy.initTint();
        toTint.forEach((block, pair) -> event.getBlockColors().func_186722_a((IBlockColor)pair.getLeft(), new Block[]{block}));
        event.getBlockColors().func_186722_a((state, world, pos, tintIndex) -> {
            if (tintIndex == 1 && !((Boolean)state.func_177229_b((IProperty)BlockReinforcedGrass.SNOWY)).booleanValue()) {
                int grassTint = world != null && pos != null ? BiomeColorHelper.func_180286_a((IBlockAccess)world, (BlockPos)pos) : ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
                return ClientProxy.mixWithReinforcedTintIfEnabled(grassTint);
            }
            return 0xFFFFFF;
        }, new Block[]{SCContent.reinforcedGrass});
        event.getBlockColors().func_186722_a((state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColorHelper.func_180288_c((IBlockAccess)world, (BlockPos)pos) : -1, new Block[]{SCContent.fakeWater, SCContent.bogusWaterFlowing});
    }

    @SubscribeEvent
    public static void onColorHandlerItem(ColorHandlerEvent.Item event) {
        toTint.forEach((block, pair) -> event.getItemColors().func_186731_a((IItemColor)pair.getRight(), new Block[]{block}));
        event.getItemColors().func_186731_a((stack, tintIndex) -> {
            if (tintIndex == 1) {
                int grassTint = ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
                return ClientProxy.mixWithReinforcedTintIfEnabled(grassTint);
            }
            return 0xFFFFFF;
        }, new Block[]{SCContent.reinforcedGrass});
        event.getItemColors().func_186730_a((stack, tintIndex) -> tintIndex == 0 ? ((ItemBriefcase)stack.func_77973_b()).getColor(stack) : -1, new Item[]{SCContent.briefcase});
        toTint = null;
    }

    private static int mixWithReinforcedTintIfEnabled(int tint1) {
        return ConfigHandler.reinforcedBlockTint ? ClientProxy.mixTints(tint1, 0x999999) : tint1;
    }

    private static int mixTints(int tint1, int tint2) {
        int red = tint1 >> 16 & 0xFF;
        int green = tint1 >> 8 & 0xFF;
        int blue = tint1 & 0xFF;
        red = (int)((float)red * ((float)(tint2 >> 16 & 0xFF) / 255.0f));
        green = (int)((float)green * ((float)(tint2 >> 8 & 0xFF) / 255.0f));
        blue = (int)((float)blue * ((float)(tint2 & 0xFF) / 255.0f));
        return ((red << 8) + green << 8) + blue;
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static boolean isPlayerMountedOnCamera() {
        return Minecraft.func_71410_x().func_175606_aa() instanceof EntitySecurityCamera;
    }
}

