/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.tileentity.TileEntityRiftStabilizer;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SyncRiftStabilizer
implements IMessage {
    private BlockPos pos;
    private TileEntityRiftStabilizer.TeleportationType teleportationType;
    private boolean allowed;

    public SyncRiftStabilizer() {
    }

    public SyncRiftStabilizer(BlockPos pos, TileEntityRiftStabilizer.TeleportationType teleportationType, boolean allowed) {
        this.pos = pos;
        this.teleportationType = teleportationType;
        this.allowed = allowed;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.teleportationType = TileEntityRiftStabilizer.TeleportationType.values()[buf.readInt()];
        this.allowed = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.teleportationType.ordinal());
        buf.writeBoolean(this.allowed);
    }

    public static class Handler
    implements IMessageHandler<SyncRiftStabilizer, IMessage> {
        public IMessage onMessage(SyncRiftStabilizer message, MessageContext ctx) {
            WorldUtils.addScheduledTask(ctx.getServerHandler().field_147369_b.field_70170_p, () -> {
                if (message.teleportationType != null) {
                    TileEntityRiftStabilizer te;
                    World world = ctx.getServerHandler().field_147369_b.field_70170_p;
                    BlockPos pos = message.pos;
                    boolean allowed = message.allowed;
                    if (world.func_175625_s(pos) instanceof TileEntityRiftStabilizer && (te = (TileEntityRiftStabilizer)world.func_175625_s(pos)).getOwner().isOwner((EntityPlayer)ctx.getServerHandler().field_147369_b)) {
                        IBlockState state = world.func_180495_p(pos);
                        te.setFilter(message.teleportationType, allowed);
                        world.func_184138_a(pos, state, state, 2);
                    }
                }
            });
            return null;
        }
    }
}

