/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.tileentity.TileEntitySonicSecuritySystem;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SyncSSSSettingsOnServer
implements IMessage {
    private BlockPos pos;
    private DataType dataType;
    private BlockPos posToRemove;

    public SyncSSSSettingsOnServer() {
    }

    public SyncSSSSettingsOnServer(BlockPos pos, DataType dataType) {
        this(pos, dataType, null);
    }

    public SyncSSSSettingsOnServer(BlockPos pos, DataType dataType, BlockPos posToRemove) {
        this.pos = pos;
        this.dataType = dataType;
        this.posToRemove = posToRemove;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.dataType.ordinal());
        if (this.dataType == DataType.REMOVE_POS) {
            buf.writeLong(this.posToRemove.func_177986_g());
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.dataType = DataType.values()[buf.readInt()];
        if (this.dataType == DataType.REMOVE_POS) {
            this.posToRemove = BlockPos.func_177969_a((long)buf.readLong());
        }
    }

    public static enum DataType {
        POWER_ON,
        POWER_OFF,
        SOUND_ON,
        SOUND_OFF,
        RECORDING_ON,
        RECORDING_OFF,
        CLEAR_NOTES,
        REMOVE_POS;

    }

    public static class Handler
    implements IMessageHandler<SyncSSSSettingsOnServer, IMessage> {
        public IMessage onMessage(SyncSSSSettingsOnServer message, MessageContext ctx) {
            WorldUtils.addScheduledTask(ctx.getServerHandler().field_147369_b.field_70170_p, () -> {
                World world = ctx.getServerHandler().field_147369_b.field_70170_p;
                BlockPos pos = message.pos;
                TileEntity te = world.func_175625_s(pos);
                if (te instanceof TileEntitySonicSecuritySystem && ((TileEntitySonicSecuritySystem)te).getOwner().isOwner((EntityPlayer)ctx.getServerHandler().field_147369_b)) {
                    TileEntitySonicSecuritySystem sss = (TileEntitySonicSecuritySystem)te;
                    switch (message.dataType) {
                        case POWER_ON: {
                            sss.setActive(true);
                            break;
                        }
                        case POWER_OFF: {
                            sss.setActive(false);
                            if (!sss.isRecording()) break;
                            sss.setRecording(false);
                            break;
                        }
                        case SOUND_ON: {
                            sss.setPings(true);
                            break;
                        }
                        case SOUND_OFF: {
                            sss.setPings(false);
                            break;
                        }
                        case RECORDING_ON: {
                            sss.setRecording(true);
                            break;
                        }
                        case RECORDING_OFF: {
                            sss.setRecording(false);
                            break;
                        }
                        case CLEAR_NOTES: {
                            sss.clearNotes();
                            break;
                        }
                        case REMOVE_POS: {
                            sss.delink(message.posToRemove, false);
                        }
                    }
                }
            });
            return null;
        }
    }
}

