/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.TileEntityOwnable;
import net.geforcemods.securitycraft.blocks.BlockBlockPocketManager;
import net.geforcemods.securitycraft.blocks.BlockBlockPocketWall;
import net.geforcemods.securitycraft.blocks.reinforced.BlockReinforcedCrystalQuartz;
import net.geforcemods.securitycraft.inventory.InsertOnlyItemStackHandler;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.network.server.AssembleBlockPocket;
import net.geforcemods.securitycraft.network.server.ToggleBlockPocketManager;
import net.geforcemods.securitycraft.tileentity.TileEntityBlockPocket;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityBlockPocketManager
extends CustomizableSCTE
implements ITickable,
ILockable {
    public static final int RENDER_DISTANCE = 100;
    private static final int BLOCK_PLACEMENTS_PER_TICK = 4;
    private static final ItemStack REINFORCED_CHISELED_CRYSTAL_QUARTZ = new ItemStack(SCContent.reinforcedCrystalQuartz, 1, 1);
    private static final ItemStack REINFORCED_CRYSTAL_QUARTZ_PILLAR = new ItemStack(SCContent.reinforcedCrystalQuartz, 1, 2);
    public boolean enabled = false;
    public boolean showOutline = false;
    private int color = -16776961;
    public int autoBuildOffset = 0;
    public int size = 5;
    private List<BlockPos> blocks = new ArrayList<BlockPos>();
    private List<BlockPos> walls = new ArrayList<BlockPos>();
    private List<BlockPos> floor = new ArrayList<BlockPos>();
    protected NonNullList<ItemStack> storage = NonNullList.func_191197_a((int)56, (Object)ItemStack.field_190927_a);
    private IItemHandler storageHandler;
    private IItemHandler insertOnlyHandler;
    private List<Pair<BlockPos, IBlockState>> placeQueue = new ArrayList<Pair<BlockPos, IBlockState>>();
    private boolean shouldPlaceBlocks = false;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.shouldPlaceBlocks) {
            EntityPlayer owner = PlayerUtils.getPlayerFromName(this.getOwner().getName());
            if (owner == null) {
                this.placeQueue.clear();
                this.shouldPlaceBlocks = false;
                return;
            }
            boolean isCreative = owner.func_184812_l_();
            boolean placed4 = true;
            block0: for (int i = 0; i < 4; ++i) {
                Pair<BlockPos, IBlockState> toPlace;
                IBlockState stateInWorld;
                do {
                    if (this.placeQueue.isEmpty()) {
                        placed4 = false;
                        break block0;
                    }
                    toPlace = this.placeQueue.remove(0);
                    Block block = ((IBlockState)toPlace.getRight()).func_177230_c();
                    if (block == SCContent.blockPocketWall || block == SCContent.reinforcedCrystalQuartz && ((IBlockState)toPlace.getRight()).func_177229_b((IProperty)BlockReinforcedCrystalQuartz.field_176335_a) != BlockQuartz.EnumType.DEFAULT) continue;
                    throw new IllegalStateException(String.format("Tried to automatically place non-block pocket block \"%s\"! This mustn't happen!", toPlace.getRight()));
                } while ((stateInWorld = this.field_145850_b.func_180495_p((BlockPos)toPlace.getLeft())) == toPlace.getRight());
                if (stateInWorld.func_185904_a().func_76222_j()) {
                    BlockPos pos = (BlockPos)toPlace.getLeft();
                    IBlockState stateToPlace = (IBlockState)toPlace.getRight();
                    SoundType soundType = stateToPlace.func_177230_c().getSoundType(stateToPlace, this.field_145850_b, pos, (Entity)owner);
                    if (!isCreative) {
                        for (int k = 0; k < this.storage.size(); ++k) {
                            ItemStack stackToCheck = (ItemStack)this.storage.get(k);
                            if (stackToCheck.func_190926_b() || ((ItemBlock)stackToCheck.func_77973_b()).func_179223_d() != stateToPlace.func_177230_c()) continue;
                            stackToCheck.func_190918_g(1);
                            break;
                        }
                    }
                    this.field_145850_b.func_175656_a(pos, stateToPlace);
                    this.field_145850_b.func_184133_a(null, pos, soundType.func_185841_e(), SoundCategory.BLOCKS, soundType.func_185843_a(), soundType.func_185847_b());
                    TileEntity te = this.field_145850_b.func_175625_s(pos);
                    if (!(te instanceof TileEntityOwnable)) continue;
                    ((TileEntityOwnable)te).setOwner(this.getOwner().getUUID(), this.getOwner().getName());
                    continue;
                }
                PlayerUtils.sendMessageToPlayer(owner, (ITextComponent)Utils.localize(SCContent.blockPocketManager.func_149739_a() + ".name", new Object[0]), (ITextComponent)new TextComponentTranslation("messages.securitycraft:blockpocket.assemblyFailed", new Object[]{this.getFormattedRelativeCoordinates((BlockPos)toPlace.getLeft(), (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockBlockPocketManager.FACING)), new TextComponentTranslation(stateInWorld.func_177230_c().func_149739_a(), new Object[0])}), TextFormatting.DARK_AQUA);
                placed4 = false;
                break;
            }
            if (!placed4) {
                if (!this.placeQueue.isEmpty()) {
                    this.placeQueue.clear();
                } else {
                    this.setWalls(!this.isModuleEnabled(EnumModuleType.DISGUISE));
                    PlayerUtils.sendMessageToPlayer(owner, (ITextComponent)Utils.localize(SCContent.blockPocketManager.func_149739_a() + ".name", new Object[0]), (ITextComponent)new TextComponentTranslation("messages.securitycraft:blockpocket.assembled", new Object[0]), TextFormatting.DARK_AQUA);
                }
                this.shouldPlaceBlocks = false;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TextComponentTranslation enableMultiblock() {
        TileEntity te;
        if (this.enabled) return null;
        if (this.field_145850_b.field_72995_K) {
            SecurityCraft.network.sendToServer((IMessage)new ToggleBlockPocketManager(this, true, this.size));
        }
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> sides = new ArrayList<BlockPos>();
        ArrayList<BlockPos> floor = new ArrayList<BlockPos>();
        EnumFacing managerFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockBlockPocketManager.FACING);
        EnumFacing left = managerFacing.func_176746_e();
        EnumFacing right = left.func_176734_d();
        EnumFacing back = left.func_176746_e();
        boolean lowest = false;
        int highest = this.size - 1;
        BlockPos pos = this.func_174877_v().func_185334_h();
        int xi = 0;
        int yi = 0;
        int zi = 0;
        int offset = 0;
        if (!(this.field_145850_b.func_180495_p(pos.func_177972_a(left)).func_177230_c() instanceof BlockReinforcedCrystalQuartz)) {
            offset = -this.autoBuildOffset + this.size / 2;
            pos = pos.func_177967_a(left, offset);
        } else {
            for (int i = 1; i < this.size - 1; ++i) {
                if (((BlockQuartz.EnumType)this.field_145850_b.func_180495_p(pos.func_177967_a(left, i)).func_177229_b((IProperty)BlockReinforcedCrystalQuartz.field_176335_a)).func_176796_a() >= 2) continue;
                offset = i;
                pos = pos.func_177967_a(left, offset);
                break;
            }
            if (offset == 0) {
                offset = -this.autoBuildOffset + this.size / 2;
                pos = pos.func_177967_a(left, offset);
            }
        }
        BlockPos startingPos = pos.func_185334_h();
        while (yi < this.size) {
            while (zi < this.size) {
                while (xi < this.size) {
                    if (xi > 0 && yi > 0 && zi > 0 && xi < highest && yi < highest && zi < highest) {
                        ++xi;
                        continue;
                    }
                    BlockPos currentPos = pos.func_177967_a(right, xi);
                    IBlockState currentState = this.field_145850_b.func_180495_p(currentPos);
                    if (currentState.func_177230_c() instanceof BlockBlockPocketManager && !currentPos.equals((Object)this.func_174877_v())) {
                        return new TextComponentTranslation("messages.securitycraft:blockpocket.multipleManagers", new Object[0]);
                    }
                    if (yi == 0 && !currentPos.equals((Object)this.func_174877_v()) || yi == highest) {
                        BlockQuartz.EnumType typeToCheckFor;
                        if (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest) {
                            if (!(currentState.func_177230_c() instanceof BlockReinforcedCrystalQuartz) || currentState.func_177229_b((IProperty)BlockReinforcedCrystalQuartz.field_176335_a) != BlockQuartz.EnumType.CHISELED) {
                                return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0]), new TextComponentTranslation(REINFORCED_CHISELED_CRYSTAL_QUARTZ.func_77977_a() + ".name", new Object[0])});
                            }
                        } else if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                            BlockQuartz.EnumType enumType = typeToCheckFor = managerFacing == EnumFacing.NORTH || managerFacing == EnumFacing.SOUTH ? BlockQuartz.EnumType.LINES_X : BlockQuartz.EnumType.LINES_Z;
                            if (!(currentState.func_177230_c() instanceof BlockReinforcedCrystalQuartz)) return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0]), new TextComponentTranslation(REINFORCED_CRYSTAL_QUARTZ_PILLAR.func_77977_a() + ".name", new Object[0])});
                            if (currentState.func_177229_b((IProperty)BlockReinforcedCrystalQuartz.field_176335_a) != typeToCheckFor) {
                                return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock.rotation", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0])});
                            }
                        } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                            BlockQuartz.EnumType enumType = typeToCheckFor = managerFacing == EnumFacing.NORTH || managerFacing == EnumFacing.SOUTH ? BlockQuartz.EnumType.LINES_Z : BlockQuartz.EnumType.LINES_X;
                            if (!(currentState.func_177230_c() instanceof BlockReinforcedCrystalQuartz)) return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0]), new TextComponentTranslation(REINFORCED_CRYSTAL_QUARTZ_PILLAR.func_77977_a() + ".name", new Object[0])});
                            if (currentState.func_177229_b((IProperty)BlockReinforcedCrystalQuartz.field_176335_a) != typeToCheckFor) {
                                return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock.rotation", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0])});
                            }
                        } else if (xi > 0 && zi > 0 && xi < highest && zi < highest) {
                            if (!(currentState.func_177230_c() instanceof BlockBlockPocketWall)) {
                                return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0]), new TextComponentTranslation(SCContent.blockPocketWall.func_149739_a() + ".name", new Object[0])});
                            }
                            floor.add(currentPos);
                            sides.add(currentPos);
                        }
                    } else if (yi != 0 && yi != highest && (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest)) {
                        if (!(currentState.func_177230_c() instanceof BlockReinforcedCrystalQuartz)) return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0]), new TextComponentTranslation(REINFORCED_CRYSTAL_QUARTZ_PILLAR.func_77977_a() + ".name", new Object[0])});
                        if (currentState.func_177229_b((IProperty)BlockReinforcedCrystalQuartz.field_176335_a) != BlockQuartz.EnumType.LINES_Y) {
                            return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock.rotation", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0])});
                        }
                    } else if (yi > 0 && yi < highest) {
                        if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                            if (!(currentState.func_177230_c() instanceof BlockBlockPocketWall)) {
                                return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0]), new TextComponentTranslation(SCContent.blockPocketWall.func_149739_a() + ".name", new Object[0])});
                            }
                            sides.add(currentPos);
                        } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                            if (!(currentState.func_177230_c() instanceof BlockBlockPocketWall)) {
                                return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0]), new TextComponentTranslation(SCContent.blockPocketWall.func_149739_a() + ".name", new Object[0])});
                            }
                            sides.add(currentPos);
                        }
                    }
                    te = (TileEntityOwnable)this.field_145850_b.func_175625_s(currentPos);
                    if (!this.getOwner().owns(new IOwnable[]{te})) {
                        return new TextComponentTranslation("messages.securitycraft:blockpocket.unowned", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0])});
                    }
                    blocks.add(currentPos);
                    ++xi;
                }
                xi = 0;
                pos = startingPos.func_177981_b(yi).func_177967_a(back, ++zi);
            }
            zi = 0;
            pos = startingPos.func_177981_b(++yi);
        }
        this.blocks = blocks;
        this.walls = sides;
        this.floor = floor;
        this.enabled = true;
        this.autoBuildOffset = -offset + this.size / 2;
        for (BlockPos blockPos : blocks) {
            te = this.field_145850_b.func_175625_s(blockPos);
            if (!(te instanceof TileEntityBlockPocket)) continue;
            ((TileEntityBlockPocket)te).setManager(this);
        }
        for (BlockPos blockPos : floor) {
            this.field_145850_b.func_175656_a(blockPos, this.field_145850_b.func_180495_p(blockPos).func_177226_a((IProperty)BlockBlockPocketWall.SOLID, (Comparable)Boolean.valueOf(true)));
        }
        this.setWalls(!this.isModuleEnabled(EnumModuleType.DISGUISE));
        return new TextComponentTranslation("messages.securitycraft:blockpocket.activated", new Object[0]);
    }

    public ITextComponent autoAssembleMultiblock() {
        if (!this.enabled) {
            IBlockState currentState;
            BlockPos currentPos;
            if (this.field_145850_b.field_72995_K) {
                SecurityCraft.network.sendToServer((IMessage)new AssembleBlockPocket(this, this.size));
            }
            EnumFacing managerFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockBlockPocketManager.FACING);
            EnumFacing left = managerFacing.func_176746_e();
            EnumFacing right = left.func_176734_d();
            EnumFacing back = left.func_176746_e();
            boolean lowest = false;
            int half = (this.size - 1) / 2 - this.autoBuildOffset;
            int highest = this.size - 1;
            BlockPos pos = this.func_174877_v().func_185334_h();
            int xi = 0;
            int yi = 0;
            int zi = 0;
            int wallsNeeded = 0;
            int pillarsNeeded = 0;
            int chiseledNeeded = 0;
            pos = pos.func_177967_a(right, -half);
            BlockPos startingPos = pos.func_185334_h();
            while (yi < this.size) {
                while (zi < this.size) {
                    while (xi < this.size) {
                        if (xi > 0 && yi > 0 && zi > 0 && xi < highest && yi < highest && zi < highest) {
                            ++xi;
                            continue;
                        }
                        currentPos = pos.func_177967_a(right, xi);
                        currentState = this.field_145850_b.func_180495_p(currentPos);
                        boolean replaceable = currentState.func_185904_a().func_76222_j();
                        if (yi == 0 && !currentPos.equals((Object)this.func_174877_v()) || yi == highest) {
                            BlockQuartz.EnumType typeToCheckFor;
                            if (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest) {
                                if (!(currentState.func_177230_c() instanceof BlockReinforcedCrystalQuartz && currentState.func_177229_b((IProperty)BlockReinforcedCrystalQuartz.field_176335_a) == BlockQuartz.EnumType.CHISELED || replaceable)) {
                                    return new TextComponentTranslation("messages.securitycraft:blockpocket.blockInWay", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0])});
                                }
                                if (replaceable) {
                                    ++chiseledNeeded;
                                }
                            } else if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                BlockQuartz.EnumType enumType = typeToCheckFor = managerFacing == EnumFacing.NORTH || managerFacing == EnumFacing.SOUTH ? BlockQuartz.EnumType.LINES_X : BlockQuartz.EnumType.LINES_Z;
                                if (!this.isReinforcedCrystalQuartzPillar(currentState) && !replaceable || currentState.func_177230_c() instanceof BlockReinforcedCrystalQuartz && currentState.func_177229_b((IProperty)BlockReinforcedCrystalQuartz.field_176335_a) != typeToCheckFor) {
                                    return new TextComponentTranslation("messages.securitycraft:blockpocket.blockInWay", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0])});
                                }
                                if (replaceable) {
                                    ++pillarsNeeded;
                                }
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                BlockQuartz.EnumType enumType = typeToCheckFor = managerFacing == EnumFacing.NORTH || managerFacing == EnumFacing.SOUTH ? BlockQuartz.EnumType.LINES_Z : BlockQuartz.EnumType.LINES_X;
                                if (!this.isReinforcedCrystalQuartzPillar(currentState) && !replaceable || currentState.func_177230_c() instanceof BlockReinforcedCrystalQuartz && currentState.func_177229_b((IProperty)BlockReinforcedCrystalQuartz.field_176335_a) != typeToCheckFor) {
                                    return new TextComponentTranslation("messages.securitycraft:blockpocket.blockInWay", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0])});
                                }
                                if (replaceable) {
                                    ++pillarsNeeded;
                                }
                            } else if (xi > 0 && zi > 0 && xi < highest && zi < highest) {
                                if (!(currentState.func_177230_c() instanceof BlockBlockPocketWall) && !replaceable) {
                                    return new TextComponentTranslation("messages.securitycraft:blockpocket.blockInWay", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0])});
                                }
                                if (replaceable) {
                                    ++wallsNeeded;
                                }
                            }
                        } else if (yi != 0 && yi != highest && (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest)) {
                            if (!this.isReinforcedCrystalQuartzPillar(currentState) && !replaceable || currentState.func_177230_c() instanceof BlockReinforcedCrystalQuartz && currentState.func_177229_b((IProperty)BlockReinforcedCrystalQuartz.field_176335_a) != BlockQuartz.EnumType.LINES_Y) {
                                return new TextComponentTranslation("messages.securitycraft:blockpocket.blockInWay", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0])});
                            }
                            if (replaceable) {
                                ++pillarsNeeded;
                            }
                        } else if (yi > 0 && yi < highest) {
                            if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                if (!(currentState.func_177230_c() instanceof BlockBlockPocketWall) && !replaceable) {
                                    return new TextComponentTranslation("messages.securitycraft:blockpocket.blockInWay", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0])});
                                }
                                if (replaceable) {
                                    ++wallsNeeded;
                                }
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                if (!(currentState.func_177230_c() instanceof BlockBlockPocketWall) && !replaceable) {
                                    return new TextComponentTranslation("messages.securitycraft:blockpocket.blockInWay", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0])});
                                }
                                if (replaceable) {
                                    ++wallsNeeded;
                                }
                            }
                        }
                        if (this.field_145850_b.func_175625_s(currentPos) instanceof TileEntityOwnable) {
                            TileEntityOwnable te = (TileEntityOwnable)this.field_145850_b.func_175625_s(currentPos);
                            if (!this.getOwner().owns(te)) {
                                return new TextComponentTranslation("messages.securitycraft:blockpocket.unowned", new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0])});
                            }
                        }
                        ++xi;
                    }
                    xi = 0;
                    pos = startingPos.func_177981_b(yi).func_177967_a(back, ++zi);
                }
                zi = 0;
                pos = startingPos.func_177981_b(++yi);
            }
            if (chiseledNeeded + pillarsNeeded + wallsNeeded == 0) {
                return new TextComponentTranslation("messages.securitycraft:blockpocket.alreadyAssembled", new Object[0]);
            }
            pos = this.func_174877_v().func_185334_h().func_177967_a(right, -half);
            xi = 0;
            yi = 0;
            zi = 0;
            while (yi < this.size) {
                while (zi < this.size) {
                    while (xi < this.size) {
                        if (xi > 0 && yi > 0 && zi > 0 && xi < highest && yi < highest && zi < highest) {
                            ++xi;
                            continue;
                        }
                        currentPos = pos.func_177967_a(right, xi);
                        currentState = this.field_145850_b.func_180495_p(currentPos);
                        if (currentState.func_177230_c() instanceof BlockBlockPocketManager && !currentPos.equals((Object)this.func_174877_v())) {
                            return new TextComponentTranslation("messages.securitycraft:blockpocket.multipleManagers", new Object[0]);
                        }
                        if (yi == 0 && !currentPos.equals((Object)this.func_174877_v()) || yi == highest) {
                            BlockQuartz.EnumType typeToPlace;
                            if (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest) {
                                this.placeQueue.add((Pair<BlockPos, IBlockState>)Pair.of((Object)currentPos, (Object)SCContent.reinforcedCrystalQuartz.func_176223_P().func_177226_a((IProperty)BlockReinforcedCrystalQuartz.field_176335_a, (Comparable)BlockQuartz.EnumType.CHISELED)));
                            } else if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                typeToPlace = managerFacing == EnumFacing.NORTH || managerFacing == EnumFacing.SOUTH ? BlockQuartz.EnumType.LINES_X : BlockQuartz.EnumType.LINES_Z;
                                this.placeQueue.add((Pair<BlockPos, IBlockState>)Pair.of((Object)currentPos, (Object)SCContent.reinforcedCrystalQuartz.func_176223_P().func_177226_a((IProperty)BlockReinforcedCrystalQuartz.field_176335_a, (Comparable)typeToPlace)));
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                typeToPlace = managerFacing == EnumFacing.NORTH || managerFacing == EnumFacing.SOUTH ? BlockQuartz.EnumType.LINES_Z : BlockQuartz.EnumType.LINES_X;
                                this.placeQueue.add((Pair<BlockPos, IBlockState>)Pair.of((Object)currentPos, (Object)SCContent.reinforcedCrystalQuartz.func_176223_P().func_177226_a((IProperty)BlockReinforcedCrystalQuartz.field_176335_a, (Comparable)typeToPlace)));
                            } else if (xi > 0 && zi > 0 && xi < highest && zi < highest) {
                                this.placeQueue.add((Pair<BlockPos, IBlockState>)Pair.of((Object)currentPos, (Object)SCContent.blockPocketWall.func_176223_P()));
                            }
                        } else if (yi != 0 && yi != highest && (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest)) {
                            this.placeQueue.add((Pair<BlockPos, IBlockState>)Pair.of((Object)currentPos, (Object)SCContent.reinforcedCrystalQuartz.func_176223_P().func_177226_a((IProperty)BlockReinforcedCrystalQuartz.field_176335_a, (Comparable)BlockQuartz.EnumType.LINES_Y)));
                        } else if (yi > 0 && yi < highest) {
                            if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                this.placeQueue.add((Pair<BlockPos, IBlockState>)Pair.of((Object)currentPos, (Object)SCContent.blockPocketWall.func_176223_P()));
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                this.placeQueue.add((Pair<BlockPos, IBlockState>)Pair.of((Object)currentPos, (Object)SCContent.blockPocketWall.func_176223_P()));
                            }
                        }
                        ++xi;
                    }
                    xi = 0;
                    pos = startingPos.func_177981_b(yi).func_177967_a(back, ++zi);
                }
                zi = 0;
                pos = startingPos.func_177981_b(++yi);
            }
            this.shouldPlaceBlocks = true;
            return null;
        }
        return null;
    }

    public void disableMultiblock() {
        if (this.enabled) {
            if (this.field_145850_b.field_72995_K) {
                SecurityCraft.network.sendToServer((IMessage)new ToggleBlockPocketManager(this, false, this.size));
            }
            PlayerUtils.sendMessageToPlayer(SecurityCraft.proxy.getClientPlayer(), (ITextComponent)Utils.localize(SCContent.blockPocketManager.func_149739_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:blockpocket.deactivated", new Object[0]), TextFormatting.DARK_AQUA, true);
            this.enabled = false;
            for (BlockPos pos : this.blocks) {
                TileEntity te = this.field_145850_b.func_175625_s(pos);
                if (!(te instanceof TileEntityBlockPocket)) continue;
                ((TileEntityBlockPocket)te).removeManager();
            }
            for (BlockPos pos : this.floor) {
                IBlockState state = this.field_145850_b.func_180495_p(pos);
                if (!state.func_177228_b().containsKey((Object)BlockBlockPocketWall.SOLID)) continue;
                this.field_145850_b.func_175656_a(pos, state.func_177226_a((IProperty)BlockBlockPocketWall.SOLID, (Comparable)Boolean.valueOf(false)));
            }
            if (this.isModuleEnabled(EnumModuleType.DISGUISE)) {
                this.setWalls(true);
            }
            this.blocks.clear();
            this.walls.clear();
            this.floor.clear();
        }
    }

    private TextComponentTranslation getFormattedRelativeCoordinates(BlockPos pos, EnumFacing managerFacing) {
        int offsetLeft;
        int offsetBehind;
        BlockPos difference = pos.func_177973_b((Vec3i)this.field_174879_c);
        int offsetAbove = difference.func_177956_o();
        ArrayList<TextComponentTranslation> components = new ArrayList<TextComponentTranslation>();
        switch (managerFacing) {
            case NORTH: {
                offsetBehind = difference.func_177952_p();
                offsetLeft = difference.func_177958_n();
                break;
            }
            case SOUTH: {
                offsetBehind = -difference.func_177952_p();
                offsetLeft = -difference.func_177958_n();
                break;
            }
            case WEST: {
                offsetBehind = difference.func_177958_n();
                offsetLeft = -difference.func_177952_p();
                break;
            }
            case EAST: {
                offsetBehind = -difference.func_177958_n();
                offsetLeft = difference.func_177952_p();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Block Pocket Manager direction: " + managerFacing.name());
            }
        }
        if (offsetLeft > 0) {
            components.add(Utils.localize("messages.securitycraft:blockpocket.position.blocksLeft", offsetLeft));
        } else if (offsetLeft < 0) {
            components.add(Utils.localize("messages.securitycraft:blockpocket.position.blocksRight", -offsetLeft));
        }
        if (offsetBehind > 0) {
            components.add(Utils.localize("messages.securitycraft:blockpocket.position.blocksBehind", offsetBehind));
        }
        if (offsetAbove > 0) {
            components.add(Utils.localize("messages.securitycraft:blockpocket.position.blocksAbove", offsetAbove));
        }
        return Utils.localize("messages.securitycraft:blockpocket.position." + components.size(), components.toArray());
    }

    public void toggleOutline() {
        this.showOutline = !this.showOutline;
    }

    public void setWalls(boolean seeThrough) {
        for (BlockPos pos : this.walls) {
            IBlockState state = this.field_145850_b.func_180495_p(pos);
            if (!(state.func_177230_c() instanceof BlockBlockPocketWall)) continue;
            this.field_145850_b.func_175656_a(pos, state.func_177226_a((IProperty)BlockBlockPocketWall.SEE_THROUGH, (Comparable)Boolean.valueOf(seeThrough)));
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.isPlacingBlocks()) {
                return (T)this.getInsertOnlyHandler();
            }
            return (T)BlockUtils.getProtectedCapability(side, this, () -> this.getStorageHandler(), () -> this.getInsertOnlyHandler());
        }
        return (T)super.getCapability(cap, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.func_175667_e(this.field_174879_c) && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() != SCContent.blockPocketManager) {
            this.disableMultiblock();
        }
    }

    @Override
    public void onModuleInserted(ItemStack stack, EnumModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        if (this.enabled && module == EnumModuleType.DISGUISE) {
            this.setWalls(false);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, EnumModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (this.enabled && module == EnumModuleType.DISGUISE) {
            this.setWalls(true);
        } else if (module == EnumModuleType.STORAGE) {
            IItemHandler handler = this.getStorageHandler();
            for (int i = 0; i < handler.getSlots(); ++i) {
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)handler.getStackInSlot(i));
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        int i;
        tag.func_74757_a("BlockPocketEnabled", this.enabled);
        tag.func_74757_a("ShowOutline", this.showOutline);
        tag.func_74768_a("Size", this.size);
        tag.func_74768_a("AutoBuildOffset", this.autoBuildOffset);
        tag.func_74768_a("Color", this.color);
        ItemStackHelper.func_191282_a((NBTTagCompound)tag, this.storage);
        for (i = 0; i < this.blocks.size(); ++i) {
            tag.func_74772_a("BlocksList" + i, this.blocks.get(i).func_177986_g());
        }
        for (i = 0; i < this.walls.size(); ++i) {
            tag.func_74772_a("WallsList" + i, this.walls.get(i).func_177986_g());
        }
        for (i = 0; i < this.floor.size(); ++i) {
            tag.func_74772_a("FloorList" + i, this.floor.get(i).func_177986_g());
        }
        return super.func_189515_b(tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        int i = 0;
        super.func_145839_a(tag);
        this.enabled = tag.func_74767_n("BlockPocketEnabled");
        this.showOutline = tag.func_74767_n("ShowOutline");
        this.size = tag.func_74762_e("Size");
        this.autoBuildOffset = tag.func_74762_e("AutoBuildOffset");
        this.setColor(tag.func_74762_e("Color"));
        ItemStackHelper.func_191283_b((NBTTagCompound)tag, this.storage);
        while (tag.func_74764_b("BlocksList" + i)) {
            this.blocks.add(BlockPos.func_177969_a((long)tag.func_74763_f("BlocksList" + i)));
            ++i;
        }
        i = 0;
        while (tag.func_74764_b("WallsList" + i)) {
            this.walls.add(BlockPos.func_177969_a((long)tag.func_74763_f("WallsList" + i)));
            ++i;
        }
        i = 0;
        while (tag.func_74764_b("FloorList" + i)) {
            this.floor.add(BlockPos.func_177969_a((long)tag.func_74763_f("FloorList" + i)));
            ++i;
        }
    }

    @Override
    public EnumModuleType[] acceptedModules() {
        return new EnumModuleType[]{EnumModuleType.DISGUISE, EnumModuleType.ALLOWLIST, EnumModuleType.STORAGE};
    }

    @Override
    public Option<?>[] customOptions() {
        return null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v()).func_186662_g(100.0);
    }

    private boolean isReinforcedCrystalQuartzPillar(IBlockState state) {
        if (state.func_177230_c() instanceof BlockReinforcedCrystalQuartz) {
            BlockQuartz.EnumType type = (BlockQuartz.EnumType)state.func_177229_b((IProperty)BlockReinforcedCrystalQuartz.field_176335_a);
            return type == BlockQuartz.EnumType.LINES_X || type == BlockQuartz.EnumType.LINES_Y || type == BlockQuartz.EnumType.LINES_Z;
        }
        return false;
    }

    public IItemHandler getStorageHandler() {
        if (this.storageHandler == null) {
            this.storageHandler = new ItemStackHandler(this.storage){

                public boolean isItemValid(int slot, ItemStack stack) {
                    return TileEntityBlockPocketManager.isItemValid(stack);
                }
            };
        }
        return this.storageHandler;
    }

    private IItemHandler getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null) {
            this.insertOnlyHandler = new InsertOnlyItemStackHandler(this.storage){

                public boolean isItemValid(int slot, ItemStack stack) {
                    return TileEntityBlockPocketManager.isItemValid(stack);
                }
            };
        }
        return this.insertOnlyHandler;
    }

    public boolean isPlacingBlocks() {
        return this.shouldPlaceBlocks;
    }

    public static boolean isItemValid(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            return block == SCContent.blockPocketWall || block == SCContent.reinforcedCrystalQuartz && stack.func_77960_j() >= 1;
        }
        return false;
    }

    public void setColor(int color) {
        this.color = MathHelper.func_76125_a((int)color, (int)-16777216, (int)-1);
    }

    public int getColor() {
        return this.color;
    }
}

