/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.BlockInventoryScanner;
import net.geforcemods.securitycraft.blocks.BlockInventoryScannerField;
import net.geforcemods.securitycraft.inventory.ExtractOnlyItemStackHandler;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.tileentity.TileEntityDisguisable;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.TileEntityRenderDelegate;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class TileEntityInventoryScanner
extends TileEntityDisguisable
implements IInventory,
ITickable,
ILockable {
    private Option.OptionBoolean horizontal = new Option.OptionBoolean("horizontal", false);
    private Option.OptionBoolean solidifyField = new Option.OptionBoolean("solidifyField", false);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private IItemHandler storageHandler;
    private NonNullList<ItemStack> inventoryContents = NonNullList.func_191197_a((int)37, (Object)ItemStack.field_190927_a);
    private boolean isProvidingPower;
    private int cooldown;

    public void func_73660_a() {
        if (this.cooldown > 0) {
            --this.cooldown;
        } else if (this.isProvidingPower) {
            this.isProvidingPower = false;
            BlockUtils.updateAndNotify(this.func_145831_w(), this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c(), 1, true);
            BlockUtils.updateIndirectNeighbors(this.field_145850_b, this.field_174879_c, SCContent.inventoryScanner);
        }
    }

    @Override
    public void onOwnerChanged(IBlockState state, World world, BlockPos pos, EntityPlayer player) {
        TileEntityInventoryScanner connectedScanner = BlockInventoryScanner.getConnectedInventoryScanner(world, pos, be -> be.setOwner(this.getOwner().getUUID(), this.getOwner().getName()));
        if (connectedScanner != null) {
            connectedScanner.setOwner(this.getOwner().getUUID(), this.getOwner().getName());
            if (!world.field_72995_K) {
                world.func_73046_m().func_184103_al().func_148540_a((Packet)connectedScanner.func_189518_D_());
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList list = tag.func_150295_c("Items", 10);
        this.inventoryContents = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound stackTag = list.func_150305_b(i);
            int slot = stackTag.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= this.inventoryContents.size()) continue;
            this.inventoryContents.set(slot, (Object)new ItemStack(stackTag));
        }
        this.cooldown = tag.func_74762_e("cooldown");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.inventoryContents.size(); ++i) {
            if (((ItemStack)this.inventoryContents.get(i)).func_190926_b()) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.inventoryContents.get(i)).func_77955_b(stackTag);
            list.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a("Items", (NBTBase)list);
        tag.func_74768_a("cooldown", this.cooldown);
        return tag;
    }

    public int func_70302_i_() {
        return 37;
    }

    public ItemStack func_70298_a(int index, int count) {
        if (!((ItemStack)this.inventoryContents.get(index)).func_190926_b()) {
            if (((ItemStack)this.inventoryContents.get(index)).func_190916_E() <= count) {
                ItemStack stack = (ItemStack)this.inventoryContents.get(index);
                this.inventoryContents.set(index, (Object)ItemStack.field_190927_a);
                this.func_70296_d();
                return stack;
            }
            ItemStack stack = ((ItemStack)this.inventoryContents.get(index)).func_77979_a(count);
            if (((ItemStack)this.inventoryContents.get(index)).func_190916_E() == 0) {
                this.inventoryContents.set(index, (Object)ItemStack.field_190927_a);
            }
            this.func_70296_d();
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : (ItemStack)this.inventoryContents.get(slot);
    }

    public ItemStack getStackInSlotCopy(int index) {
        return (ItemStack)this.inventoryContents.get(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryContents.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public void addItemToStorage(ItemStack stack) {
        ItemStack remainder = stack;
        for (int i = 10; i < this.getContents().size() && !(remainder = this.insertItem(i, remainder)).func_190926_b(); ++i) {
        }
    }

    public ItemStack insertItem(int slot, ItemStack stackToInsert) {
        if (stackToInsert.func_190926_b() || slot < 0 || slot >= this.getContents().size()) {
            return stackToInsert;
        }
        ItemStack slotStack = this.func_70301_a(slot);
        int limit = stackToInsert.func_77973_b().getItemStackLimit(stackToInsert);
        if (slotStack.func_190926_b()) {
            this.func_70299_a(slot, stackToInsert);
            return ItemStack.field_190927_a;
        }
        if (BlockInventoryScannerField.areItemStacksEqual(slotStack, stackToInsert) && slotStack.func_190916_E() < limit) {
            if (limit - slotStack.func_190916_E() >= stackToInsert.func_190916_E()) {
                slotStack.func_190920_e(slotStack.func_190916_E() + stackToInsert.func_190916_E());
                return ItemStack.field_190927_a;
            }
            ItemStack toInsert = stackToInsert.func_77946_l();
            ItemStack toReturn = toInsert.func_77979_a(slotStack.func_190916_E() + stackToInsert.func_190916_E() - limit);
            slotStack.func_190920_e(slotStack.func_190916_E() + toInsert.func_190916_E());
            return toReturn;
        }
        return stackToInsert;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)BlockUtils.getProtectedCapability(facing, this, () -> this.getExtractionHandler(), () -> EmptyHandler.INSTANCE);
        }
        return (T)super.getCapability(capability, facing);
    }

    public IItemHandler getExtractionHandler() {
        if (this.storageHandler == null) {
            this.storageHandler = new ExtractOnlyItemStackHandler(this.inventoryContents){

                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    return slot < 10 ? ItemStack.field_190927_a : super.extractItem(slot, amount, simulate);
                }
            };
        }
        return this.storageHandler;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return true;
    }

    public boolean shouldProvidePower() {
        return this.isModuleEnabled(EnumModuleType.REDSTONE) && this.isProvidingPower;
    }

    public void setShouldProvidePower(boolean isProvidingPower) {
        this.isProvidingPower = isProvidingPower;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public NonNullList<ItemStack> getContents() {
        return this.inventoryContents;
    }

    public void setContents(NonNullList<ItemStack> contents) {
        this.inventoryContents = contents;
    }

    @Override
    public void onModuleInserted(ItemStack stack, EnumModuleType module, boolean toggled) {
        Predicate<EnumModuleType> test;
        super.onModuleInserted(stack, module, toggled);
        TileEntityInventoryScanner connectedScanner = BlockInventoryScanner.getConnectedInventoryScanner(this.field_145850_b, this.field_174879_c);
        if (connectedScanner == null) {
            return;
        }
        Predicate<EnumModuleType> predicate = toggled ? connectedScanner::isModuleEnabled : (test = connectedScanner::hasModule);
        if (connectedScanner != null && !test.test(module)) {
            connectedScanner.insertModule(stack, toggled);
        }
        if (this.field_145850_b.field_72995_K && module == EnumModuleType.DISGUISE) {
            TileEntityRenderDelegate.putDisguisedTeRenderer(this, stack);
            if (connectedScanner != null) {
                TileEntityRenderDelegate.putDisguisedTeRenderer(connectedScanner, stack);
            }
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, EnumModuleType module, boolean toggled) {
        Predicate<EnumModuleType> test;
        super.onModuleRemoved(stack, module, toggled);
        TileEntityInventoryScanner connectedScanner = BlockInventoryScanner.getConnectedInventoryScanner(this.field_145850_b, this.field_174879_c);
        if (connectedScanner == null) {
            return;
        }
        Predicate<EnumModuleType> predicate = toggled ? connectedScanner::isModuleEnabled : (test = connectedScanner::hasModule);
        if (connectedScanner != null && test.test(module)) {
            connectedScanner.removeModule(module, toggled);
        }
        if (module == EnumModuleType.STORAGE) {
            int i;
            for (i = 10; i < this.func_70302_i_(); ++i) {
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)((ItemStack)this.getContents().get(i)));
            }
            if (connectedScanner != null) {
                for (i = 10; i < connectedScanner.func_70302_i_(); ++i) {
                    connectedScanner.getContents().set(i, (Object)ItemStack.field_190927_a);
                }
            }
        } else if (module == EnumModuleType.DISGUISE && this.field_145850_b.field_72995_K) {
            TileEntityRenderDelegate.DISGUISED_BLOCK.removeDelegateOf(this);
            if (connectedScanner != null) {
                TileEntityRenderDelegate.DISGUISED_BLOCK.removeDelegateOf(connectedScanner);
            }
        }
    }

    @Override
    public EnumModuleType[] acceptedModules() {
        return new EnumModuleType[]{EnumModuleType.ALLOWLIST, EnumModuleType.SMART, EnumModuleType.STORAGE, EnumModuleType.DISGUISE, EnumModuleType.REDSTONE};
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        if (option.getName().equals("horizontal")) {
            Option.OptionBoolean bo = (Option.OptionBoolean)option;
            this.modifyFields((offsetPos, state) -> this.field_145850_b.func_175656_a(offsetPos, state.func_177226_a((IProperty)BlockInventoryScannerField.HORIZONTAL, (Comparable)bo.get())), connectedScanner -> connectedScanner.setHorizontal((Boolean)bo.get()));
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockInventoryScanner.HORIZONTAL, (Comparable)bo.get()));
        } else if (option.getName().equals("solidifyField")) {
            Option.OptionBoolean bo = (Option.OptionBoolean)option;
            TileEntityInventoryScanner connectedScanner2 = BlockInventoryScanner.getConnectedInventoryScanner(this.field_145850_b, this.field_174879_c);
            if (connectedScanner2 != null) {
                connectedScanner2.setSolidifyField((Boolean)bo.get());
            }
        } else if (option.getName().equals("disabled")) {
            Option.OptionBoolean bo = (Option.OptionBoolean)option;
            if (!((Boolean)bo.get()).booleanValue()) {
                BlockInventoryScanner.checkAndPlaceAppropriately(this.field_145850_b, this.field_174879_c, null, true);
            } else {
                this.modifyFields((offsetPos, state) -> this.field_145850_b.func_175655_b(offsetPos, false), connectedScanner -> connectedScanner.setDisabled(true));
            }
        }
    }

    private void modifyFields(BiConsumer<BlockPos, IBlockState> blockSetter, Consumer<TileEntityInventoryScanner> connectedScannerModifier) {
        TileEntityInventoryScanner connectedScanner = BlockInventoryScanner.getConnectedInventoryScanner(this.field_145850_b, this.field_174879_c);
        IBlockState thisState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (connectedScanner != null) {
            EnumFacing facing = (EnumFacing)thisState.func_177229_b((IProperty)BlockInventoryScanner.FACING);
            connectedScannerModifier.accept(connectedScanner);
            for (int i = 0; i <= ConfigHandler.inventoryScannerRange; ++i) {
                BlockPos offsetPos = this.field_174879_c.func_177967_a(facing, i);
                IBlockState state = this.field_145850_b.func_180495_p(offsetPos);
                Block block = state.func_177230_c();
                if (block == SCContent.inventoryScannerField) {
                    blockSetter.accept(offsetPos, state);
                    continue;
                }
                if (!block.isAir(thisState, (IBlockAccess)this.field_145850_b, offsetPos) && block != SCContent.inventoryScannerField && block != SCContent.inventoryScanner || block == SCContent.inventoryScanner && state.func_177229_b((IProperty)BlockInventoryScanner.FACING) == facing.func_176734_d()) break;
            }
        }
    }

    public void setHorizontal(boolean isHorizontal) {
        if (this.isHorizontal() != isHorizontal) {
            this.horizontal.setValue(isHorizontal);
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockInventoryScanner.HORIZONTAL, (Comparable)Boolean.valueOf(isHorizontal)));
        }
    }

    public boolean isHorizontal() {
        return (Boolean)this.horizontal.get();
    }

    public boolean doesFieldSolidify() {
        return (Boolean)this.solidifyField.get();
    }

    public void setSolidifyField(boolean shouldSolidify) {
        if (this.doesFieldSolidify() != shouldSolidify) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.solidifyField.setValue(shouldSolidify);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public void setDisabled(boolean disabled) {
        if (this.isDisabled() != disabled) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.disabled.setValue(disabled);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.horizontal, this.solidifyField, this.disabled};
    }

    public void func_174888_l() {
        this.inventoryContents.clear();
    }

    public boolean func_191420_l() {
        return this.inventoryContents.isEmpty();
    }

    public ItemStack func_70304_b(int index) {
        return (ItemStack)this.inventoryContents.remove(index);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }
}

