/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.ArrayList;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.api.TileEntityLinkable;
import net.geforcemods.securitycraft.blocks.BlockDisguisable;
import net.geforcemods.securitycraft.blocks.BlockLaserBlock;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.network.client.RefreshDiguisedModel;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.TileEntityRenderDelegate;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityLaserBlock
extends TileEntityLinkable {
    private Option.DisabledOption disabled = new Option.DisabledOption((Boolean)false){

        @Override
        public void toggle() {
            this.setValue((Boolean)this.get() == false);
            TileEntityLaserBlock.this.toggleLaser(this);
        }
    };

    private void toggleLaser(Option.OptionBoolean option) {
        Block block = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        if (block != SCContent.laserBlock) {
            return;
        }
        if (((Boolean)option.get()).booleanValue()) {
            ((BlockLaserBlock)block).setLaser(((TileEntityLaserBlock)this.field_145850_b.func_175625_s(this.field_174879_c)).getOwner(), this.field_145850_b, this.field_174879_c);
        } else {
            BlockLaserBlock.destroyAdjacentLasers(this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    protected void onLinkedBlockAction(ILinkedAction action, ArrayList<TileEntityLinkable> excludedTEs) {
        if (action instanceof ILinkedAction.OptionChanged) {
            Option option = ((ILinkedAction.OptionChanged)action).option;
            this.disabled.copy(option);
            this.toggleLaser((Option.OptionBoolean)option);
        } else if (action instanceof ILinkedAction.ModuleInserted) {
            ILinkedAction.ModuleInserted moduleInserted = (ILinkedAction.ModuleInserted)action;
            ItemStack module = moduleInserted.stack;
            boolean toggled = moduleInserted.wasModuleToggled;
            this.insertModule(module, toggled);
        } else if (action instanceof ILinkedAction.ModuleRemoved) {
            ILinkedAction.ModuleRemoved moduleRemoved = (ILinkedAction.ModuleRemoved)action;
            EnumModuleType module = moduleRemoved.moduleType;
            boolean toggled = moduleRemoved.wasModuleToggled;
            this.removeModule(module, toggled);
        } else if (action instanceof ILinkedAction.OwnerChanged) {
            Owner owner = ((ILinkedAction.OwnerChanged)action).newOwner;
            this.setOwner(owner.getUUID(), owner.getName());
        }
        excludedTEs.add(this);
        this.createLinkedBlockAction(action, excludedTEs);
    }

    @Override
    public void onModuleInserted(ItemStack stack, EnumModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        if (module == EnumModuleType.DISGUISE) {
            this.onInsertDisguiseModule(stack, toggled);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, EnumModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == EnumModuleType.DISGUISE) {
            this.onRemoveDisguiseModule(stack, toggled);
        } else if (module == EnumModuleType.REDSTONE) {
            this.onRemoveRedstoneModule();
        }
    }

    private void onInsertDisguiseModule(ItemStack stack, boolean toggled) {
        if (!this.field_145850_b.field_72995_K) {
            SecurityCraft.network.sendToAllTracking((IMessage)new RefreshDiguisedModel(this.field_174879_c, true, stack, toggled), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 0.0));
        } else {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            TileEntityRenderDelegate.putDisguisedTeRenderer(this, stack);
            if (state.getLightValue((IBlockAccess)this.field_145850_b, this.field_174879_c) > 0) {
                this.field_145850_b.func_175664_x(this.field_174879_c);
            }
        }
    }

    private void onRemoveDisguiseModule(ItemStack stack, boolean toggled) {
        if (!this.field_145850_b.field_72995_K) {
            SecurityCraft.network.sendToAllTracking((IMessage)new RefreshDiguisedModel(this.field_174879_c, false, stack, toggled), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 0.0));
        } else {
            IBlockState disguisedState = ((BlockDisguisable)this.field_145854_h).getDisguisedBlockStateFromStack(null, null, stack);
            TileEntityRenderDelegate.DISGUISED_BLOCK.removeDelegateOf(this);
            if (disguisedState != null && disguisedState.getLightValue((IBlockAccess)this.field_145850_b, this.field_174879_c) > 0) {
                this.field_145850_b.func_175664_x(this.field_174879_c);
            }
        }
    }

    private void onRemoveRedstoneModule() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (((Boolean)state.func_177229_b((IProperty)BlockLaserBlock.POWERED)).booleanValue()) {
            this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockLaserBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors(this.field_145850_b, this.field_174879_c, SCContent.laserBlock);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.field_145850_b.field_72995_K) {
            TileEntityRenderDelegate.putDisguisedTeRenderer(this, this.getModule(EnumModuleType.DISGUISE));
        }
    }

    @Override
    public void readOptions(NBTTagCompound tag) {
        if (tag.func_74764_b("enabled")) {
            tag.func_74757_a("disabled", !tag.func_74767_n("enabled"));
        }
        for (Option<?> option : this.customOptions()) {
            option.readFromNBT(tag);
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            TileEntityRenderDelegate.DISGUISED_BLOCK.removeDelegateOf(this);
        }
    }

    @Override
    public EnumModuleType[] acceptedModules() {
        return new EnumModuleType[]{EnumModuleType.HARMING, EnumModuleType.ALLOWLIST, EnumModuleType.DISGUISE, EnumModuleType.REDSTONE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.disabled};
    }

    public boolean isEnabled() {
        return (Boolean)this.disabled.get() == false;
    }
}

