/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import com.google.common.collect.Lists;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.ToIntFunction;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.BlockRiftStabilizer;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.misc.TileEntityTracker;
import net.geforcemods.securitycraft.network.server.SyncRiftStabilizer;
import net.geforcemods.securitycraft.tileentity.TileEntityDisguisable;
import net.geforcemods.securitycraft.util.IToggleableEntries;
import net.geforcemods.securitycraft.util.TileEntityRenderDelegate;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TileEntityRiftStabilizer
extends TileEntityDisguisable
implements ITickable,
ILockable,
IToggleableEntries<TeleportationType> {
    private final Option.OptionInt signalLength = new Option.OptionInt(() -> ((TileEntityRiftStabilizer)this).func_174877_v(), "signalLength", 60, 5, 400, 5, true);
    private final Option.OptionInt range = new Option.OptionInt(() -> ((TileEntityRiftStabilizer)this).func_174877_v(), "range", 5, 1, 15, 1, true);
    private final Option.DisabledOption disabled = new Option.DisabledOption(false);
    private final Map<TeleportationType, Boolean> teleportationFilter = new EnumMap<TeleportationType, Boolean>(TeleportationType.class);
    private double lastTeleportDistance;
    private TeleportationType lastTeleportationType;
    private boolean tracked = false;

    public TileEntityRiftStabilizer() {
        this.teleportationFilter.put(TeleportationType.CHORUS_FRUIT, true);
        this.teleportationFilter.put(TeleportationType.ENDER_PEARL, true);
        this.teleportationFilter.put(TeleportationType.ENDERMAN, false);
        this.teleportationFilter.put(TeleportationType.SHULKER, false);
        this.teleportationFilter.put(TeleportationType.MODDED, false);
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockRiftStabilizer.HALF) == BlockDoor.EnumDoorHalf.LOWER && !this.tracked) {
            TileEntityTracker.RIFT_STABILIZER.track(this);
            this.tracked = true;
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        TileEntityTracker.RIFT_STABILIZER.stopTracking(this);
    }

    @Override
    public void setFilter(TeleportationType teleportationType, boolean allowed) {
        if (this.teleportationFilter.containsKey((Object)teleportationType)) {
            TileEntityRiftStabilizer connectedTileEntity;
            this.teleportationFilter.put(teleportationType, allowed);
            if (this.field_145850_b.field_72995_K) {
                SecurityCraft.network.sendToServer((IMessage)new SyncRiftStabilizer(this.field_174879_c, teleportationType, allowed));
            }
            if ((connectedTileEntity = BlockRiftStabilizer.getConnectedTileEntity(this.field_145850_b, this.field_174879_c)) != null) {
                connectedTileEntity.teleportationFilter.put(teleportationType, allowed);
                if (this.field_145850_b.field_72995_K) {
                    SecurityCraft.network.sendToServer((IMessage)new SyncRiftStabilizer(connectedTileEntity.field_174879_c, teleportationType, allowed));
                }
            }
        }
    }

    @Override
    public boolean getFilter(TeleportationType teleportationType) {
        return this.teleportationFilter.containsKey((Object)teleportationType) && this.teleportationFilter.get((Object)teleportationType) != false;
    }

    @Override
    public String getTypeName(TeleportationType type) {
        return Utils.localize(type.label, new Object[0]).func_150254_d();
    }

    @Override
    public ToIntFunction<TeleportationType> getComparatorOutputFunction() {
        return t -> Lists.newArrayList((Object[])TeleportationType.values()).indexOf(t) + 1;
    }

    @Override
    public Map<TeleportationType, Boolean> getFilters() {
        return this.teleportationFilter;
    }

    @Override
    public TeleportationType getDefaultType() {
        return TeleportationType.MODDED;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagCompound teleportationNBT = new NBTTagCompound();
        int i = 0;
        for (boolean b : this.teleportationFilter.values()) {
            teleportationNBT.func_74757_a("teleportationType" + i, b);
            ++i;
        }
        tag.func_74782_a("teleportationTypes", (NBTBase)teleportationNBT);
        tag.func_74780_a("lastTeleportDistance", this.lastTeleportDistance);
        if (this.lastTeleportationType != null) {
            tag.func_74768_a("lastTeleportationType", Lists.newArrayList((Object[])TeleportationType.values()).indexOf((Object)this.lastTeleportationType));
        }
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_150297_b("teleportationTypes", 10)) {
            NBTTagCompound teleportationNBT = tag.func_74775_l("teleportationTypes");
            int i = 0;
            for (TeleportationType teleportationType : this.teleportationFilter.keySet()) {
                this.teleportationFilter.put(teleportationType, teleportationNBT.func_74767_n("teleportationType" + i));
                ++i;
            }
        }
        this.lastTeleportDistance = tag.func_74769_h("lastTeleportDistance");
        if (tag.func_74764_b("lastTeleportationType")) {
            this.lastTeleportationType = TeleportationType.values()[tag.func_74762_e("lastTeleportationType")];
        }
    }

    @Override
    public void onModuleInserted(ItemStack stack, EnumModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        TileEntityRiftStabilizer connectedTileEntity = BlockRiftStabilizer.getConnectedTileEntity(this.field_145850_b, this.field_174879_c);
        if (connectedTileEntity != null && (toggled ? !connectedTileEntity.isModuleEnabled(module) : !connectedTileEntity.hasModule(module))) {
            connectedTileEntity.insertModule(stack, toggled);
        }
        if (module == EnumModuleType.DISGUISE) {
            TileEntityRenderDelegate.putDisguisedTeRenderer(this, stack);
            if (connectedTileEntity != null) {
                TileEntityRenderDelegate.putDisguisedTeRenderer(connectedTileEntity, stack);
            }
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, EnumModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        TileEntityRiftStabilizer connectedTileEntity = BlockRiftStabilizer.getConnectedTileEntity(this.field_145850_b, this.field_174879_c);
        if (connectedTileEntity != null && (toggled ? connectedTileEntity.isModuleEnabled(module) : connectedTileEntity.hasModule(module))) {
            connectedTileEntity.removeModule(module, toggled);
        }
        if (module == EnumModuleType.DISGUISE) {
            TileEntityRenderDelegate.DISGUISED_BLOCK.removeDelegateOf(this);
            if (connectedTileEntity != null) {
                TileEntityRenderDelegate.DISGUISED_BLOCK.removeDelegateOf(connectedTileEntity);
            }
        } else if (module == EnumModuleType.SMART) {
            this.onRemoveSmartModule(this);
            if (connectedTileEntity != null) {
                this.onRemoveSmartModule(connectedTileEntity);
            }
        }
    }

    private void onRemoveSmartModule(TileEntityRiftStabilizer te) {
        te.teleportationFilter.put(TeleportationType.CHORUS_FRUIT, true);
        te.teleportationFilter.put(TeleportationType.ENDER_PEARL, true);
        te.teleportationFilter.put(TeleportationType.ENDERMAN, false);
        te.teleportationFilter.put(TeleportationType.SHULKER, false);
        te.teleportationFilter.put(TeleportationType.MODDED, false);
    }

    public void setLastTeleport(double teleportDistance, TeleportationType type) {
        this.lastTeleportDistance = teleportDistance;
        this.lastTeleportationType = type;
    }

    public double getLastTeleportDistance() {
        return this.lastTeleportDistance;
    }

    public TeleportationType getLastTeleportationType() {
        return this.lastTeleportationType;
    }

    @Override
    public EnumModuleType[] acceptedModules() {
        return new EnumModuleType[]{EnumModuleType.ALLOWLIST, EnumModuleType.DISGUISE, EnumModuleType.REDSTONE, EnumModuleType.HARMING, EnumModuleType.SMART};
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        TileEntityRiftStabilizer connectedTileEntity = BlockRiftStabilizer.getConnectedTileEntity(this.field_145850_b, this.field_174879_c);
        if (option.getName().equals("signalLength")) {
            Option.OptionInt intOption = (Option.OptionInt)option;
            if (connectedTileEntity != null) {
                connectedTileEntity.setSignalLength((Integer)intOption.get());
            }
        } else if (option.getName().equals("range")) {
            Option.OptionInt intOption = (Option.OptionInt)option;
            if (connectedTileEntity != null) {
                connectedTileEntity.setRange((Integer)intOption.get());
            }
        } else if (option.getName().equals("disabled")) {
            Option.OptionBoolean bo = (Option.OptionBoolean)option;
            if (connectedTileEntity != null) {
                connectedTileEntity.setDisabled((Boolean)bo.get());
            }
        }
        super.onOptionChanged(option);
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.signalLength, this.range, this.disabled};
    }

    @Override
    public void onOwnerChanged(IBlockState state, World world, BlockPos pos, EntityPlayer player) {
        TileEntityRiftStabilizer te = BlockRiftStabilizer.getConnectedTileEntity(world, pos);
        if (te != null) {
            te.setOwner(this.getOwner().getUUID(), this.getOwner().getName());
            if (!world.field_72995_K) {
                world.func_73046_m().func_184103_al().func_148540_a((Packet)te.func_189518_D_());
            }
        }
        super.onOwnerChanged(state, world, pos, player);
    }

    public void setSignalLength(int signalLength) {
        if (this.getSignalLength() != signalLength) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.signalLength.setValue(signalLength);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public void setRange(int range) {
        if (this.getRange() != range) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.range.setValue(range);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public int getRange() {
        return (Integer)this.range.get();
    }

    public void setDisabled(boolean disabled) {
        if (this.isDisabled() != disabled) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.disabled.setValue(disabled);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public static enum TeleportationType {
        CHORUS_FRUIT(Items.field_185161_cS.func_77658_a() + ".name"),
        ENDER_PEARL(Items.field_151079_bi.func_77658_a() + ".name"),
        ENDERMAN("entity." + ((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("minecraft:enderman"))).getName() + ".name"),
        SHULKER("entity." + ((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("minecraft:shulker"))).getName() + ".name"),
        MODDED("gui.securitycraft:rift_stabilizer.modded");

        public final String label;

        private TeleportationType(String label) {
            this.label = label;
        }

        public static TeleportationType getTypeFromEvent(EntityLivingBase teleported, Vec3d target) {
            Optional pearl = teleported.field_70170_p.func_175644_a(EntityEnderPearl.class, e -> e.func_174791_d().equals((Object)target)).stream().findFirst();
            if (teleported instanceof EntityEnderman) {
                return ENDERMAN;
            }
            if (teleported instanceof EntityShulker) {
                return SHULKER;
            }
            if (teleported instanceof EntityPlayer && pearl.isPresent()) {
                return ENDER_PEARL;
            }
            return MODDED;
        }
    }
}

