/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.blocks.reinforced.BlockReinforcedPistonBase;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockReinforcedPistonStructureHelper {
    private final World world;
    private final BlockPos pistonPos;
    private final BlockPos blockToMove;
    private final EnumFacing moveDirection;
    private final List<BlockPos> toMove = Lists.newArrayList();
    private final List<BlockPos> toDestroy = Lists.newArrayList();

    public BlockReinforcedPistonStructureHelper(World world, BlockPos pos, EnumFacing pistonFacing, boolean extending) {
        this.world = world;
        this.pistonPos = pos;
        if (extending) {
            this.moveDirection = pistonFacing;
            this.blockToMove = pos.func_177972_a(pistonFacing);
        } else {
            this.moveDirection = pistonFacing.func_176734_d();
            this.blockToMove = pos.func_177967_a(pistonFacing, 2);
        }
    }

    public boolean canMove() {
        IBlockState state = this.world.func_180495_p(this.blockToMove);
        this.toMove.clear();
        this.toDestroy.clear();
        if (!BlockReinforcedPistonBase.canPush(state, this.world, this.pistonPos, this.blockToMove, this.moveDirection, false, this.moveDirection)) {
            if (state.func_185905_o() == EnumPushReaction.DESTROY) {
                this.toDestroy.add(this.blockToMove);
                return true;
            }
            return false;
        }
        if (!this.addBlockLine(this.blockToMove, this.moveDirection)) {
            return false;
        }
        for (int i = 0; i < this.toMove.size(); ++i) {
            BlockPos pos = this.toMove.get(i);
            if (!this.world.func_180495_p(pos).func_177230_c().isStickyBlock(this.world.func_180495_p(pos)) || this.addBranchingBlocks(pos)) continue;
            return false;
        }
        return true;
    }

    private boolean addBlockLine(BlockPos origin, EnumFacing facing) {
        IBlockState state = this.world.func_180495_p(origin);
        Block block = state.func_177230_c();
        if (state.func_177230_c().isAir(state, (IBlockAccess)this.world, origin)) {
            return true;
        }
        if (!BlockReinforcedPistonBase.canPush(state, this.world, this.pistonPos, origin, this.moveDirection, false, facing)) {
            return true;
        }
        if (origin.equals((Object)this.pistonPos)) {
            return true;
        }
        if (this.toMove.contains(origin)) {
            return true;
        }
        int i = 1;
        if (i + this.toMove.size() > 12) {
            return false;
        }
        while (block.isStickyBlock(state)) {
            BlockPos blockpos = origin.func_177967_a(this.moveDirection.func_176734_d(), i);
            state = this.world.func_180495_p(blockpos);
            block = state.func_177230_c();
            if (state.func_177230_c().isAir(state, (IBlockAccess)this.world, blockpos) || !BlockReinforcedPistonBase.canPush(state, this.world, this.pistonPos, blockpos, this.moveDirection, false, this.moveDirection.func_176734_d()) || blockpos.equals((Object)this.pistonPos)) break;
            if (++i + this.toMove.size() <= 12) continue;
            return false;
        }
        int i1 = 0;
        for (int j = i - 1; j >= 0; --j) {
            this.toMove.add(origin.func_177967_a(this.moveDirection.func_176734_d(), j));
            ++i1;
        }
        int j1 = 1;
        while (true) {
            BlockPos offsetPos;
            int k;
            if ((k = this.toMove.indexOf(offsetPos = origin.func_177967_a(this.moveDirection, j1))) > -1) {
                this.reorderListAtCollision(i1, k);
                for (int l = 0; l <= k + i1; ++l) {
                    BlockPos posToPush = this.toMove.get(l);
                    if (!this.world.func_180495_p(posToPush).func_177230_c().isStickyBlock(this.world.func_180495_p(posToPush)) || this.addBranchingBlocks(posToPush)) continue;
                    return false;
                }
                return true;
            }
            state = this.world.func_180495_p(offsetPos);
            if (state.func_177230_c().isAir(state, (IBlockAccess)this.world, offsetPos)) {
                return true;
            }
            if (!BlockReinforcedPistonBase.canPush(state, this.world, this.pistonPos, offsetPos, this.moveDirection, true, this.moveDirection) || offsetPos.equals((Object)this.pistonPos)) {
                return false;
            }
            if (state.func_185905_o() == EnumPushReaction.DESTROY) {
                this.toDestroy.add(offsetPos);
                return true;
            }
            if (this.toMove.size() >= 12) {
                return false;
            }
            this.toMove.add(offsetPos);
            ++i1;
            ++j1;
        }
    }

    private void reorderListAtCollision(int offsets, int index) {
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        list.addAll(this.toMove.subList(0, index));
        list1.addAll(this.toMove.subList(this.toMove.size() - offsets, this.toMove.size()));
        list2.addAll(this.toMove.subList(index, this.toMove.size() - offsets));
        this.toMove.clear();
        this.toMove.addAll(list);
        this.toMove.addAll(list1);
        this.toMove.addAll(list2);
    }

    private boolean addBranchingBlocks(BlockPos fromPos) {
        for (EnumFacing direction : EnumFacing.values()) {
            if (direction.func_176740_k() == this.moveDirection.func_176740_k() || this.addBlockLine(fromPos.func_177972_a(direction), direction)) continue;
            return false;
        }
        return true;
    }

    public List<BlockPos> getBlocksToMove() {
        return this.toMove;
    }

    public List<BlockPos> getBlocksToDestroy() {
        return this.toDestroy;
    }
}

