/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.StreamSupport;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.world.World;

public class ModuleUtils {
    public static List<String> getPlayersFromModule(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        if (stack.func_77973_b() instanceof ItemModule && stack.func_77942_o()) {
            for (int i = 1; i <= 50; ++i) {
                if (stack.func_77978_p().func_74779_i("Player" + i) == null || stack.func_77978_p().func_74779_i("Player" + i).isEmpty()) continue;
                list.add(stack.func_77978_p().func_74779_i("Player" + i).toLowerCase());
            }
        }
        return list;
    }

    public static boolean isAllowed(IModuleInventory inv, Entity entity) {
        return ModuleUtils.isAllowed(inv, entity.func_70005_c_());
    }

    public static boolean isAllowed(IModuleInventory inv, String name) {
        if (!inv.isModuleEnabled(EnumModuleType.ALLOWLIST)) {
            return false;
        }
        ItemStack stack = inv.getModule(EnumModuleType.ALLOWLIST);
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("affectEveryone")) {
            return true;
        }
        return ModuleUtils.doesModuleHaveTeamOf(name, inv.getTileEntity().func_145831_w(), stack) || ModuleUtils.getPlayersFromModule(stack).contains(name.toLowerCase());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isDenied(IModuleInventory inv, Entity entity) {
        String name;
        if (!inv.isModuleEnabled(EnumModuleType.DENYLIST)) {
            return false;
        }
        ItemStack stack = inv.getModule(EnumModuleType.DENYLIST);
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("affectEveryone")) {
            if (!(inv.getTileEntity() instanceof IOwnable)) return true;
            if (!(entity instanceof EntityPlayer)) return true;
            if (!((IOwnable)inv.getTileEntity()).getOwner().isOwner((EntityPlayer)entity)) {
                return true;
            }
        }
        if (ModuleUtils.doesModuleHaveTeamOf(name = entity.func_70005_c_(), inv.getTileEntity().func_145831_w(), stack)) return true;
        if (!ModuleUtils.getPlayersFromModule(stack).contains(name.toLowerCase())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean doesModuleHaveTeamOf(String name, World level, ItemStack module) {
        ScorePlayerTeam team = level.func_96441_U().func_96509_i(name);
        if (!module.func_77942_o()) {
            module.func_77982_d(new NBTTagCompound());
        }
        if (team == null) return false;
        if (!StreamSupport.stream(module.func_77978_p().func_150295_c("ListedTeams", 8).spliterator(), false).filter(tag -> tag instanceof NBTTagString).map(tag -> ((NBTTagString)tag).func_150285_a_()).anyMatch(team.func_96661_b()::equals)) return false;
        return true;
    }
}

