/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.waila;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.tileentity.IHeatExchanger;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.thirdparty.waila.WailaCallback;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WailaHeatHandler
implements IWailaDataProvider {
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return ItemStack.field_190927_a;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        WailaHeatHandler.addTipToMachine(currenttip, accessor);
        return currenttip;
    }

    private static void addTipToMachine(List<String> currenttip, IWailaDataAccessor accessor) {
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74764_b("heat")) {
            NBTTagList tagList = tag.func_150295_c("heat", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound heatTag = tagList.func_150305_b(i);
                EnumFacing face = EnumFacing.func_82600_a((int)heatTag.func_74771_c("side"));
                currenttip.add(HeatUtil.formatHeatString(face, heatTag.func_74762_e("temp")));
            }
        } else {
            currenttip.add(WailaCallback.COLOR + HeatUtil.formatHeatString(tag.func_74762_e("temp")));
        }
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Nonnull
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (te instanceof IHeatExchanger) {
            HashSet<IHeatExchangerLogic> heatExchangers = new HashSet<IHeatExchangerLogic>();
            IHeatExchangerLogic logic = null;
            boolean isMultisided = true;
            for (EnumFacing face : EnumFacing.field_82609_l) {
                logic = ((IHeatExchanger)te).getHeatExchangerLogic(face);
                if (logic == null) continue;
                if (heatExchangers.contains(logic)) {
                    isMultisided = false;
                    break;
                }
                heatExchangers.add(logic);
            }
            if (isMultisided) {
                NBTTagList tagList = new NBTTagList();
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    logic = ((IHeatExchanger)te).getHeatExchangerLogic(face);
                    if (logic == null) continue;
                    NBTTagCompound heatTag = new NBTTagCompound();
                    heatTag.func_74774_a("side", (byte)face.ordinal());
                    heatTag.func_74768_a("temp", (int)logic.getTemperature());
                    tagList.func_74742_a((NBTBase)heatTag);
                }
                tag.func_74782_a("heat", (NBTBase)tagList);
            } else if (logic != null) {
                tag.func_74768_a("temp", (int)logic.getTemperature());
            }
        }
        return tag;
    }
}

