/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.thirteen.Context;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsdim.dimensions.ModDimensions;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketRegisterDimensions
implements IMessage {
    private int id;

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
    }

    public int getId() {
        return this.id;
    }

    public PacketRegisterDimensions() {
    }

    public PacketRegisterDimensions(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketRegisterDimensions(int id) {
        this.id = id;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            if (DimensionManager.isDimensionRegistered((int)this.id)) {
                Logging.log((String)("Client side, already registered dimension: " + this.id));
            } else {
                Logging.log((String)("Client side, register dimension: " + this.id));
                DimensionManager.registerDimension((int)this.id, (DimensionType)ModDimensions.rftoolsType);
            }
        });
        ctx.setPacketHandled(true);
    }
}

