/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.label.labels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.utils.Utilities;
import mezz.jei.api.gui.IRecipeLayout;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class LItemStack
extends ILabel.Impl {
    public static final String IDENTIFIER = "itemStack";
    public static final String KEY_ITEM = "item";
    public static final String KEY_META = "meta";
    public static final String KEY_NBT = "nbt";
    public static final String KEY_CAP = "cap";
    public static final String KEY_F_META = "fMeta";
    public static final String KEY_F_CAP = "fCap";
    public static final String KEY_F_NBT = "fNbt";
    Item item;
    int meta;
    NBTTagCompound nbt;
    NBTTagCompound cap;
    boolean fMeta;
    boolean fNbt;
    boolean fCap;
    transient ItemStack temp;

    public LItemStack(ItemStack is) {
        super(is.func_190916_E(), false);
        this.init(is.func_77973_b(), is.func_77960_j(), LItemStack.getCap(is), is.func_77978_p(), false, false, false);
    }

    public LItemStack(NBTTagCompound tag) {
        super(tag);
        String id = tag.func_74779_i(KEY_ITEM);
        Item i = Item.func_111206_d((String)id);
        if (i == null) {
            throw new ILabel.Serializer.SerializationException("Item " + id + " cannot be resolved, ignoring");
        }
        this.init(i, tag.func_74762_e(KEY_META), tag.func_74764_b(KEY_CAP) ? tag.func_74775_l(KEY_CAP) : null, tag.func_74764_b(KEY_NBT) ? tag.func_74775_l(KEY_NBT) : null, tag.func_74767_n(KEY_F_META), tag.func_74767_n(KEY_F_CAP), tag.func_74767_n(KEY_F_NBT));
    }

    private LItemStack(LItemStack lis) {
        super(lis);
        this.item = lis.item;
        this.meta = lis.meta;
        this.nbt = lis.nbt;
        this.cap = lis.cap;
        this.fMeta = lis.fMeta;
        this.fNbt = lis.fNbt;
        this.fCap = lis.fCap;
        this.temp = lis.temp;
    }

    private void init(@Nullable Item item, int meta, @Nullable NBTTagCompound cap, @Nullable NBTTagCompound nbt, boolean fMeta, boolean fCap, boolean fNbt) {
        Objects.requireNonNull(item);
        this.item = item;
        this.meta = fMeta ? 0 : meta;
        this.cap = fCap ? null : cap;
        this.nbt = fNbt ? null : nbt;
        this.fMeta = fMeta;
        this.fCap = fCap;
        this.fNbt = fNbt;
        this.temp = new ItemStack(item, 1, this.meta, this.cap);
        this.temp.func_77982_d(this.nbt);
    }

    @Nullable
    private static NBTTagCompound getCap(ItemStack is) {
        NBTTagCompound nbt = is.serializeNBT();
        return nbt.func_74764_b("ForgeCaps") ? nbt.func_74775_l("ForgeCaps") : null;
    }

    public static boolean merge(ILabel a, ILabel b) {
        if (a instanceof LItemStack && b instanceof LItemStack) {
            LItemStack lisA = (LItemStack)a;
            LItemStack lisB = (LItemStack)b;
            if (lisA.meta != lisB.meta && !lisA.fMeta && lisA.meta != Short.MAX_VALUE && !lisB.fMeta && lisB.meta != Short.MAX_VALUE) {
                return false;
            }
            if (!lisA.fNbt && !lisB.fNbt && (lisA.nbt == null ? lisB.nbt != null : lisB.nbt == null || !lisA.nbt.equals((Object)lisB.nbt))) {
                return false;
            }
            if (!lisA.fCap && !lisB.fCap && (lisA.cap == null ? lisB.cap != null : lisB.cap == null || !lisA.cap.equals((Object)lisB.cap))) {
                return false;
            }
            return lisA.item == lisB.item;
        }
        return false;
    }

    public static List<ILabel> suggest(List<ILabel> iss, @Nullable IRecipeLayout rl) {
        if (iss.size() == 0) {
            return new ArrayList<ILabel>();
        }
        for (ILabel i : iss) {
            if (i instanceof LItemStack) continue;
            return new ArrayList<ILabel>();
        }
        LItemStack lis = (LItemStack)iss.get(0);
        boolean fMeta = false;
        boolean fNbt = false;
        boolean fCap = false;
        for (ILabel i : iss) {
            LItemStack ii = (LItemStack)i;
            if (ii.item != lis.item) {
                return new ArrayList<ILabel>();
            }
            if (ii.meta != lis.meta || ii.fMeta) {
                fMeta = true;
            }
            if (ii.nbt == null ? lis.nbt != null : !ii.nbt.equals((Object)lis.nbt)) {
                fNbt = true;
            }
            if (!(ii.cap == null ? lis.cap != null : !ii.cap.equals((Object)lis.cap))) continue;
            fCap = true;
        }
        if (fMeta || fNbt || fCap) {
            return Collections.singletonList(lis.copy().setFCap(fCap).setFMeta(fMeta).setFNbt(fNbt));
        }
        return new ArrayList<ILabel>();
    }

    public static List<ILabel> fallback(List<ILabel> iss, @Nullable IRecipeLayout rl) {
        ArrayList<ILabel> ret = new ArrayList<ILabel>();
        if (iss.size() == 1) {
            ILabel label = iss.get(0);
            if (!(label instanceof LItemStack)) {
                return ret;
            }
            LItemStack lis = (LItemStack)label;
            if (lis.fCap || lis.fNbt || lis.fMeta) {
                return new ArrayList<ILabel>();
            }
            ret.add(lis.copy().setFMeta(true));
            ret.add(lis.copy().setFNbt(true));
            ret.add(lis.copy().setFCap(true));
            ret.add(lis.copy().setFMeta(true).setFNbt(true).setFCap(true));
        }
        return ret;
    }

    public LItemStack setFMeta(boolean f) {
        this.fMeta = f;
        if (f) {
            this.meta = 0;
        }
        this.temp = new ItemStack(this.item, 1, this.meta, this.cap);
        this.temp.func_77982_d(this.nbt);
        return this;
    }

    public LItemStack setFNbt(boolean f) {
        this.fNbt = f;
        if (f) {
            this.nbt = null;
        }
        this.temp = new ItemStack(this.item, 1, this.meta, this.cap);
        this.temp.func_77982_d(this.nbt);
        return this;
    }

    public LItemStack setFCap(boolean f) {
        this.fCap = f;
        if (f) {
            this.cap = null;
        }
        this.temp = new ItemStack(this.item, 1, this.meta, this.cap);
        this.temp.func_77982_d(this.nbt);
        return this;
    }

    public ItemStack getRep() {
        return this.temp;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getToolTip(List<String> existing, boolean detailed) {
        super.getToolTip(existing, detailed);
        if (this.fMeta) {
            existing.add("\u00a78" + Utilities.I18n.get("label.item_stack.fuzzy_meta", new Object[0]));
        }
        if (this.fNbt) {
            existing.add("\u00a78" + Utilities.I18n.get("label.item_stack.fuzzy_nbt", new Object[0]));
        }
        if (this.fCap) {
            existing.add("\u00a78" + Utilities.I18n.get("label.item_stack.fuzzy_cap", new Object[0]));
        }
        existing.add("\u00a79\u00a7o" + Utilities.getModName(this.item));
    }

    public ItemStack getRepresentation() {
        return this.temp;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getDisplayName() {
        return this.temp.func_82833_r();
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public boolean matches(Object l) {
        if (l instanceof LItemStack) {
            LItemStack lis = (LItemStack)l;
            return (this.nbt == null ? lis.nbt == null : this.nbt.equals((Object)lis.nbt)) && (this.cap == null ? lis.cap == null : this.cap.equals((Object)lis.cap)) && this.meta == lis.meta && this.item == lis.item && this.fNbt == lis.fNbt && super.matches(l) && this.fCap == lis.fCap && this.fMeta == lis.fMeta;
        }
        return false;
    }

    @Override
    public LItemStack copy() {
        return new LItemStack(this);
    }

    @Override
    public NBTTagCompound toNbt() {
        ResourceLocation rl = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)this.item);
        if (rl == null) {
            return ILabel.EMPTY.toNbt();
        }
        NBTTagCompound ret = super.toNbt();
        if (this.meta != 0) {
            ret.func_74768_a(KEY_META, this.meta);
        }
        ret.func_74778_a(KEY_ITEM, rl.toString());
        if (this.nbt != null) {
            ret.func_74782_a(KEY_NBT, (NBTBase)this.nbt);
        }
        if (this.cap != null) {
            ret.func_74782_a(KEY_CAP, (NBTBase)this.cap);
        }
        if (this.fMeta) {
            ret.func_74757_a(KEY_F_META, true);
        }
        if (this.fNbt) {
            ret.func_74757_a(KEY_F_NBT, true);
        }
        if (this.fCap) {
            ret.func_74757_a(KEY_F_CAP, true);
        }
        return ret;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawLabel(JecaGui gui) {
        gui.drawItemStack(0, 0, this.temp, false);
        if (this.fCap || this.fNbt || this.fMeta) {
            gui.drawResource(Resource.LBL_FRAME, 0, 0);
        }
        if (this.fCap) {
            gui.drawResource(Resource.LBL_FR_LL, 0, 0);
        }
        if (this.fNbt) {
            gui.drawResource(Resource.LBL_FR_UL, 0, 0);
        }
        if (this.fMeta) {
            gui.drawResource(Resource.LBL_FR_UR, 0, 0);
        }
    }

    @Override
    public int hashCode() {
        return (this.nbt == null ? 0 : this.nbt.hashCode()) ^ (this.cap == null ? 0 : this.cap.hashCode()) ^ this.meta ^ this.item.func_77658_a().hashCode() ^ super.hashCode();
    }
}

