/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemCardAppEng
extends ItemCardBase {
    public ItemCardAppEng() {
        super(22, "card_app_eng");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        NBTTagCompound tag = CrossModLoader.getCrossMod("appliedenergistics2").getCardData(world, target);
        if (tag == null) {
            return CardState.NO_TARGET;
        }
        reader.reset();
        reader.copyFrom(tag);
        return CardState.OK;
    }

    @Override
    public List<PanelString> getStringData(int settings, ICardReader reader, boolean isServer, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        switch (reader.getInt("type")) {
            case 1: {
                result.add(new PanelString("msg.ec.InfoPanelTotalNodes", reader.getInt("nodes").intValue(), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelStorageCells", reader.getInt("cells").intValue(), showLabels));
                if (isServer) {
                    result.add(new PanelString(String.format("%d of %d Bytes Used", reader.getInt("bytesUsed"), reader.getInt("bytesTotal"))));
                    result.add(new PanelString(String.format("%d of %d Types", reader.getInt("typesUsed"), reader.getInt("typesTotal"))));
                } else {
                    result.add(new PanelString(I18n.func_135052_a((String)"msg.ec.InfoPanelBytesUsed", (Object[])new Object[]{reader.getInt("bytesUsed"), reader.getInt("bytesTotal")})));
                    result.add(new PanelString(I18n.func_135052_a((String)"msg.ec.InfoPanelTypes", (Object[])new Object[]{reader.getInt("typesUsed"), reader.getInt("typesTotal")})));
                }
                result.add(new PanelString("msg.ec.InfoPanelTotalItems", reader.getInt("items").intValue(), showLabels));
                break;
            }
            case 2: {
                result.add(new PanelString("msg.ec.InfoPanelName", reader.getString("name"), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelSize", reader.getInt("size").intValue(), showLabels));
            }
        }
        return result;
    }

    @Override
    public List<PanelSetting> getSettingsList() {
        return null;
    }
}

