/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.disk;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskSync;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskSyncData;
import com.raoulvdberge.refinedstorage.network.MessageStorageDiskSizeRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class StorageDiskSync
implements IStorageDiskSync {
    private static final int THROTTLE_MS = 500;
    private Map<UUID, IStorageDiskSyncData> data = new HashMap<UUID, IStorageDiskSyncData>();
    private Map<UUID, Long> syncTime = new HashMap<UUID, Long>();

    @Override
    @Nullable
    public IStorageDiskSyncData getData(UUID id) {
        return this.data.get(id);
    }

    public void setData(UUID id, IStorageDiskSyncData data) {
        this.data.put(id, data);
    }

    @Override
    public void sendRequest(UUID id) {
        long lastSync = this.syncTime.getOrDefault(id, 0L);
        if (System.currentTimeMillis() - lastSync > 500L) {
            RS.INSTANCE.network.sendToServer((IMessage)new MessageStorageDiskSizeRequest(id));
            this.syncTime.put(id, System.currentTimeMillis());
        }
    }
}

