/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.StorageDiskSync;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.StorageDiskSyncData;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageStorageDiskSizeResponse
implements IMessage,
IMessageHandler<MessageStorageDiskSizeResponse, IMessage> {
    private UUID id;
    private int stored;
    private int capacity;

    public MessageStorageDiskSizeResponse() {
    }

    public MessageStorageDiskSizeResponse(UUID id, int stored, int capacity) {
        this.id = id;
        this.stored = stored;
        this.capacity = capacity;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.stored = buf.readInt();
        this.capacity = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.id.toString());
        buf.writeInt(this.stored);
        buf.writeInt(this.capacity);
    }

    public IMessage onMessage(MessageStorageDiskSizeResponse message, MessageContext ctx) {
        ((StorageDiskSync)API.instance().getStorageDiskSync()).setData(message.id, new StorageDiskSyncData(message.stored, message.capacity));
        return null;
    }
}

