/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.core;

import gregtech.api.capability.IEnergyContainer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Optional;
import sonar.fluxnetworks.api.tiles.IFluxConnector;
import sonar.fluxnetworks.api.tiles.IFluxPoint;

@Optional.InterfaceList(value={@Optional.Interface(iface="gregtech.api.capability.IEnergyContainer", modid="gregtech")})
public class GTEnergyWrapper
implements IEnergyContainer {
    private final IFluxConnector tile;

    public GTEnergyWrapper(IFluxConnector tile) {
        this.tile = tile;
    }

    public long acceptEnergyFromNetwork(EnumFacing side, long vol, long amp) {
        if (side != null && this.tile.getConnectionType().isPlug() && this.tile.isActive()) {
            long actualAmp = this.tile.getTransferHandler().receiveFromSupplier(vol * amp << 2, side, true) / vol >> 2;
            this.tile.getTransferHandler().receiveFromSupplier(vol * actualAmp << 2, side, false);
            return actualAmp;
        }
        return 0L;
    }

    public boolean inputsEnergy(EnumFacing side) {
        return this.tile.getConnectionType().isPlug();
    }

    public boolean outputsEnergy(EnumFacing side) {
        return this.tile.getConnectionType().isPoint();
    }

    public long changeEnergy(long l) {
        return 0L;
    }

    public long getEnergyStored() {
        return this.tile instanceof IFluxPoint ? Long.MAX_VALUE : 0L;
    }

    public long getEnergyCapacity() {
        return Long.MAX_VALUE;
    }

    public long getInputAmperage() {
        return Integer.MAX_VALUE;
    }

    public long getInputVoltage() {
        return Integer.MAX_VALUE;
    }

    public boolean isOneProbeHidden() {
        return true;
    }
}

