/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.supermartijn642.core.ClientUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.client.config.GuiUtils;

public class ScreenUtils {
    private static final ResourceLocation BUTTON_BACKGROUND = new ResourceLocation("supermartijn642corelib", "textures/gui/buttons.png");
    private static final ResourceLocation SCREEN_BACKGROUND = new ResourceLocation("supermartijn642corelib", "textures/gui/background.png");
    public static final int DEFAULT_TEXT_COLOR = 0x404040;
    public static final int ACTIVE_TEXT_COLOR = 0xE0E0E0;
    public static final int INACTIVE_TEXT_COLOR = 0x707070;

    public static void drawString(FontRenderer fontRenderer, ITextComponent text, float x, float y, int color) {
        ScreenUtils.drawString(fontRenderer, text.func_150254_d(), x, y, color);
    }

    public static void drawString(FontRenderer fontRenderer, ITextComponent text, float x, float y) {
        ScreenUtils.drawString(fontRenderer, text.func_150254_d(), x, y);
    }

    public static void drawString(ITextComponent text, float x, float y, int color) {
        ScreenUtils.drawString(text.func_150254_d(), x, y, color);
    }

    public static void drawString(ITextComponent text, float x, float y) {
        ScreenUtils.drawString(text.func_150254_d(), x, y);
    }

    public static void drawStringWithShadow(FontRenderer fontRenderer, ITextComponent text, float x, float y, int color) {
        ScreenUtils.drawStringWithShadow(fontRenderer, text.func_150254_d(), x, y, color);
    }

    public static void drawStringWithShadow(FontRenderer fontRenderer, ITextComponent text, float x, float y) {
        ScreenUtils.drawStringWithShadow(fontRenderer, text.func_150254_d(), x, y);
    }

    public static void drawStringWithShadow(ITextComponent text, float x, float y, int color) {
        ScreenUtils.drawStringWithShadow(text.func_150254_d(), x, y, color);
    }

    public static void drawStringWithShadow(ITextComponent text, float x, float y) {
        ScreenUtils.drawStringWithShadow(text.func_150254_d(), x, y);
    }

    public static void drawCenteredString(FontRenderer fontRenderer, ITextComponent text, float x, float y, int color) {
        ScreenUtils.drawCenteredString(fontRenderer, text.func_150254_d(), x, y, color);
    }

    public static void drawCenteredString(FontRenderer fontRenderer, ITextComponent text, float x, float y) {
        ScreenUtils.drawCenteredString(fontRenderer, text.func_150254_d(), x, y);
    }

    public static void drawCenteredString(ITextComponent text, float x, float y, int color) {
        ScreenUtils.drawCenteredString(text.func_150254_d(), x, y, color);
    }

    public static void drawCenteredString(ITextComponent text, float x, float y) {
        ScreenUtils.drawCenteredString(text.func_150254_d(), x, y);
    }

    public static void drawCenteredStringWithShadow(FontRenderer fontRenderer, ITextComponent text, float x, float y, int color) {
        ScreenUtils.drawCenteredStringWithShadow(fontRenderer, text.func_150254_d(), x, y, color);
    }

    public static void drawCenteredStringWithShadow(FontRenderer fontRenderer, ITextComponent text, float x, float y) {
        ScreenUtils.drawCenteredStringWithShadow(fontRenderer, text.func_150254_d(), x, y);
    }

    public static void drawCenteredStringWithShadow(ITextComponent text, float x, float y, int color) {
        ScreenUtils.drawCenteredStringWithShadow(text.func_150254_d(), x, y, color);
    }

    public static void drawCenteredStringWithShadow(ITextComponent text, float x, float y) {
        ScreenUtils.drawCenteredStringWithShadow(text.func_150254_d(), x, y);
    }

    public static void drawString(FontRenderer fontRenderer, String text, float x, float y, int color) {
        fontRenderer.func_78276_b(text, (int)x, (int)y, color);
    }

    public static void drawString(FontRenderer fontRenderer, String text, float x, float y) {
        ScreenUtils.drawString(fontRenderer, text, x, y, 0x404040);
    }

    public static void drawString(String text, float x, float y, int color) {
        ScreenUtils.drawString(ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawString(String text, float x, float y) {
        ScreenUtils.drawString(ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawStringWithShadow(FontRenderer fontRenderer, String text, float x, float y, int color) {
        fontRenderer.func_175063_a(text, x, y, color);
    }

    public static void drawStringWithShadow(FontRenderer fontRenderer, String text, float x, float y) {
        ScreenUtils.drawStringWithShadow(fontRenderer, text, x, y, 0x404040);
    }

    public static void drawStringWithShadow(String text, float x, float y, int color) {
        ScreenUtils.drawStringWithShadow(ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawStringWithShadow(String text, float x, float y) {
        ScreenUtils.drawStringWithShadow(ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawCenteredString(FontRenderer fontRenderer, String text, float x, float y, int color) {
        ScreenUtils.drawString(text, x - (float)fontRenderer.func_78256_a(text) / 2.0f, y, color);
    }

    public static void drawCenteredString(FontRenderer fontRenderer, String text, float x, float y) {
        ScreenUtils.drawString(text, x - (float)fontRenderer.func_78256_a(text) / 2.0f, y, 0x404040);
    }

    public static void drawCenteredString(String text, float x, float y, int color) {
        ScreenUtils.drawCenteredString(ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawCenteredString(String text, float x, float y) {
        ScreenUtils.drawCenteredString(ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawCenteredStringWithShadow(FontRenderer fontRenderer, String text, float x, float y, int color) {
        ScreenUtils.drawStringWithShadow(text, x - (float)fontRenderer.func_78256_a(text) / 2.0f, y, color);
    }

    public static void drawCenteredStringWithShadow(FontRenderer fontRenderer, String text, float x, float y) {
        ScreenUtils.drawStringWithShadow(text, x - (float)fontRenderer.func_78256_a(text) / 2.0f, y, 0x404040);
    }

    public static void drawCenteredStringWithShadow(String text, float x, float y, int color) {
        ScreenUtils.drawCenteredStringWithShadow(ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawCenteredStringWithShadow(String text, float x, float y) {
        ScreenUtils.drawCenteredStringWithShadow(ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawScreenBackground(float x, float y, float width, float height) {
        ScreenUtils.bindTexture(SCREEN_BACKGROUND);
        ScreenUtils.drawTexture(x, y, 4.0f, 4.0f, 0.0f, 0.0f, 0.44444445f, 0.44444445f);
        ScreenUtils.drawTexture(x + width - 4.0f, y, 4.0f, 4.0f, 0.5555556f, 0.0f, 0.44444445f, 0.44444445f);
        ScreenUtils.drawTexture(x + width - 4.0f, y + height - 4.0f, 4.0f, 4.0f, 0.5555556f, 0.5555556f, 0.44444445f, 0.44444445f);
        ScreenUtils.drawTexture(x, y + height - 4.0f, 4.0f, 4.0f, 0.0f, 0.5555556f, 0.44444445f, 0.44444445f);
        ScreenUtils.drawTexture(x + 4.0f, y, width - 8.0f, 4.0f, 0.44444445f, 0.0f, 0.11111111f, 0.44444445f);
        ScreenUtils.drawTexture(x + 4.0f, y + height - 4.0f, width - 8.0f, 4.0f, 0.44444445f, 0.5555556f, 0.11111111f, 0.44444445f);
        ScreenUtils.drawTexture(x, y + 4.0f, 4.0f, height - 8.0f, 0.0f, 0.44444445f, 0.44444445f, 0.11111111f);
        ScreenUtils.drawTexture(x + width - 4.0f, y + 4.0f, 4.0f, height - 8.0f, 0.5555556f, 0.44444445f, 0.44444445f, 0.11111111f);
        ScreenUtils.drawTexture(x + 4.0f, y + 4.0f, width - 8.0f, height - 8.0f, 0.44444445f, 0.44444445f, 0.11111111f, 0.11111111f);
    }

    public static void drawButtonBackground(float x, float y, float width, float height, float yOffset) {
        ScreenUtils.bindTexture(BUTTON_BACKGROUND);
        ScreenUtils.drawTexture(x, y, 2.0f, 2.0f, 0.0f, yOffset, 0.4f, 0.13333334f);
        ScreenUtils.drawTexture(x + width - 2.0f, y, 2.0f, 2.0f, 0.6f, yOffset, 0.4f, 0.13333334f);
        ScreenUtils.drawTexture(x + width - 2.0f, y + height - 2.0f, 2.0f, 2.0f, 0.6f, yOffset + 0.2f, 0.4f, 0.13333334f);
        ScreenUtils.drawTexture(x, y + height - 2.0f, 2.0f, 2.0f, 0.0f, yOffset + 0.2f, 0.4f, 0.13333334f);
        ScreenUtils.drawTexture(x + 2.0f, y, width - 4.0f, 2.0f, 0.4f, yOffset, 0.2f, 0.13333334f);
        ScreenUtils.drawTexture(x + 2.0f, y + height - 2.0f, width - 4.0f, 2.0f, 0.4f, yOffset + 0.2f, 0.2f, 0.13333334f);
        ScreenUtils.drawTexture(x, y + 2.0f, 2.0f, height - 4.0f, 0.0f, yOffset + 0.13333334f, 0.4f, 0.06666667f);
        ScreenUtils.drawTexture(x + width - 2.0f, y + 2.0f, 2.0f, height - 4.0f, 0.6f, yOffset + 0.13333334f, 0.4f, 0.06666667f);
        ScreenUtils.drawTexture(x + 2.0f, y + 2.0f, width - 4.0f, height - 4.0f, 0.4f, yOffset + 0.13333334f, 0.2f, 0.06666667f);
    }

    public static void drawTexture(float x, float y, float width, float height) {
        ScreenUtils.drawTexture(x, y, width, height, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public static void drawTexture(float x, float y, float width, float height, float tx, float ty, float twidth, float theight) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)tx, (double)(ty + theight)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)(tx + twidth), (double)(ty + theight)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)(tx + twidth), (double)ty).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)tx, (double)ty).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void fillRect(float x, float y, float width, float height, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        ScreenUtils.fillRect(x, y, width, height, red, green, blue, alpha);
    }

    public static void fillRect(float x, float y, float width, float height, float red, float green, float blue, float alpha) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)x, (double)(y + height), 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void bindTexture(ResourceLocation location) {
        ClientUtils.getTextureManager().func_110577_a(location);
    }

    public static void drawTooltip(FontRenderer fontRenderer, List<ITextComponent> text, int x, int y) {
        ScreenUtils.drawTooltipInternal(fontRenderer, text.stream().map(ITextComponent::func_150254_d).collect(Collectors.toList()), x, y);
    }

    public static void drawTooltip(FontRenderer fontRenderer, ITextComponent text, int x, int y) {
        ScreenUtils.drawTooltip(fontRenderer, Collections.singletonList(text), x, y);
    }

    public static void drawTooltip(FontRenderer fontRenderer, String text, int x, int y) {
        ScreenUtils.drawTooltip(fontRenderer, (ITextComponent)new TextComponentString(text), x, y);
    }

    public static void drawTooltip(List<ITextComponent> text, int x, int y) {
        ScreenUtils.drawTooltip(ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawTooltip(ITextComponent text, int x, int y) {
        ScreenUtils.drawTooltip(ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawTooltip(String text, int x, int y) {
        ScreenUtils.drawTooltip(ClientUtils.getFontRenderer(), text, x, y);
    }

    private static void drawTooltipInternal(FontRenderer fontRenderer, List<String> components, int x, int y) {
        if (components.isEmpty()) {
            return;
        }
        int displayWidth = ClientUtils.getMinecraft().field_71443_c;
        int displayHeight = ClientUtils.getMinecraft().field_71440_d;
        int scaleFactor = 1;
        boolean isUnicode = ClientUtils.getMinecraft().func_152349_b();
        int guiScale = ClientUtils.getMinecraft().field_71474_y.field_74335_Z;
        if (guiScale == 0) {
            guiScale = 1000;
        }
        while (scaleFactor < guiScale && displayWidth / (scaleFactor + 1) >= 320 && displayHeight / (scaleFactor + 1) >= 240) {
            ++scaleFactor;
        }
        if (isUnicode && scaleFactor % 2 != 0 && scaleFactor != 1) {
            --scaleFactor;
        }
        int screenWidth = MathHelper.func_76143_f((double)((double)displayWidth / (double)scaleFactor));
        int screenHeight = MathHelper.func_76143_f((double)((double)displayHeight / (double)scaleFactor));
        GuiUtils.drawHoveringText(components, (int)x, (int)y, (int)screenWidth, (int)screenHeight, (int)-1, (FontRenderer)fontRenderer);
    }
}

