/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.mixin;

import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryEntryAcceptor;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ForgeHooks.class})
public class ForgeHooksMixin {
    @Inject(method={"canHarvestBlock"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void canHarvestBlock(Block block, EntityPlayer player, IBlockAccess world, BlockPos pos, CallbackInfoReturnable<Boolean> ci) {
        if (block instanceof BaseBlock && !((BaseBlock)block).requiresCorrectToolForDrops()) {
            ci.setReturnValue(ForgeEventFactory.doPlayerHarvestCheck((EntityPlayer)player, (IBlockState)world.func_180495_p(pos), (boolean)true));
        }
    }

    @Redirect(method={"canHarvestBlock"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/Item;getHarvestLevel(Lnet/minecraft/item/ItemStack;Ljava/lang/String;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/block/state/IBlockState;)I"), remap=false)
    private static int canHarvestBlockRedirect(Item item, ItemStack stack, String type, EntityPlayer player, IBlockState state) {
        if (state.func_177230_c() instanceof BaseBlock) {
            int bestHarvestLevel = -1;
            for (String toolType : item.getToolClasses(stack)) {
                int harvestLevel;
                if (!state.func_177230_c().isToolEffective(toolType, state) || (harvestLevel = item.getHarvestLevel(stack, toolType, player, state)) <= bestHarvestLevel) continue;
                bestHarvestLevel = harvestLevel;
            }
            if (bestHarvestLevel == -1) {
                bestHarvestLevel = item.getHarvestLevel(stack, type, player, state);
            }
            return bestHarvestLevel;
        }
        return item.getHarvestLevel(stack, type, player, state);
    }

    @Inject(method={"canToolHarvestBlock"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void canToolHarvestBlock(IBlockAccess world, BlockPos pos, ItemStack stack, CallbackInfoReturnable<Boolean> ci) {
        if (stack.func_190926_b()) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BaseBlock) {
            int harvestLevel = state.func_177230_c().getHarvestLevel(state);
            for (String toolType : stack.func_77973_b().getToolClasses(stack)) {
                if (!state.func_177230_c().isToolEffective(toolType, state) || stack.func_77973_b().getHarvestLevel(stack, toolType, null, state) < harvestLevel) continue;
                ci.setReturnValue(true);
                return;
            }
            ci.setReturnValue(false);
        }
    }

    @Inject(method={"loadAdvancements"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/common/crafting/CraftingHelper;init()V", shift=At.Shift.AFTER)}, remap=false)
    private static void loadAdvancements(Map<ResourceLocation, Advancement.Builder> map, CallbackInfoReturnable<Boolean> ci) {
        RegistrationHandler.handleResourceConditionSerializerRegistryEvent();
        RegistryEntryAcceptor.Handler.onRegisterEvent(Registries.RECIPE_CONDITION_SERIALIZERS);
    }
}

