/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import mekanism.api.TileNetworkList;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.gauge.GuiNumberGauge;
import mekanism.client.gui.element.tab.GuiAmplifierTab;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerLaserAmplifier;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityLaserAmplifier;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiLaserAmplifier
extends GuiMekanismTile<TileEntityLaserAmplifier> {
    private GuiTextField minField;
    private GuiTextField maxField;
    private GuiTextField timerField;

    public GuiLaserAmplifier(InventoryPlayer inventory, TileEntityLaserAmplifier tile) {
        super(tile, new ContainerLaserAmplifier(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiNumberGauge(new GuiNumberGauge.INumberInfoHandler(){

            @Override
            public TextureAtlasSprite getIcon() {
                return MekanismRenderer.energyIcon;
            }

            @Override
            public double getLevel() {
                return ((TileEntityLaserAmplifier)GuiLaserAmplifier.this.tileEntity).collectedEnergy;
            }

            @Override
            public double getMaxLevel() {
                return 5.0E9;
            }

            @Override
            public String getText(double level) {
                return LangUtils.localize("gui.storing") + ": " + MekanismUtils.getEnergyDisplay(level, ((TileEntityLaserAmplifier)GuiLaserAmplifier.this.tileEntity).getMaxEnergy());
            }
        }, GuiGauge.Type.STANDARD, this, resource, 6, 10));
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiAmplifierTab(this, (TileEntityLaserAmplifier)this.tileEntity, resource));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityLaserAmplifier)this.tileEntity).func_70005_c_(), 55, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        this.field_146289_q.func_78276_b(((TileEntityLaserAmplifier)this.tileEntity).time > 0 ? LangUtils.localize("gui.delay") + ": " + ((TileEntityLaserAmplifier)this.tileEntity).time + "t" : LangUtils.localize("gui.noDelay"), 26, 30, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.min") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityLaserAmplifier)this.tileEntity).minThreshold), 26, 45, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.max") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityLaserAmplifier)this.tileEntity).maxThreshold), 26, 60, 0x404040);
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        this.minField.func_146194_f();
        this.maxField.func_146194_f();
        this.timerField.func_146194_f();
        MekanismRenderer.resetColor();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.minField.func_146178_a();
        this.maxField.func_146178_a();
        this.timerField.func_146178_a();
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        this.minField.func_146192_a(mouseX, mouseY, button);
        this.maxField.func_146192_a(mouseX, mouseY, button);
        this.timerField.func_146192_a(mouseX, mouseY, button);
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiBlank.png");
    }

    public void func_73869_a(char c, int i) throws IOException {
        if (!this.minField.func_146206_l() && !this.maxField.func_146206_l() && !this.timerField.func_146206_l() || i == 1) {
            super.func_73869_a(c, i);
        }
        if (i == 28) {
            if (this.minField.func_146206_l()) {
                this.setMinThreshold();
            }
            if (this.maxField.func_146206_l()) {
                this.setMaxThreshold();
            }
            if (this.timerField.func_146206_l()) {
                this.setTime();
            }
        }
        if (Character.isDigit(c) || c == '.' || c == 'E' || GuiLaserAmplifier.isTextboxKey(c, i)) {
            this.minField.func_146201_a(c, i);
            this.maxField.func_146201_a(c, i);
            if (c != '.' && c != 'E') {
                this.timerField.func_146201_a(c, i);
            }
        }
    }

    private void setMinThreshold() {
        if (!this.minField.func_146179_b().isEmpty()) {
            double toUse;
            try {
                toUse = Math.max(0.0, Double.parseDouble(this.minField.func_146179_b()));
            }
            catch (Exception e) {
                this.minField.func_146180_a("");
                return;
            }
            TileNetworkList data = TileNetworkList.withContents(0, toUse);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, data));
            this.minField.func_146180_a("");
        }
    }

    private void setMaxThreshold() {
        if (!this.maxField.func_146179_b().isEmpty()) {
            double toUse;
            try {
                toUse = Math.max(0.0, Double.parseDouble(this.maxField.func_146179_b()));
            }
            catch (Exception e) {
                this.maxField.func_146180_a("");
                return;
            }
            TileNetworkList data = TileNetworkList.withContents(1, toUse);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, data));
            this.maxField.func_146180_a("");
        }
    }

    private void setTime() {
        if (!this.timerField.func_146179_b().isEmpty()) {
            int toUse = Math.max(0, Integer.parseInt(this.timerField.func_146179_b()));
            TileNetworkList data = TileNetworkList.withContents(2, toUse);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, data));
            this.timerField.func_146180_a("");
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        String prevTime = this.timerField != null ? this.timerField.func_146179_b() : "";
        this.timerField = new GuiTextField(0, this.field_146289_q, this.field_147003_i + 96, this.field_147009_r + 28, 36, 11);
        this.timerField.func_146203_f(4);
        this.timerField.func_146180_a(prevTime);
        String prevMin = this.minField != null ? this.minField.func_146179_b() : "";
        this.minField = new GuiTextField(1, this.field_146289_q, this.field_147003_i + 96, this.field_147009_r + 43, 72, 11);
        this.minField.func_146203_f(10);
        this.minField.func_146180_a(prevMin);
        String prevMax = this.maxField != null ? this.maxField.func_146179_b() : "";
        this.maxField = new GuiTextField(2, this.field_146289_q, this.field_147003_i + 96, this.field_147009_r + 58, 72, 11);
        this.maxField.func_146203_f(10);
        this.maxField.func_146180_a(prevMax);
    }
}

