/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.ai.tasks;

import CoroUtil.ai.IInvasionControlledTask;
import CoroUtil.ai.ITaskInitializer;
import CoroUtil.block.BlockRepairingBlock;
import CoroUtil.config.ConfigCoroUtilAdvanced;
import CoroUtil.forge.CULog;
import CoroUtil.util.CoroUtilBlock;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class EntityAIHoist
extends EntityAIBase
implements ITaskInitializer,
IInvasionControlledTask {
    protected EntityCreature entity;
    double speedTowardsTarget = 1.0;
    public int tryHoist = 0;
    public boolean stackMode = false;
    public int noMoveTicks = 0;
    private Vec3d posLastTracked = null;
    private boolean disableAtSunrise = true;

    public EntityAIHoist() {
        this.func_75248_a(0);
    }

    public boolean func_75250_a() {
        return true;
    }

    public boolean func_75253_b() {
        return true;
    }

    public void func_75249_e() {
    }

    public void func_75251_c() {
    }

    public void func_75246_d() {
        EntityLivingBase target = this.entity.func_70638_az();
        this.entity.field_70144_Y = this.entity.field_70122_E ? 0.4f : 1.0f;
        this.entity.field_70143_R = 0.0f;
        if (this.posLastTracked == null) {
            this.posLastTracked = this.entity.func_174791_d();
        } else if (this.posLastTracked.func_72438_d(this.entity.func_174791_d()) < 2.0) {
            ++this.noMoveTicks;
        } else {
            this.posLastTracked = this.entity.func_174791_d();
            this.noMoveTicks = 0;
        }
        double factor = -1.0;
        if (!this.entity.field_70170_p.field_72995_K && target != null) {
            double xDiff = target.field_70165_t - this.entity.field_70165_t;
            double zDiff = target.field_70161_v - this.entity.field_70161_v;
            double distHoriz = MathHelper.func_76133_a((double)(xDiff * xDiff + zDiff * zDiff));
            if (distHoriz < 0.0) {
                distHoriz = 1.0;
            }
            double distVert = target.field_70163_u - this.entity.field_70163_u;
            factor = distVert / distHoriz;
        }
        if (!this.stackMode) {
            if (target != null && this.entity.func_70661_as().func_75500_f() && !this.entity.func_70090_H() && (this.noMoveTicks > 60 || factor != -1.0 && factor > 5.0)) {
                this.stackMode = true;
                this.noMoveTicks = 0;
            }
        } else if (target == null) {
            this.stackMode = false;
        }
        double rangeBox = 1.5;
        double lungeSpeed = 0.4;
        double rangeShiftBase = 0.4;
        double rangeShiftAdjToStack = 0.3;
        double rangeShiftAdjToTarget = 0.1;
        double rangeShiftAdjFromTarget = 0.3;
        double rangeNeededToShiftToTarget = 1.4;
        if (!this.entity.field_70170_p.field_72995_K && this.stackMode) {
            List var2 = this.entity.field_70170_p.func_72872_a(EntityLivingBase.class, this.entity.func_174813_aQ().func_72321_a(rangeBox, 2.0, rangeBox));
            Random rand = new Random();
            Entity ent = null;
            if (var2.size() > 1) {
                for (int i = 0; i < var2.size(); ++i) {
                    if (var2.get(i) == this.entity || !(var2.get(i) instanceof EntityZombie) || this.entity.func_145782_y() <= ((EntityLivingBase)var2.get(i)).func_145782_y() || !(this.entity.func_174813_aQ().field_72338_b + 1.5 > ((EntityLivingBase)var2.get((int)i)).func_174813_aQ().field_72338_b) || !(this.entity.func_174813_aQ().field_72338_b < ((EntityLivingBase)var2.get((int)i)).func_174813_aQ().field_72337_e)) continue;
                    ent = (Entity)var2.get(i);
                    break;
                }
            }
            if (this.tryHoist > 0) {
                if (target.func_70032_d((Entity)this.entity) < 3.0f || this.tryHoist == 1 && target.func_174813_aQ().field_72338_b < this.entity.func_174813_aQ().field_72338_b - 1.0) {
                    double vecX = target.field_70165_t - this.entity.field_70165_t;
                    double vecY = target.field_70163_u - this.entity.field_70163_u;
                    double vecZ = target.field_70161_v - this.entity.field_70161_v;
                    double var9 = MathHelper.func_76133_a((double)(vecX * vecX + vecZ * vecZ));
                    double shiftSpeed = lungeSpeed;
                    this.entity.field_70159_w = vecX / var9 * shiftSpeed;
                    this.entity.field_70181_x = 0.5;
                    this.entity.field_70179_y = vecZ / var9 * shiftSpeed;
                    this.tryHoist = 0;
                    this.stackMode = false;
                }
                --this.tryHoist;
            }
            if (ent != null) {
                if (target.func_174813_aQ().field_72338_b > this.entity.func_174813_aQ().field_72338_b + 2.0) {
                    this.tryHoist = 40;
                } else if (target.func_174813_aQ().field_72338_b < this.entity.func_174813_aQ().field_72338_b - 1.0 || !this.isNearWall(this.entity.func_174813_aQ())) {
                    // empty if block
                }
                if (this.tryHoist > 0) {
                    double tryZ;
                    double tryY;
                    double tryX;
                    BlockPos pos;
                    IBlockState state;
                    if (!(this.entity.field_70170_p.field_72995_K || CoroUtilBlock.isAir((state = this.entity.field_70170_p.func_180495_p(pos = new BlockPos(tryX = this.entity.field_70165_t - 0.8 + (double)rand.nextFloat(), tryY = this.entity.field_70163_u + 0.5 + (double)rand.nextFloat() * 2.0, tryZ = this.entity.field_70161_v - 0.8 + (double)rand.nextFloat()))).func_177230_c()) || state.func_185904_a() != Material.field_151584_j && state.func_185904_a() != Material.field_151585_k || state.func_177230_c() instanceof BlockRepairingBlock)) {
                        this.entity.field_70170_p.func_175698_g(pos);
                    }
                    double shiftSpeed = rangeShiftBase;
                    double vecX = ent.field_70165_t - this.entity.field_70165_t;
                    double vecY = ent.field_70163_u - this.entity.field_70163_u;
                    double vecZ = ent.field_70161_v - this.entity.field_70161_v;
                    double dist = MathHelper.func_76133_a((double)(vecX * vecX + vecZ * vecZ));
                    if (dist > 0.1) {
                        this.entity.field_70159_w = vecX / dist * shiftSpeed * rangeShiftAdjToStack;
                        this.entity.field_70179_y = vecZ / dist * shiftSpeed * rangeShiftAdjToStack;
                    }
                    vecX = target.field_70165_t - this.entity.field_70165_t;
                    vecY = target.field_70163_u - this.entity.field_70163_u;
                    vecZ = target.field_70161_v - this.entity.field_70161_v;
                    double var9 = MathHelper.func_76133_a((double)(vecX * vecX + vecZ * vecZ));
                    if (dist + shiftSpeed < rangeNeededToShiftToTarget) {
                        BlockPos pos1 = new BlockPos(this.entity.field_70165_t + 0.0 + vecX / var9 * 1.5, this.entity.field_70163_u, this.entity.field_70161_v + 0.0 + vecZ / var9 * 1.5);
                        BlockPos pos2 = new BlockPos(this.entity.field_70165_t + 0.5, 0.0, this.entity.field_70161_v + 0.5);
                        int height = this.entity.field_70170_p.func_175645_m(pos1).func_177956_o();
                        int height2 = this.entity.field_70170_p.func_175645_m(pos2).func_177956_o();
                        if ((double)height <= this.entity.field_70163_u || (double)height2 > target.field_70163_u + 1.0) {
                            this.entity.field_70159_w = vecX / var9 * shiftSpeed * rangeShiftAdjToTarget;
                            this.entity.field_70179_y = vecZ / var9 * shiftSpeed * rangeShiftAdjToTarget;
                        } else {
                            this.entity.field_70159_w = -vecX / var9 * shiftSpeed * rangeShiftAdjFromTarget;
                            this.entity.field_70179_y = -vecZ / var9 * shiftSpeed * rangeShiftAdjFromTarget;
                        }
                    }
                    float wat = 0.15f;
                    if (this.entity.field_70181_x < -0.0) {
                        this.entity.field_70181_x = -0.0;
                    }
                    this.entity.field_70181_x += (double)wat;
                    if (this.entity.field_70181_x > (double)0.15f) {
                        this.entity.field_70181_x = 0.15f;
                    }
                    if (ent.field_70122_E) {
                        // empty if block
                    }
                }
            }
        }
        if (this.entity.field_70170_p.field_72995_K || this.entity.func_70617_f_()) {
            // empty if block
        }
    }

    protected double getAttackReachSqr(EntityLivingBase attackTarget) {
        return this.entity.field_70130_N * 2.0f * this.entity.field_70130_N * 2.0f + attackTarget.field_70130_N;
    }

    @Override
    public void setEntity(EntityCreature creature) {
        this.entity = creature;
    }

    @Override
    public boolean shouldBeRemoved() {
        if (this.disableAtSunrise && ConfigCoroUtilAdvanced.removeInvasionAIWhenInvasionDone && this.entity.field_70170_p.func_72935_r()) {
            CULog.dbg("removing hoisting from " + this.entity.func_70005_c_());
            return true;
        }
        return false;
    }

    public boolean isNearWall(AxisAlignedBB par1AxisAlignedBB) {
        int var3 = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72340_a);
        int var4 = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72336_d + 1.0));
        int var5 = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72338_b);
        int var6 = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72337_e + 1.0));
        int var7 = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72339_c);
        int var8 = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72334_f + 1.0));
        for (int var9 = var3 - 1; var9 < var4 + 1; ++var9) {
            for (int var10 = var5; var10 < var6 + 1; ++var10) {
                for (int var11 = var7 - 1; var11 < var8 + 1; ++var11) {
                    Block var12 = this.entity.field_70170_p.func_180495_p(new BlockPos(var9, var10, var11)).func_177230_c();
                    if (CoroUtilBlock.isAir(var12)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

