/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.shader;

import CoroUtil.util.CoroUtilFile;
import extendedrenderer.shader.ShaderProgram;
import extendedrenderer.shader.ShaderProgramFoliage;
import extendedrenderer.shader.ShaderProgramParticle;
import extendedrenderer.shader.Transformation;
import java.util.HashMap;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class Renderer {
    private HashMap<String, ShaderProgram> lookupNameToProgram = new HashMap();
    public Transformation transformation = new Transformation();

    public void init() throws Exception {
        ShaderProgram shaderProgram = new ShaderProgramParticle("particle");
        String vertex = CoroUtilFile.getContentsFromResourceLocation(new ResourceLocation("coroutil", "shaders/particle.vs"));
        String fragment = CoroUtilFile.getContentsFromResourceLocation(new ResourceLocation("coroutil", "shaders/particle.fs"));
        shaderProgram.createVertexShader(vertex);
        shaderProgram.createFragmentShader(fragment);
        shaderProgram.link();
        shaderProgram.createUniform("modelViewMatrixCamera");
        shaderProgram.createUniform("texture_sampler");
        shaderProgram.createUniform("fogmode");
        this.lookupNameToProgram.put(shaderProgram.getName(), shaderProgram);
        shaderProgram = new ShaderProgramFoliage("foliage");
        vertex = CoroUtilFile.getContentsFromResourceLocation(new ResourceLocation("coroutil", "shaders/foliage.vs"));
        fragment = CoroUtilFile.getContentsFromResourceLocation(new ResourceLocation("coroutil", "shaders/foliage.fs"));
        shaderProgram.createVertexShader(vertex);
        shaderProgram.createFragmentShader(fragment);
        shaderProgram.link();
        shaderProgram.createUniform("modelViewMatrixCamera");
        shaderProgram.createUniform("texture_sampler");
        shaderProgram.createUniform("time");
        shaderProgram.createUniform("partialTick");
        shaderProgram.createUniform("windDir");
        shaderProgram.createUniform("windSpeed");
        shaderProgram.createUniform("fogmode");
        this.lookupNameToProgram.put(shaderProgram.getName(), shaderProgram);
    }

    public void clear() {
        GL11.glClear((int)16640);
    }

    public void cleanup() {
        for (ShaderProgram shaderProgram : this.lookupNameToProgram.values()) {
            shaderProgram.cleanup();
        }
        this.lookupNameToProgram.clear();
    }

    public ShaderProgram getShaderProgram(String name) {
        return this.lookupNameToProgram.get(name);
    }
}

