/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.multiblock;

import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import icbm.classic.api.tile.multiblock.IMultiTile;
import icbm.classic.api.tile.multiblock.IMultiTileHost;
import icbm.classic.config.ConfigIC2;
import icbm.classic.mods.ic2.IC2Proxy;
import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2"), @Optional.Interface(iface="ic2.api.tile.IEnergyStorage", modid="ic2")})
public class TileMulti
extends TileEntity
implements IMultiTile,
IEnergySink {
    private WeakReference<IMultiTileHost> hostWeakReference;
    private BlockPos hostPosition = null;

    @Override
    public IMultiTileHost getHost() {
        if (this.isHostLoaded()) {
            TileEntity tile;
            if (this.hostWeakReference != null && this.hostWeakReference.get() != null) {
                return (IMultiTileHost)this.hostWeakReference.get();
            }
            if (this.hostPosition != null && this.field_145850_b.func_175667_e(this.hostPosition) && (tile = this.field_145850_b.func_175625_s(this.hostPosition)) instanceof IMultiTileHost) {
                this.setHost((IMultiTileHost)tile);
                return (IMultiTileHost)tile;
            }
        }
        return null;
    }

    public boolean hasHost() {
        return this.hostPosition != null;
    }

    public boolean isHostLoaded() {
        return this.hostPosition != null && this.field_145850_b.func_175667_e(this.hostPosition);
    }

    @Override
    public boolean isHost(IMultiTileHost host) {
        return host == this.getHost() || this.hostPosition != null && this.hostPosition.equals((Object)host.getPos());
    }

    @Override
    public void setHost(IMultiTileHost host) {
        if (host != null) {
            this.hostWeakReference = new WeakReference<IMultiTileHost>(host);
            this.hostPosition = new BlockPos(host.xi(), host.yi(), host.zi());
        } else {
            if (this.hostWeakReference != null) {
                this.hostWeakReference.clear();
                this.hostWeakReference = null;
            }
            this.hostPosition = null;
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("hostPos")) {
            int[] data = compound.func_74759_k("hostPos");
            this.hostPosition = new BlockPos(data[0], data[1], data[2]);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.hostPosition != null) {
            compound.func_74783_a("hostPos", new int[]{this.hostPosition.func_177958_n(), this.hostPosition.func_177956_o(), this.hostPosition.func_177952_p()});
        }
        return super.func_189515_b(compound);
    }

    public void func_145843_s() {
        if (this.getHost() != null) {
            this.getHost().onTileInvalidate(this);
        }
        super.func_145843_s();
        IC2Proxy.INSTANCE.onTileInvalidate(this);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.getHost() instanceof TileEntity) {
            return ((TileEntity)this.getHost()).hasCapability(capability, facing);
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.getHost() instanceof TileEntity) {
            return (T)((TileEntity)this.getHost()).getCapability(capability, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[ DIM@" + (this.field_145850_b != null && this.field_145850_b.field_73011_w != null ? this.field_145850_b.field_73011_w.getDimension() + " " : "null ") + this.func_174877_v().func_177958_n() + "x " + this.func_174877_v().func_177956_o() + "y " + this.func_174877_v().func_177952_p() + "z ]@" + this.hashCode();
    }

    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        IEnergyStorage energyStorage;
        if (!ConfigIC2.DISABLED && this.hasCapability(CapabilityEnergy.ENERGY, null) && (energyStorage = (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            int need = energyStorage.getMaxEnergyStored() - energyStorage.getEnergyStored();
            return (double)need / ConfigIC2.FROM_IC2;
        }
        return 0.0;
    }

    @Optional.Method(modid="ic2")
    public int getSinkTier() {
        return !ConfigIC2.DISABLED ? 4 : 0;
    }

    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        IEnergyStorage energyStorage;
        if (!ConfigIC2.DISABLED && this.hasCapability(CapabilityEnergy.ENERGY, null) && (energyStorage = (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            int energy = (int)Math.floor(amount * ConfigIC2.FROM_IC2);
            int received = energyStorage.receiveEnergy(energy, false);
            return amount - (double)received / ConfigIC2.FROM_IC2;
        }
        return amount;
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return !ConfigIC2.DISABLED && this.hasCapability(CapabilityEnergy.ENERGY, side);
    }

    public void func_145829_t() {
        super.func_145829_t();
        IC2Proxy.INSTANCE.onTileValidate(this);
    }
}

