/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.entity.missile;

import com.builtbroken.jlib.data.vector.IPos3D;
import icbm.classic.ICBMClassic;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.caps.IEMPReceiver;
import icbm.classic.api.caps.IMissile;
import icbm.classic.api.events.MissileEvent;
import icbm.classic.api.events.MissileRideEvent;
import icbm.classic.api.explosion.BlastState;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.client.ICBMSounds;
import icbm.classic.config.ConfigDebug;
import icbm.classic.config.ConfigMissile;
import icbm.classic.content.entity.missile.CapabilityEmpMissile;
import icbm.classic.content.entity.missile.CapabilityMissile;
import icbm.classic.content.entity.missile.MissileFlightType;
import icbm.classic.content.entity.missile.MissileTrackerHandler;
import icbm.classic.lib.capability.emp.CapabilityEMP;
import icbm.classic.lib.explosive.ExplosiveHandler;
import icbm.classic.lib.radar.RadarRegistry;
import icbm.classic.lib.transform.vector.Pos;
import icbm.classic.prefab.entity.EntityProjectile;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMissile
extends EntityProjectile
implements IEntityAdditionalSpawnData {
    public static final float MISSILE_SPEED = 2.0f;
    public int explosiveID = -1;
    public int maxHeight = 200;
    public Pos targetPos = null;
    public Pos launcherPos = null;
    public boolean isExploding = false;
    public boolean destroyNextTick = false;
    public boolean destroyWithFullExplosion = false;
    public boolean explodeNextTick = false;
    public int targetHeight = -1;
    public double deltaPathX;
    public double deltaPathY;
    public double deltaPathZ;
    public double flatDistance;
    public float missileFlightTime;
    public float acceleration;
    public int protectionTime = 2;
    public Entity lockedTarget;
    public boolean didTargetLockBefore = false;
    public int trackingVar = -1;
    public MissileFlightType missileType = MissileFlightType.PAD_LAUNCHER;
    public Pos motionVector = new Pos();
    public double lockHeight = 3.0;
    public boolean wasSimulated = false;
    private final HashSet<Entity> ignoreEntity = new HashSet();
    public NBTTagCompound blastData = new NBTTagCompound();
    public IEMPReceiver capabilityEMP;
    public final IMissile capabilityMissile = new CapabilityMissile(this);
    private final int maxPreLaunchSmokeTimer = 20;
    public int preLaunchSmokeTimer = this.getMaxPreLaunchSmokeTimer();
    public int launcherHasAirBelow = -1;
    private LinkedList<Pos> lastSmokePos = new LinkedList();

    public EntityMissile(World w) {
        super(w);
        this.func_70105_a(0.5f, 0.5f);
        this.inAirKillTime = 144000;
        this.field_70178_ae = true;
        this.field_70158_ak = true;
    }

    public EntityMissile(World w, double x, double y, double z, float yaw, float pitch, float speed) {
        super(w, x, y, z, yaw, pitch, speed, 1.0f);
        this.func_70105_a(0.5f, 0.5f);
        this.inAirKillTime = 144000;
        this.field_70178_ae = true;
        this.field_70158_ak = true;
    }

    public EntityMissile(EntityLivingBase entity) {
        super(entity.field_70170_p, entity, 2.0f);
        this.func_70105_a(0.5f, 0.5f);
        this.launcherPos = new Pos((Entity)entity);
        this.inAirKillTime = 144000;
        this.field_70178_ae = true;
        this.field_70158_ak = true;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEMP.EMP) {
            if (this.capabilityEMP == null) {
                this.capabilityEMP = new CapabilityEmpMissile(this);
            }
            return (T)this.capabilityEMP;
        }
        if (capability == ICBMClassicAPI.MISSILE_CAPABILITY) {
            return (T)this.capabilityMissile;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEMP.EMP || super.hasCapability(capability, facing);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_72321_a(5.0, 5.0, 5.0);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityMissile.func_184183_bd()) * d0;
    }

    public String getEntityName() {
        IExplosiveData data = ICBMClassicAPI.EXPLOSIVE_REGISTRY.getExplosiveData(this.explosiveID);
        if (data != null) {
            return "icbm.missile." + data.getRegistryName();
        }
        return "icbm.missile";
    }

    public void writeSpawnData(ByteBuf additionalMissileData) {
        additionalMissileData.writeInt(this.explosiveID);
        additionalMissileData.writeInt(this.missileType.ordinal());
    }

    public void readSpawnData(ByteBuf additionalMissileData) {
        this.explosiveID = additionalMissileData.readInt();
        this.missileType = MissileFlightType.values()[additionalMissileData.readInt()];
    }

    @Override
    public void func_70071_h_() {
        if (this.preLaunchSmokeTimer > 0) {
            this.field_70127_C = 90.0f;
        }
        super.func_70071_h_();
        if (this.targetPos != null && this.targetHeight >= 0) {
            int deltaX = this.targetPos.xi() - (int)Math.floor(this.field_70165_t);
            int deltaY = this.targetPos.yi() - (int)Math.floor(this.field_70163_u);
            int deltaZ = this.targetPos.zi() - (int)Math.floor(this.field_70161_v);
            if (this.inRange(1, deltaY) && this.inRange(1, deltaX) && this.inRange(1, deltaZ)) {
                this.doExplosion();
            }
        }
    }

    private boolean inRange(int range, int value) {
        return value <= range && value >= -range;
    }

    protected void launch(Pos target) {
        if (this.ticksInAir <= 0) {
            this.ticksInAir = 2;
        }
        this.sourceOfProjectile = new Pos((IPos3D)this);
        this.targetPos = target;
        this.targetHeight = this.targetPos != null ? this.targetPos.yi() : -1;
        ICBMClassicAPI.EX_MISSILE_REGISTRY.triggerLaunch(this.capabilityMissile);
        this.recalculatePath();
        this.updateMotion();
        ICBMSounds.MISSILE_LAUNCH.play(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f, true);
        RadarRegistry.add(this);
        if (ConfigDebug.DEBUG_MISSILE_LAUNCHES) {
            if (target != null) {
                ICBMClassic.logger().info("Launching " + this.getEntityName() + " (" + this.func_145782_y() + ") from " + this.sourceOfProjectile.xi() + ", " + this.sourceOfProjectile.yi() + ", " + this.sourceOfProjectile.zi() + " to " + this.targetPos.xi() + ", " + this.targetPos.yi() + ", " + this.targetPos.zi());
            } else {
                ICBMClassic.logger().info("Launching " + this.getEntityName() + " (" + this.func_145782_y() + ") from " + this.sourceOfProjectile.xi() + ", " + this.sourceOfProjectile.yi() + ", " + this.sourceOfProjectile.zi());
            }
        }
    }

    protected void launch(Pos target, int height) {
        if (height > 0) {
            this.lockHeight = height;
        }
        this.launch(target);
    }

    public EntityMissile ignore(Entity entity) {
        this.ignoreEntity.add(entity);
        return this;
    }

    public void recalculatePath() {
        if (this.targetPos != null) {
            this.deltaPathX = this.targetPos.x() - this.sourceOfProjectile.x();
            this.deltaPathY = this.targetPos.y() - this.sourceOfProjectile.y();
            this.deltaPathZ = this.targetPos.z() - this.sourceOfProjectile.z();
            if (this.missileType == MissileFlightType.PAD_LAUNCHER) {
                this.flatDistance = this.sourceOfProjectile.toVector2().distance(this.targetPos.toVector2());
                this.maxHeight = 160 + (int)(this.flatDistance * 3.0);
                this.missileFlightTime = (float)Math.max(100.0, 2.0 * this.flatDistance) - (float)this.ticksInAir;
                if (!this.wasSimulated) {
                    this.acceleration = (float)this.maxHeight * 2.0f / (this.missileFlightTime * this.missileFlightTime);
                }
            } else if (this.missileType.movesDirectly) {
                this.func_70186_c(this.deltaPathX, this.deltaPathY, this.deltaPathZ, 2.0f, 0.0f);
            }
        }
    }

    @Override
    public void func_70088_a() {
    }

    public boolean func_70067_L() {
        return true;
    }

    @Override
    protected void updateMotion() {
        if (this.wasSimulated) {
            this.preLaunchSmokeTimer = 0;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.preLaunchSmokeTimer <= 0 || this.missileType != MissileFlightType.PAD_LAUNCHER) {
                if (this.ticksInAir <= 0) {
                    this.ticksInAir = 2;
                }
                if (this.ticksInAir >= 0 && this.missileType == MissileFlightType.PAD_LAUNCHER) {
                    if (this.lockHeight > 0.0) {
                        this.field_70181_x = ConfigMissile.LAUNCH_SPEED * (float)this.ticksInAir * ((float)this.ticksInAir / 2.0f);
                        this.field_70159_w = 0.0;
                        this.field_70179_y = 0.0;
                        this.lockHeight -= this.field_70181_x;
                        if (this.lockHeight <= 0.0) {
                            this.field_70181_x = this.acceleration * (this.missileFlightTime / 2.0f);
                            this.field_70159_w = this.deltaPathX / (double)this.missileFlightTime;
                            this.field_70179_y = this.deltaPathZ / (double)this.missileFlightTime;
                        }
                    } else {
                        this.field_70181_x -= (double)this.acceleration;
                        this.field_70125_A = (float)(Math.atan(this.field_70181_x / Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 180.0 / Math.PI);
                        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
                    }
                    if (this.shouldSimulate()) {
                        MissileTrackerHandler.simulateMissile(this);
                    }
                }
                --this.protectionTime;
            } else {
                this.field_70181_x = 0.001f;
                this.lockHeight -= this.field_70181_x;
                this.field_70163_u = this.launcherPos.y() + (double)2.2f;
                this.field_70127_C = 90.0f;
                this.field_70125_A = 90.0f;
                ICBMClassic.proxy.spawnMissileSmoke(this);
                this.ticksInAir = 0;
            }
        }
        if (this.preLaunchSmokeTimer > 0) {
            --this.preLaunchSmokeTimer;
        }
        ICBMClassic.proxy.spawnMissileSmoke(this);
        ICBMSounds.MISSILE_ENGINE.play(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, Math.min(1.0f, (float)this.ticksInAir / 40.0f) * 1.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f, true);
        ICBMClassicAPI.EX_MISSILE_REGISTRY.triggerFlightUpdate(this.capabilityMissile);
        super.updateMotion();
    }

    protected boolean shouldSimulate() {
        if (this.launcherPos != null) {
            if (this.func_184188_bt().stream().anyMatch(entity -> entity instanceof EntityPlayerMP)) {
                return false;
            }
            if (this.wasSimulated) {
                return false;
            }
            if (this.field_70163_u >= (double)ConfigMissile.SIMULATION_START_HEIGHT) {
                return true;
            }
            BlockPos pos = this.getPredictedPosition(1).toBlockPos();
            if (!this.field_70170_p.func_175667_e(pos)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void decreaseMotion() {
        if (this.missileType != MissileFlightType.PAD_LAUNCHER && this.ticksInAir > 1000) {
            super.decreaseMotion();
        }
    }

    @Override
    protected void onImpactTile() {
        this.doExplosion();
    }

    @Override
    protected boolean ignoreImpact(RayTraceResult hit) {
        return MinecraftForge.EVENT_BUS.post((Event)new MissileEvent.PreImpact(this.capabilityMissile, this, hit));
    }

    @Override
    protected void postImpact(RayTraceResult hit) {
        MinecraftForge.EVENT_BUS.post((Event)new MissileEvent.PostImpact(this.capabilityMissile, this, hit));
    }

    @Override
    protected void onImpactEntity(Entity entityHit, float velocity) {
        if (!this.field_70170_p.field_72995_K && entityHit.func_184187_bx() != this) {
            super.onImpactEntity(entityHit, velocity);
            this.doExplosion();
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (ICBMClassicAPI.EX_MISSILE_REGISTRY.onInteraction(this, player, hand)) {
            return true;
        }
        if (!(this.field_70170_p.field_72995_K || this.func_184187_bx() != null && this.func_184187_bx() != player || MinecraftForge.EVENT_BUS.post((Event)new MissileRideEvent.Start(this, player)))) {
            player.func_184220_m((Entity)this);
            return true;
        }
        return false;
    }

    public double func_70042_X() {
        if (this.missileFlightTime <= 0.0f && this.missileType == MissileFlightType.PAD_LAUNCHER) {
            return this.field_70131_O;
        }
        if (this.missileType == MissileFlightType.CRUISE_LAUNCHER) {
            return this.field_70131_O / 10.0f;
        }
        return (double)(this.field_70131_O / 2.0f) + this.field_70181_x;
    }

    public LinkedList<Pos> getLastSmokePos() {
        return this.lastSmokePos;
    }

    public int getMaxPreLaunchSmokeTimer() {
        return 20;
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        if (this.ignoreEntity.contains(entity)) {
            return null;
        }
        return this.func_174813_aQ();
    }

    @Override
    public Pos getPredictedPosition(int t) {
        Pos position = new Pos((IPos3D)this);
        double tempMotionY = this.field_70181_x;
        if (this.ticksInAir > 20) {
            for (int i = 0; i < t; ++i) {
                position = this.missileType.movesDirectly ? (Pos)position.add(this.motionVector) : (Pos)position.add(this.field_70159_w, tempMotionY - (double)this.acceleration, this.field_70179_y);
            }
        }
        return position;
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K) {
            RadarRegistry.remove(this);
        }
        super.func_70106_y();
    }

    public BlastState doExplosion() {
        this.func_184210_p();
        this.func_184226_ay();
        try {
            if (!this.isExploding) {
                ICBMClassic.logger().info(this.getEntityName() + " (" + this.func_145782_y() + ") exploded in " + (int)this.field_70165_t + ", " + (int)this.field_70163_u + ", " + (int)this.field_70161_v);
                this.isExploding = true;
                this.func_70106_y();
                if (!this.field_70170_p.field_72995_K) {
                    return ExplosiveHandler.createExplosion(this, this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.explosiveID, 1.0f, this.blastData);
                }
                return BlastState.TRIGGERED;
            }
            return BlastState.ALREADY_TRIGGERED;
        }
        catch (Exception e) {
            ICBMClassic.logger().error("EntityMissile#normalExplode() - Unexpected error while triggering explosive on missile", (Throwable)e);
            return BlastState.ERROR;
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.targetPos = new Pos(nbt.func_74775_l("target"));
        this.launcherPos = new Pos(nbt.func_74775_l("launcherPos"));
        this.acceleration = nbt.func_74760_g("acceleration");
        this.targetHeight = nbt.func_74762_e("targetHeight");
        this.explosiveID = nbt.func_74762_e("explosiveID");
        this.ticksInAir = nbt.func_74762_e("ticksInAir");
        this.lockHeight = nbt.func_74769_h("lockHeight");
        this.missileType = MissileFlightType.get(nbt.func_74762_e("missileType"));
        this.preLaunchSmokeTimer = nbt.func_74762_e("preLaunchSmokeTimer");
        this.blastData = nbt.func_74775_l("additionalMissileData");
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.targetPos != null) {
            nbt.func_74782_a("target", (NBTBase)this.targetPos.toNBT());
        }
        if (this.launcherPos != null) {
            nbt.func_74782_a("launcherPos", (NBTBase)this.launcherPos.toNBT());
        }
        nbt.func_74776_a("acceleration", this.acceleration);
        nbt.func_74768_a("explosiveID", this.explosiveID);
        nbt.func_74768_a("targetHeight", this.targetHeight);
        nbt.func_74768_a("ticksInAir", this.ticksInAir);
        nbt.func_74780_a("lockHeight", this.lockHeight);
        nbt.func_74768_a("missileType", this.missileType.ordinal());
        nbt.func_74768_a("preLaunchSmokeTimer", this.preLaunchSmokeTimer);
        nbt.func_74782_a("additionalMissileData", (NBTBase)this.blastData);
    }
}

