/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.radio;

import com.google.common.collect.Lists;
import icbm.classic.api.tile.IRadioWaveReceiver;
import icbm.classic.api.tile.IRadioWaveSender;
import icbm.classic.lib.radio.RadioRegistry;
import icbm.classic.lib.transform.region.Cube;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.math.ChunkPos;

public class RadioMap {
    protected final int dimID;
    protected HashMap<ChunkPos, List<IRadioWaveReceiver>> chunk_to_entities = new HashMap();
    protected HashMap<IRadioWaveReceiver, List<ChunkPos>> receive_to_chunks = new HashMap();
    protected HashMap<IRadioWaveReceiver, Cube> receive_to_range = new HashMap();
    protected HashMap<IRadioWaveSender, List<IRadioWaveReceiver>> sender_to_receivers_cache = new HashMap();
    protected List<IRadioWaveReceiver> fullMapRangeReceives = new ArrayList<IRadioWaveReceiver>();

    public RadioMap(int dimID) {
        this.dimID = dimID;
    }

    public boolean add(IRadioWaveReceiver receiver) {
        Cube range = receiver.getRadioReceiverRange();
        if (range != null) {
            if (range == RadioRegistry.INFINITE) {
                if (!this.fullMapRangeReceives.contains(receiver)) {
                    this.fullMapRangeReceives.add(receiver);
                }
                return true;
            }
            if (!this.receive_to_chunks.containsKey(receiver)) {
                this.updateChunkCache(receiver, range);
                this.updateSenderCache(receiver, range);
                return true;
            }
        }
        return false;
    }

    protected void updateChunkCache(IRadioWaveReceiver receiver, Cube range) {
        List<ChunkPos> list = range.getChunkCoords();
        for (ChunkPos pair : list) {
            List<IRadioWaveReceiver> receivers = this.chunk_to_entities.get(pair);
            if (receivers == null) {
                receivers = new ArrayList<IRadioWaveReceiver>();
            }
            if (!receivers.contains(receiver)) {
                receivers.add(receiver);
            }
            this.chunk_to_entities.put(pair, receivers);
        }
        this.receive_to_chunks.put(receiver, list);
    }

    protected void updateSenderCache(IRadioWaveReceiver receiver, Cube range) {
        if (range != null) {
            for (IRadioWaveSender sender : this.sender_to_receivers_cache.keySet()) {
                Cube senderRange = sender.getRadioSenderRange();
                if (!senderRange.doesOverlap(range)) continue;
                List<IRadioWaveReceiver> receivers = this.sender_to_receivers_cache.get(sender);
                if (receivers == null) {
                    receivers = new ArrayList<IRadioWaveReceiver>();
                }
                if (!receivers.contains(receiver)) {
                    receivers.add(receiver);
                }
                this.sender_to_receivers_cache.put(sender, receivers);
            }
        }
    }

    public void update(IRadioWaveReceiver receiver) {
        Cube range;
        if ((!this.receive_to_range.containsKey(receiver) || this.receive_to_range.get(receiver) == null || this.receive_to_range.get(receiver).equals(receiver.getRadioReceiverRange())) && (range = receiver.getRadioReceiverRange()) != null) {
            this.updateChunkCache(receiver, range);
            this.updateSenderCache(receiver, range);
        }
    }

    public boolean remove(IRadioWaveReceiver receiver) {
        if (this.fullMapRangeReceives.contains(receiver)) {
            this.fullMapRangeReceives.remove(receiver);
        }
        if (this.receive_to_chunks.containsKey(receiver)) {
            for (ChunkPos pair : this.receive_to_chunks.get(receiver)) {
                if (!this.chunk_to_entities.containsKey(pair)) continue;
                this.chunk_to_entities.get(pair).remove(receiver);
            }
            this.receive_to_chunks.remove(receiver);
            for (IRadioWaveSender sender : this.sender_to_receivers_cache.keySet()) {
                List<IRadioWaveReceiver> receivers = this.sender_to_receivers_cache.get(sender);
                if (receivers == null) {
                    receivers = new ArrayList<IRadioWaveReceiver>();
                }
                if (receivers.contains(receiver)) {
                    receivers.remove(receiver);
                }
                this.sender_to_receivers_cache.put(sender, receivers);
            }
            return true;
        }
        return false;
    }

    public void popMessage(IRadioWaveSender sender, float hz, String header, Object[] data) {
        block9: {
            if (this.sender_to_receivers_cache.containsKey(sender)) {
                for (IRadioWaveReceiver receiver : this.sender_to_receivers_cache.get(sender)) {
                    receiver.receiveRadioWave(hz, sender, header, data);
                }
                return;
            }
            for (int i = this.fullMapRangeReceives.size() - 1; i >= 0; --i) {
                this.fullMapRangeReceives.get(i).receiveRadioWave(hz, sender, header, data);
            }
            Cube range = sender.getRadioSenderRange();
            if (range == null) break block9;
            if (this.receive_to_chunks.size() < 200 || range.getSizeX() > 320.0 || range.getSizeY() > 320.0) {
                for (IRadioWaveReceiver receiver : this.receive_to_chunks.keySet()) {
                    Cube receiverRange;
                    if (receiver == null || receiver == sender || !range.doesOverlap(receiverRange = receiver.getRadioReceiverRange()) && !receiverRange.doesOverlap(range)) continue;
                    receiver.receiveRadioWave(hz, sender, header, data);
                }
            } else {
                List<ChunkPos> coords = range.getChunkCoords();
                ArrayList<IRadioWaveReceiver> receivers = new ArrayList<IRadioWaveReceiver>();
                for (ChunkPos pair : coords) {
                    List<IRadioWaveReceiver> l = this.chunk_to_entities.get(pair);
                    if (l == null || l.size() <= 0) continue;
                    for (IRadioWaveReceiver r : l) {
                        if (r == null || r == sender || receivers.contains(r)) continue;
                        receivers.add(r);
                    }
                }
                for (IRadioWaveReceiver receiver : receivers) {
                    receiver.receiveRadioWave(hz, sender, header, data);
                }
            }
        }
    }

    public void updateCache(IRadioWaveSender sender) {
        this.sender_to_receivers_cache.remove(sender);
        Cube range = sender.getRadioSenderRange();
        if (range != null) {
            this.sender_to_receivers_cache.put(sender, this.getReceiversInRange(range, sender instanceof IRadioWaveReceiver ? (IRadioWaveReceiver)((Object)sender) : (IRadioWaveReceiver)null));
        }
    }

    public List<IRadioWaveReceiver> getReceiversInRange(Cube range, IRadioWaveReceiver exclude) {
        return this.getReceiversInRange(range, exclude != null ? Lists.newArrayList((Object[])new IRadioWaveReceiver[]{exclude}) : null);
    }

    public List<IRadioWaveReceiver> getReceiversInRange(Cube range, List excludeList) {
        ArrayList<IRadioWaveReceiver> receivers = new ArrayList<IRadioWaveReceiver>();
        receivers.addAll(this.fullMapRangeReceives);
        if (range != null) {
            for (IRadioWaveReceiver receiver : this.receive_to_chunks.keySet()) {
                Cube receiverRange;
                if (receiver == null || excludeList != null && excludeList.contains(receiver) || (receiverRange = receiver.getRadioReceiverRange()) == null || !range.doesOverlap(receiverRange)) continue;
                receivers.add(receiver);
            }
        }
        return receivers;
    }

    protected final ChunkPos getChunkValue(int x, int z) {
        return new ChunkPos(x >> 4, z >> 4);
    }

    public void unloadAll() {
        this.chunk_to_entities.clear();
    }

    public int dimID() {
        return this.dimID;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof RadioMap) {
            return ((RadioMap)object).dimID == this.dimID;
        }
        return false;
    }

    public String toString() {
        return "RadioMap[" + this.dimID + "]";
    }
}

