/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.handler.PlaneNetworking;
import xyz.przemyk.simpleplanes.math.MathUtil;
import xyz.przemyk.simpleplanes.math.Quaternion;
import xyz.przemyk.simpleplanes.proxy.ClientProxy;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.storage.ChestUpgrade;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class PlanesClientEvents {
    private static boolean playerRotationNeedToPop = false;
    static boolean old_sprint = false;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderPre(RenderLivingEvent.Pre event) {
        Entity entity = event.getEntity().func_184208_bv();
        if (entity instanceof PlaneEntity) {
            boolean isPlayerRidingInFirstPersonView;
            PlaneEntity planeEntity = (PlaneEntity)entity;
            GlStateManager.func_179094_E();
            playerRotationNeedToPop = true;
            double firstPersonYOffset = 0.7;
            boolean bl = isPlayerRidingInFirstPersonView = Minecraft.func_71410_x().field_71439_g != null && planeEntity.func_184196_w((Entity)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0;
            if (isPlayerRidingInFirstPersonView) {
                GlStateManager.func_179137_b((double)0.0, (double)firstPersonYOffset, (double)0.0);
            }
            GlStateManager.func_179137_b((double)0.0, (double)0.7, (double)0.0);
            GlStateManager.func_179137_b((double)event.getX(), (double)event.getY(), (double)event.getZ());
            Quaternion quaternion = MathUtil.lerpQ(event.getPartialRenderTick(), planeEntity.getQ_Prev(), planeEntity.getQ_Client());
            quaternion.set(quaternion.getX(), -quaternion.getY(), -quaternion.getZ(), quaternion.getW());
            GlStateManager.func_187444_a((org.lwjgl.util.vector.Quaternion)quaternion.convert());
            float rotationYaw = MathUtil.lerpAngle(event.getPartialRenderTick(), entity.field_70126_B, entity.field_70177_z);
            GlStateManager.func_187444_a((org.lwjgl.util.vector.Quaternion)MathUtil.rotationDegreesY(rotationYaw).convert());
            GlStateManager.func_179137_b((double)(-event.getX()), (double)(-event.getY()), (double)(-event.getZ()));
            GlStateManager.func_179137_b((double)0.0, (double)-0.7, (double)0.0);
            if (isPlayerRidingInFirstPersonView) {
                GlStateManager.func_179137_b((double)0.0, (double)(-firstPersonYOffset), (double)0.0);
            }
            if (MathUtil.degreesDifferenceAbs(planeEntity.rotationRoll, 0.0) > 90.0) {
                event.getEntity().field_70759_as = planeEntity.field_70177_z * 2.0f - event.getEntity().field_70759_as;
            }
            if (MathUtil.degreesDifferenceAbs(planeEntity.prevRotationRoll, 0.0) > 90.0) {
                event.getEntity().field_70758_at = planeEntity.field_70126_B * 2.0f - event.getEntity().field_70758_at;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderPost(RenderLivingEvent.Post event) {
        if (playerRotationNeedToPop) {
            playerRotationNeedToPop = false;
            GlStateManager.func_179121_F();
            Entity entity = event.getEntity().func_184208_bv();
            PlaneEntity planeEntity = (PlaneEntity)entity;
            if (MathUtil.degreesDifferenceAbs(planeEntity.rotationRoll, 0.0) > 90.0) {
                event.getEntity().field_70759_as = planeEntity.field_70177_z * 2.0f - event.getEntity().field_70759_as;
            }
            if (MathUtil.degreesDifferenceAbs(planeEntity.prevRotationRoll, 0.0) > 90.0) {
                event.getEntity().field_70758_at = planeEntity.field_70126_B * 2.0f - event.getEntity().field_70758_at;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onClientPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (event.phase == TickEvent.Phase.END && player instanceof EntityPlayerSP) {
            if (player.func_184187_bx() instanceof PlaneEntity) {
                boolean isSprinting;
                PlaneEntity planeEntity = (PlaneEntity)player.func_184187_bx();
                if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                    float yawDiff = planeEntity.field_70177_z - planeEntity.field_70126_B;
                    player.field_70177_z += yawDiff;
                    float relativePlayerYaw = MathHelper.func_76142_g((float)(player.field_70177_z - planeEntity.field_70177_z));
                    float clampedRelativePlayerYaw = MathHelper.func_76131_a((float)relativePlayerYaw, (float)-105.0f, (float)105.0f);
                    float diff = clampedRelativePlayerYaw - relativePlayerYaw;
                    player.field_70126_B += diff;
                    player.field_70177_z += diff;
                    player.func_70034_d(player.field_70177_z);
                    relativePlayerYaw = MathHelper.func_76142_g((float)(player.field_70125_A - 0.0f));
                    clampedRelativePlayerYaw = MathHelper.func_76131_a((float)relativePlayerYaw, (float)-50.0f, (float)50.0f);
                    float perc = (clampedRelativePlayerYaw - relativePlayerYaw) * 0.5f;
                    player.field_70127_C += perc;
                    player.field_70125_A += perc;
                } else {
                    planeEntity.applyYawToEntity((Entity)player);
                }
                EntityPlayerSP clientEntityPlayer = (EntityPlayerSP)player;
                boolean bl = isSprinting = ClientProxy.keyBind.func_151470_d() || clientEntityPlayer.func_70051_ag() || Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151470_d();
                if (isSprinting != old_sprint || Math.random() < 0.1) {
                    PlaneNetworking.INSTANCE.sendToServer((IMessage)new PlaneNetworking.BoostMSG.MSG(isSprinting));
                }
                old_sprint = isSprinting;
            } else {
                old_sprint = false;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayerSP && entity.func_184187_bx() instanceof PlaneEntity) {
            PlaneEntity planeEntity = (PlaneEntity)entity.func_184187_bx();
            EntityPlayerSP playerEntity = (EntityPlayerSP)entity;
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                double partialTicks = event.getRenderPartialTicks();
                Quaternion q_prev = planeEntity.getQ_Prev();
                int max = 105;
                float diff = (float)MathHelper.func_151237_a((double)MathUtil.wrapSubtractDegrees(planeEntity.field_70126_B, playerEntity.field_70126_B), (double)(-max), (double)max);
                float pitch = MathHelper.func_76131_a((float)event.getPitch(), (float)-45.0f, (float)45.0f);
                Quaternion.mul(q_prev, MathUtil.rotationDegreesY(diff), q_prev);
                Quaternion.mul(q_prev, MathUtil.rotationDegreesX(pitch), q_prev);
                MathUtil.EulerAngles angles_prev = MathUtil.toEulerAngles(q_prev);
                Quaternion q_client = planeEntity.getQ_Client();
                diff = (float)MathHelper.func_151237_a((double)MathUtil.wrapSubtractDegrees(planeEntity.field_70177_z, playerEntity.field_70177_z), (double)(-max), (double)max);
                Quaternion.mul(q_client, MathUtil.rotationDegreesY(diff), q_client);
                Quaternion.mul(q_client, MathUtil.rotationDegreesX(pitch), q_client);
                MathUtil.EulerAngles angles = MathUtil.toEulerAngles(q_client);
                event.setPitch(-((float)MathUtil.lerpAngle180(partialTicks, angles_prev.pitch, angles.pitch)));
                event.setYaw((float)MathUtil.lerpAngle(partialTicks, angles_prev.yaw, angles.yaw) + 180.0f);
                event.setRoll(-((float)MathUtil.lerpAngle(partialTicks, angles_prev.roll, angles.roll)));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void planeInventory(GuiOpenEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (event.getGui() instanceof GuiInventory && player.func_184187_bx() instanceof PlaneEntity) {
            PlaneEntity plane = (PlaneEntity)player.func_184187_bx();
            Upgrade chest = plane.upgrades.getOrDefault(SimplePlanesUpgrades.CHEST.getId(), null);
            if (chest instanceof ChestUpgrade) {
                ChestUpgrade chest1 = (ChestUpgrade)chest;
                IInventory inventory = chest1.inventory;
                if (inventory != null) {
                    event.setCanceled(true);
                    PlaneNetworking.INSTANCE.sendToServer((IMessage)new PlaneNetworking.InventoryMSG.MSG());
                }
            }
        }
    }
}

