/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.entities;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import xyz.przemyk.simpleplanes.PlaneMaterial;
import xyz.przemyk.simpleplanes.entities.LargePlaneEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.math.MathUtil;
import xyz.przemyk.simpleplanes.math.Quaternion;
import xyz.przemyk.simpleplanes.math.Vector3f;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public class HelicopterEntity
extends LargePlaneEntity {
    public HelicopterEntity(World worldIn) {
        super(worldIn);
    }

    public HelicopterEntity(World worldIn, PlaneMaterial material) {
        super(worldIn, material);
    }

    public HelicopterEntity(World worldIn, PlaneMaterial material, double x, double y, double z) {
        super(worldIn, material, x, y, z);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
    }

    @Override
    protected PlaneEntity.Vars getMotionVars() {
        PlaneEntity.Vars motionVars = super.getMotionVars();
        motionVars.passive_engine_push = 0.028f;
        motionVars.push = 0.05f;
        motionVars.drag_quad *= 10.0;
        motionVars.drag_mul *= 2.0;
        return motionVars;
    }

    @Override
    protected void tickMotion(PlaneEntity.Vars vars) {
        super.tickMotion(vars);
    }

    @Override
    protected Vector3f getTickPush(PlaneEntity.Vars vars) {
        if (vars.moveForward < 0.0f && this.isPowered() && !vars.passengerSprinting) {
            vars.push = (float)((double)vars.push * 0.2);
        }
        return this.transformPos(new Vector3f(0.0f, vars.push, 0.0f));
    }

    @Override
    protected Item getItem() {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("simpleplanes", this.getMaterial().name + "_helicopter"));
    }

    @Override
    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.field_70170_p.field_72995_K && Minecraft.func_71410_x().field_71439_g == passenger) {
            Minecraft.func_71410_x().field_71456_v.func_175188_a((ITextComponent)new TextComponentString("sprint to take off"), false);
        }
    }

    @Override
    public double getCameraDistanceMultiplayer() {
        return super.getCameraDistanceMultiplayer();
    }

    @Override
    protected boolean isEasy() {
        return true;
    }

    @Override
    protected void tickPitch(PlaneEntity.Vars vars) {
        if (vars.moveForward > 0.0f) {
            this.field_70125_A = Math.max(this.field_70125_A - 1.0f, -20.0f);
        } else if (vars.moveForward < 0.0f && vars.passengerSprinting) {
            this.field_70125_A = Math.min(this.field_70125_A + 1.0f, 10.0f);
        } else {
            this.field_70125_A = MathUtil.lerpAngle(0.2f, this.field_70125_A, 0.0f);
            double drag = 0.999;
            this.setMotion(this.getMotion().func_186678_a(drag));
        }
    }

    @Override
    protected boolean tickOnGround(PlaneEntity.Vars vars) {
        float push = vars.push;
        super.tickOnGround(vars);
        vars.push = vars.passengerSprinting ? push : 0.0f;
        return false;
    }

    @Override
    protected float getGroundPitch() {
        return 0.0f;
    }

    @Override
    protected Quaternion tickRotateMotion(PlaneEntity.Vars vars, Quaternion q, Vec3d motion) {
        return q;
    }

    @Override
    protected void tickRotation(PlaneEntity.Vars vars) {
        int yawdiff = 2;
        double turn = vars.moveStrafing > 0.0f ? (double)yawdiff : (vars.moveStrafing == 0.0f ? 0.0 : (double)(-yawdiff));
        this.rotationRoll = 0.0f;
        this.field_70177_z = (float)((double)this.field_70177_z - turn);
    }

    @Override
    protected boolean func_184219_q(Entity passenger) {
        return super.func_184219_q(passenger) && passenger instanceof EntityPlayer;
    }

    @Override
    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
    }

    @Override
    public boolean canAddUpgrade(UpgradeType upgradeType) {
        if (upgradeType.occupyBackSeat) {
            if (this.func_184188_bt().size() > 1) {
                return false;
            }
            for (Upgrade upgrade : this.upgrades.values()) {
                if (!upgrade.getType().occupyBackSeat) continue;
                return false;
            }
        }
        return !this.upgrades.containsKey(upgradeType.getRegistryName()) && upgradeType.isPlaneApplicable(this);
    }

    @Override
    protected Vector3f getPassengerTwoPos(Entity passenger) {
        return new Vector3f(0.0f, (float)(super.func_70042_X() + passenger.func_70033_W()), -0.8f);
    }
}

