/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.banner;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.math.MathUtil;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.banner.BannerModel;

public class BannerUpgrade
extends Upgrade {
    public ItemStack banner = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("banner")));
    public float rotation;
    public float prevRotation;

    public BannerUpgrade(PlaneEntity planeEntity) {
        super(SimplePlanesUpgrades.BANNER, planeEntity);
        this.prevRotation = planeEntity.field_70126_B;
        this.rotation = planeEntity.field_70126_B;
    }

    @Override
    public boolean tick() {
        this.prevRotation = this.rotation;
        this.rotation = MathUtil.lerpAngle(0.05f, this.rotation, this.planeEntity.field_70126_B);
        return super.tick();
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compoundNBT = new NBTTagCompound();
        compoundNBT.func_74782_a("banner", (NBTBase)this.banner.serializeNBT());
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        NBTBase banner = nbt.func_74781_a("banner");
        if (banner instanceof NBTTagCompound) {
            this.banner = new ItemStack((NBTTagCompound)banner);
        }
    }

    @Override
    public NBTTagCompound serializeNBTData() {
        return this.serializeNBT();
    }

    @Override
    public void deserializeNBTData(NBTTagCompound nbt) {
        this.deserializeNBT(nbt);
    }

    @Override
    public void render(float partialticks, float scale) {
        BannerModel.renderBanner(this, partialticks, this.banner);
    }

    @Override
    public ItemStack getDrop() {
        return this.banner;
    }

    @Override
    public void onApply(ItemStack itemStack, EntityPlayer playerEntity) {
        if (itemStack.func_77973_b() instanceof ItemBanner) {
            this.banner = itemStack.func_77946_l();
            this.banner.func_190920_e(1);
            this.planeEntity.upgradeChanged();
        }
    }
}

