/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.energy;

import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public abstract class AbstractEngine
extends Upgrade {
    public AbstractEngine(UpgradeType upgradeType, PlaneEntity planeEntity) {
        super(upgradeType, planeEntity);
    }

    @Override
    public boolean isEngine() {
        return true;
    }

    @Override
    public void onApply(ItemStack itemStack, EntityPlayer playerEntity) {
        if (playerEntity.field_70170_p.field_72995_K) {
            return;
        }
        for (Map.Entry<ResourceLocation, Upgrade> entry : this.planeEntity.upgrades.entrySet()) {
            ResourceLocation resourceLocation = entry.getKey();
            Upgrade upgrade = entry.getValue();
            if (!upgrade.isEngine() || resourceLocation == this.getType().getRegistryName()) continue;
            this.planeEntity.upgrades.remove(resourceLocation);
            if (this.shouldDropOld()) {
                NonNullList<ItemStack> items = upgrade.getDrops();
                for (ItemStack item : items) {
                    if (item == null) continue;
                    this.planeEntity.entityDropItem(item);
                }
            }
            this.planeEntity.upgradeChanged();
            return;
        }
        this.planeEntity.setFuel(0);
    }

    public boolean shouldDropOld() {
        return true;
    }
}

