/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.heal;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;

public class HealUpgrade
extends Upgrade {
    private int cooldown = 10;

    public HealUpgrade(PlaneEntity planeEntity) {
        super(SimplePlanesUpgrades.HEAL, planeEntity);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compoundNBT = new NBTTagCompound();
        compoundNBT.func_74768_a("cooldown", this.cooldown);
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(NBTTagCompound compoundNBT) {
        this.cooldown = compoundNBT.func_74762_e("cooldown");
    }

    @Override
    public boolean tick() {
        if (this.cooldown > 0) {
            --this.cooldown;
        } else {
            return true;
        }
        return false;
    }

    @Override
    public void render(float partialticks, float scale) {
    }

    @Override
    public NonNullList<ItemStack> getDrops() {
        return NonNullList.func_191196_a();
    }

    @Override
    public void onApply(ItemStack itemStack, EntityPlayer playerEntity) {
        int m;
        int health = this.planeEntity.getHealth();
        if (health < (m = this.planeEntity.getMaxHealth() * 2)) {
            int heal = this.planeEntity.getOnGround() ? 2 : 1;
            this.planeEntity.setHealth(Math.min(health + heal, m));
        }
        this.planeEntity.health_timer = 0;
    }
}

