/*
 * Decompiled with CFR 0.152.
 */
package com.mcf.davidee.guilib.core;

import com.mcf.davidee.guilib.core.Scrollbar;
import com.mcf.davidee.guilib.core.Widget;
import com.mcf.davidee.guilib.focusable.FocusableWidget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class Container {
    protected final Minecraft mc = Minecraft.func_71410_x();
    protected List<FocusableWidget> focusList;
    protected List<Widget> widgets;
    protected int left;
    protected int right;
    protected int top;
    protected int bottom;
    protected int shiftAmount;
    protected int extraScrollHeight;
    protected int scrollbarWidth;
    protected int cHeight;
    protected int focusIndex;
    protected Scrollbar scrollbar;
    protected Widget lastSelected;
    protected boolean clip;

    public Container(Scrollbar scrollbar, int shiftAmount, int extraScrollHeight) {
        this.scrollbar = scrollbar;
        this.shiftAmount = shiftAmount;
        this.extraScrollHeight = extraScrollHeight;
        this.widgets = new ArrayList<Widget>();
        this.focusList = new ArrayList<FocusableWidget>();
        this.focusIndex = -1;
        this.clip = true;
        if (scrollbar != null) {
            scrollbar.setContainer(this);
            this.scrollbarWidth = scrollbar.width;
        }
    }

    public Container() {
        this(null, 0, 0);
    }

    public void revalidate(int x, int y, int width, int height) {
        this.left = x;
        this.right = x + width;
        this.top = y;
        this.bottom = y + height;
        this.calculateContentHeight();
        if (this.scrollbar != null) {
            this.scrollbar.revalidate(this.top, this.bottom);
            this.scrollbarWidth = this.scrollbar.width;
        }
    }

    public List<Widget> getWidgets() {
        return this.widgets;
    }

    public List<FocusableWidget> getFocusableWidgets() {
        return this.focusList;
    }

    public void addWidgets(Widget ... arr) {
        for (Widget w : arr) {
            this.widgets.add(w);
            if (!(w instanceof FocusableWidget)) continue;
            this.focusList.add((FocusableWidget)w);
        }
        this.calculateContentHeight();
    }

    private void calculateContentHeight() {
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (Widget w : this.widgets) {
            if (!(w instanceof Scrollbar.Shiftable)) continue;
            if (w.y < minY) {
                minY = w.y;
            }
            if (w.y + w.height <= maxY) continue;
            maxY = w.y + w.height;
        }
        this.cHeight = minY > maxY ? 0 : maxY - minY + this.extraScrollHeight;
    }

    public int getContentHeight() {
        return this.cHeight;
    }

    public void update() {
        for (Widget w : this.widgets) {
            w.update();
        }
    }

    public List<Widget> draw(int mx, int my, int scale) {
        if (this.clip) {
            GL11.glEnable((int)3089);
            GL11.glScissor((int)(this.left * scale), (int)(this.mc.field_71440_d - this.bottom * scale), (int)((this.right - this.left - this.scrollbarWidth) * scale), (int)((this.bottom - this.top) * scale));
        }
        ArrayList<Widget> overlays = new ArrayList<Widget>();
        boolean mouseInBounds = this.inBounds(mx, my);
        int widgetX = mouseInBounds || !this.clip ? mx : -1;
        int widgetY = mouseInBounds || !this.clip ? my : -1;
        for (Widget w : this.widgets) {
            if (!w.shouldRender(this.top, this.bottom)) continue;
            w.draw(widgetX, widgetY);
            overlays.addAll(w.getTooltips());
        }
        if (this.clip) {
            GL11.glDisable((int)3089);
        }
        if (this.scrollbar != null && this.scrollbar.shouldRender(this.top, this.bottom)) {
            this.scrollbar.draw(mx, my);
        }
        return overlays;
    }

    public void setFocused(FocusableWidget f) {
        int newIndex;
        int n = newIndex = f == null ? -1 : this.focusList.indexOf((Object)f);
        if (this.focusIndex != newIndex) {
            if (this.focusIndex != -1) {
                this.focusList.get(this.focusIndex).focusLost();
            }
            if (newIndex != -1) {
                this.focusList.get(newIndex).focusGained();
            }
            this.focusIndex = newIndex;
        }
    }

    public boolean inBounds(int mx, int my) {
        return mx >= this.left && my >= this.top && mx < this.right && my < this.bottom;
    }

    public boolean mouseClicked(int mx, int my) {
        if (this.inBounds(mx, my)) {
            boolean resetFocus = true;
            if (this.scrollbar != null && this.scrollbar.shouldRender(this.top, this.bottom) && this.scrollbar.inBounds(mx, my)) {
                return true;
            }
            for (Widget w : this.widgets) {
                if (!w.shouldRender(this.top, this.bottom) || !w.click(mx, my)) continue;
                this.lastSelected = w;
                if (w instanceof FocusableWidget) {
                    this.setFocused((FocusableWidget)w);
                    resetFocus = false;
                }
                w.handleClick(mx, my);
                break;
            }
            if (resetFocus) {
                this.setFocused(null);
            }
            return true;
        }
        return false;
    }

    public FocusableWidget deleteFocused() {
        if (this.hasFocusedWidget()) {
            FocusableWidget w = this.getFocusedWidget();
            if (this.lastSelected == w) {
                this.lastSelected = null;
            }
            this.focusList.remove(this.focusIndex);
            if (this.focusList.size() == 0) {
                this.focusIndex = -1;
            } else {
                this.focusIndex = MathHelper.func_76125_a((int)this.focusIndex, (int)0, (int)(this.focusList.size() - 1));
                this.focusList.get(this.focusIndex).focusGained();
            }
            int index = this.widgets.indexOf((Object)w);
            int offset = Integer.MAX_VALUE;
            for (int i = index + 1; i < this.widgets.size(); ++i) {
                Widget cur = this.widgets.get(i);
                if (!(cur instanceof Scrollbar.Shiftable)) continue;
                if (offset == Integer.MAX_VALUE) {
                    offset = w.getY() - cur.getY();
                }
                ((Scrollbar.Shiftable)((Object)cur)).shiftY(offset);
            }
            this.widgets.remove((Object)w);
            this.calculateContentHeight();
            if (this.scrollbar != null) {
                this.scrollbar.onChildRemoved();
            }
            return w;
        }
        return null;
    }

    public void removeFocusableWidgets() {
        this.focusIndex = -1;
        if (this.lastSelected instanceof FocusableWidget) {
            this.lastSelected = null;
        }
        this.widgets.removeAll(this.focusList);
        this.focusList.clear();
        this.calculateContentHeight();
        if (this.scrollbar != null) {
            this.scrollbar.onChildRemoved();
        }
    }

    public void mouseReleased(int mx, int my) {
        if (this.lastSelected != null) {
            this.lastSelected.mouseReleased(mx, my);
            this.lastSelected = null;
        }
    }

    public boolean hasFocusedWidget() {
        return this.focusIndex != -1;
    }

    public FocusableWidget getFocusedWidget() {
        return this.focusList.get(this.focusIndex);
    }

    public boolean keyTyped(char c, int code) {
        boolean handled;
        boolean bl = handled = this.focusIndex != -1 ? this.focusList.get(this.focusIndex).keyTyped(c, code) : false;
        if (!handled) {
            switch (code) {
                case 200: {
                    this.shift(-1);
                    handled = true;
                    break;
                }
                case 208: {
                    this.shift(1);
                    handled = true;
                    break;
                }
                case 15: {
                    this.shiftFocusToNext();
                    handled = true;
                }
            }
        }
        return handled;
    }

    protected void shiftFocusToNext() {
        int newIndex;
        if (this.focusIndex != -1 && this.focusList.size() > 1 && (newIndex = (this.focusIndex + 1) % this.focusList.size()) != this.focusIndex) {
            this.focusList.get(this.focusIndex).focusLost();
            this.focusList.get(newIndex).focusGained();
            if (this.scrollbar != null && this.scrollbar.shouldRender(this.top, this.bottom)) {
                this.scrollbar.shift((this.focusIndex - newIndex) * this.shiftAmount);
            }
            this.focusIndex = newIndex;
        }
    }

    protected void shiftFocus(int newIndex) {
        if (this.focusIndex != newIndex) {
            this.focusList.get(this.focusIndex).focusLost();
            this.focusList.get(newIndex).focusGained();
            if (this.scrollbar != null && this.scrollbar.shouldRender(this.top, this.bottom)) {
                this.scrollbar.shift((this.focusIndex - newIndex) * this.shiftAmount);
            }
            this.focusIndex = newIndex;
        }
    }

    protected void shift(int delta) {
        if (this.focusIndex != -1) {
            this.shiftFocus(MathHelper.func_76125_a((int)(this.focusIndex + delta), (int)0, (int)(this.focusList.size() - 1)));
        } else if (this.scrollbar != null && this.scrollbar.shouldRender(this.top, this.bottom)) {
            this.scrollbar.shiftRelative(delta * -4);
        }
    }

    public void mouseWheel(int delta) {
        if (this.scrollbar != null && this.scrollbar.shouldRender(this.top, this.bottom)) {
            this.scrollbar.shiftRelative(delta);
        } else {
            boolean done = false;
            if (this.focusIndex != -1) {
                done = this.focusList.get(this.focusIndex).mouseWheel(delta);
            } else {
                Iterator<Widget> it = this.widgets.iterator();
                while (it.hasNext() && !done) {
                    done = it.next().mouseWheel(delta);
                }
            }
        }
    }

    public void setClipping(boolean clip) {
        this.clip = clip;
    }

    public boolean isClipping() {
        return this.clip;
    }

    public int left() {
        return this.left;
    }

    public int right() {
        return this.right;
    }

    public int top() {
        return this.top;
    }

    public int bottom() {
        return this.bottom;
    }
}

