/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.mod.client.proxy;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mcf.davidee.paintinggui.gui.PaintingButton;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import subaraki.paintings.config.ConfigurationHandler;
import subaraki.paintings.mod.IPaintingsProxy;
import subaraki.paintings.mod.Paintings;
import subaraki.paintings.mod.PaintingsPattern;
import subaraki.paintings.mod.entity.EntityNewPainting;
import subaraki.paintings.mod.entity.client.RenderPaintingLate;

public class ClientProxy
implements IPaintingsProxy {
    @Override
    public void registerRenderInformation() {
        RenderingRegistry.registerEntityRenderingHandler(EntityNewPainting.class, RenderPaintingLate::new);
    }

    @Override
    public JsonObject getPatternFile(String patternName) {
        try {
            return this.loadJsonResource(new ResourceLocation("subaraki", "patterns/" + ConfigurationHandler.instance.texture + ".json"));
        }
        catch (Exception e) {
            Paintings.log.error("Failed to read " + patternName + ".json. Make sure the pattern exists in an imported resource pack and is correctly identified in the configuration.\nSystem Message:\n" + e.getLocalizedMessage());
            try {
                Paintings.log.info("Attempting to load vanilla pattern.");
                ConfigurationHandler.instance.texture = "vanilla";
                return this.loadJsonResource(new ResourceLocation("subaraki", "patterns/vanilla.json"));
            }
            catch (Exception e2) {
                Paintings.log.fatal("Failed to load vanilla pattern.\n" + e2.getLocalizedMessage());
                return null;
            }
        }
    }

    private JsonObject loadJsonResource(ResourceLocation loc) throws Exception {
        InputStream in = Minecraft.func_71410_x().func_110442_L().func_110536_a(loc).func_110527_b();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        Gson gson = new Gson();
        JsonElement je = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
        return je.getAsJsonObject();
    }

    @Override
    public void configurePaintingsGuiButtonTexture() {
        PaintingsPattern.instance.texture = ConfigurationHandler.instance.texture.equals("vanilla") ? new ResourceLocation("textures/painting/paintings_kristoffer_zetterstrand.png") : new ResourceLocation("subaraki", "art/" + ConfigurationHandler.instance.texture + ".png");
        PaintingsPattern.instance.errorTex = new ResourceLocation("subaraki", "art/errored.png");
        PaintingButton.KZ_WIDTH = PaintingsPattern.instance.getSize().width * 16;
        PaintingButton.KZ_HEIGHT = PaintingsPattern.instance.getSize().height * 16;
    }
}

